/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.rules;

import java.awt.Component;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import oracle.tip.tools.ide.common.bpel.shared.util.Helper;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;
import oracle.tip.tools.ide.rules.editor.util.RulesSDKUtil;
import oracle.tip.tools.ide.rules.i18n.StringTranslator;

class BusinessRuleAdvancedPanel
extends Panel {
    private TextField decisionFunctionTextField;
    private TextField packageTextField;
    private static final String SUFIX_FUNCTION_NAME = "_DecisionService";

    BusinessRuleAdvancedPanel(UiContainer parent, FlowNode flowNode, String defaultPakage, IdentifierTextField nameTextField) {
        super(parent);
        this.init(flowNode, defaultPakage, nameTextField);
    }

    public void applyToWizardData(WizardData data) {
        data.setPackageName(this.getPackageName());
        data.setServiceName(this.getDecisionFunctionName());
    }

    boolean validateData() {
        String pkgName = this.getPackageName();
        if (Helper.hasValue((String)pkgName) && !RulesSDKUtil.isValidName((String)pkgName)) {
            GraphUtils.displayMessage((Component)this.asSwing(), (String)StringTranslator.getString((String)"RULE_CREATION_DIALOG_INVALID_PACKAGE_NAME"), (int)0);
            return false;
        }
        return true;
    }

    private static String getDefaultDecisionFunctionName(String name) {
        return name + SUFIX_FUNCTION_NAME;
    }

    private String getPackageName() {
        return this.packageTextField.getText().trim();
    }

    private String getDecisionFunctionName() {
        return this.decisionFunctionTextField.getText().trim();
    }

    private void init(FlowNode flowNode, String defaultPackage, final IdentifierTextField nameTextField) {
        this.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 5"));
        this.packageTextField = new TextField((UiContainer)this, defaultPackage, 30);
        this.decisionFunctionTextField = new TextField((UiContainer)this, BusinessRuleAdvancedPanel.getDefaultDecisionFunctionName(nameTextField.getText()), 30);
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectModelMsg.PACKAGE));
        this.add((UiComponent)this.packageTextField, "growx, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectMsg.DECISION_FUNCTION));
        this.add((UiComponent)this.decisionFunctionTextField, "growx, wrap");
        nameTextField.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                BusinessRuleAdvancedPanel.this.updatDecisionFunction(nameTextField.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                BusinessRuleAdvancedPanel.this.updatDecisionFunction(nameTextField.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                BusinessRuleAdvancedPanel.this.updatDecisionFunction(nameTextField.getText());
            }
        });
    }

    private void updatDecisionFunction(String name) {
        this.decisionFunctionTextField.setText(BusinessRuleAdvancedPanel.getDefaultDecisionFunctionName(name));
    }
}

