/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.ui;

import java.awt.Component;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.fusion.soa.mds.MdsArtifactType;
import oracle.bpm.fusion.soa.mds.MdsFolderNode;
import oracle.bpm.fusion.soa.mds.MdsNodeFactory;
import oracle.bpm.fusion.soa.mds.MdsNodeNavigator;
import oracle.bpm.fusion.soa.mds.MdsProjectFolderTreeNode;
import oracle.bpm.fusion.soa.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.action.CreateMdsFolderAction;
import oracle.bpm.fusion.soa.mds.action.DeleteMdsFolderAction;
import oracle.bpm.fusion.soa.mds.command.RefreshMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.model.MDSSecurityUtils;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.metadata.persistence.ArtifactLocationMismatchException;
import oracle.bpm.pml.security.exception.PmlSecurityPermissionDeniedException;
import oracle.bpm.pml.security.exception.PmlSecurityProjectAlreadyExistsException;
import oracle.bpm.project.io.FileSystemTokens;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.text.FilteredTextField;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TextFilter;
import oracle.bpm.ui.text.filter.ValidFileFilter;
import oracle.bpm.ui.tree.TreeBasePanel;
import oracle.bpm.ui.tree.TreeNode;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import org.jetbrains.annotations.NotNull;

public class PublishMdsProjectDialog
extends OkCancelDialog {
    private TextArea descriptionText;
    private MdsFolderTreePanel mdsFolderTreePanel;
    private CheckBox overwriteCheckBox;
    private Project project;
    private TextField projectNameTextField;

    public PublishMdsProjectDialog(UiWindow parent, Project project) {
        super(parent, FusionStudioMsg.PUBLISH_PROJECT_TO_MDS, true);
        this.project = project;
        this.buildUi();
    }

    public void ok() {
        if (!this.validateValues()) {
            return;
        }
        FuegoWorker.post((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)PublishMdsProjectDialog.this.getContentPane().asSwing(), FusionStudioMsg.PUBLISHING_PROJECT.toString());
                progressMonitor.setCancellable(false);
                progressMonitor.start();
                try {
                    ProjectFolder folder = PublishMdsProjectDialog.this.getProjectLocation();
                    if (PublishMdsProjectDialog.this.project.isTemplate()) {
                        PublishMdsProjectDialog.this.publishTemplateProject(folder);
                    } else {
                        PublishMdsProjectDialog.this.publishPublicShareProject(folder);
                    }
                    PublishMdsProjectDialog.this.setVisible(false);
                }
                catch (ArtifactLocationMismatchException e) {
                    MdsLogger.getInstance().logStackTrace(e);
                    MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_PUBLISHING_TO_MDS((String)e.getMessage()));
                }
                catch (PmlSecurityProjectAlreadyExistsException e) {
                    MdsLogger.getInstance().logStackTrace(e);
                    MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_PUBLISHING_TO_MDS((String)e.getMessage()));
                }
                catch (MetadataException e) {
                    MdsLogger.getInstance().logMessage(e.getStackTraceString());
                    MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_PUBLISHING_TO_MDS((String)e.getMessage()));
                    PublishMdsProjectDialog.this.setVisible(false);
                }
                finally {
                    progressMonitor.finish();
                }
            }
        });
    }

    MdsNodeNavigator getMdsNodeNavigator() {
        return MdsProjectNavigatorManager.getInstance().getMdsNodeNavigator();
    }

    private boolean validateValues() {
        String projectName = this.getProjectName();
        if (Str.isEmpty(projectName)) {
            MessageDialog.showError((Msg)FusionStudioMsg.PROJECT_NAME_CANNOT_BE_EMPTY);
            return false;
        }
        if (this.project.isTemplate()) {
            try {
                oracle.bpm.pml.service.StudioMetadataService metadataService = StudioMetadataService.getInstance().getService();
                if (metadataService.existsProject(TemplateProject.class, ProjectFolder.create((ProjectFolder)this.getProjectLocation(), (String)this.getProjectName())) && !this.overwriteCheckBox.isSelected()) {
                    MessageDialog.showError((Msg)FusionStudioMsg.PROJECT_ALREADY_EXIST);
                    return false;
                }
            }
            catch (MetadataException e) {
                MdsLogger.getInstance().logMessage(e.getStackTraceString());
            }
        }
        return true;
    }

    private void buildUi() {
        Panel mainPanel = new Panel(this.getContentPane());
        StandardForm layout = FormsFactory.createStandardForm((UiContainer)mainPanel);
        Label projectNameLabel = Label.create((UiContainer)mainPanel, (Msg)DesignerMsg.PROJECT_NAME);
        this.projectNameTextField = new FilteredTextField((UiContainer)mainPanel, (TextFilter)new ValidFileFilter(FileSystemTokens.MAX_FILE_NAME_LENGTH, false){

            public boolean accepts(String str, int offs) {
                return (offs != 0 || str.length() <= 0 || !Character.isDigit(str.charAt(offs))) && super.accepts(str, offs);
            }
        }, this.project.getName(), 20);
        Label descriptionLabel = Label.create((UiContainer)mainPanel, (Msg)ProjectMsg.DESCRIPTION);
        this.descriptionText = new TextArea((UiContainer)mainPanel);
        this.populateDescriptionField();
        this.overwriteCheckBox = CheckBox.create((UiContainer)mainPanel, (Msg)FusionStudioMsg.OVERWRITE);
        try {
            MdsFolderNode folderNode = this.getRootObject(this.project);
            this.mdsFolderTreePanel = new MdsFolderTreePanel((UiContainer)mainPanel, folderNode, this.getMdsNodeNavigator());
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logMessage(e.getStackTraceString());
            MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_LOADING_PROJECTS, (Throwable)e);
        }
        layout.add((UiComponent)projectNameLabel);
        layout.add((UiComponent)this.projectNameTextField);
        layout.add((UiComponent)descriptionLabel);
        layout.add((UiComponent)this.descriptionText);
        if (this.project.isTemplate()) {
            layout.add((UiComponent)this.overwriteCheckBox);
        }
        layout.add((UiComponent)this.mdsFolderTreePanel);
        this.getContentPane().add((UiComponent)mainPanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private void populateDescriptionField() {
        try {
            String description = null;
            if (this.project.isTemplate()) {
                TemplateProject templateProject = this.findTemplateProject();
                if (templateProject != null) {
                    description = templateProject.getDescription();
                }
            } else {
                PublicShareProject publicShareProject = this.findPublicShareProject();
                if (publicShareProject != null) {
                    description = publicShareProject.getDescription();
                }
            }
            this.descriptionText.setText(description);
        }
        catch (PmlSecurityPermissionDeniedException e) {
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logMessage(e.getStackTraceString());
            MessageDialog.showError((Msg)e.getKey());
        }
    }

    private TemplateProject findTemplateProject() throws MetadataException {
        return this.findProject(TemplateProject.class);
    }

    private <T extends MdProject> T findProject(@NotNull Class<T> type) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ui/PublishMdsProjectDialog.findProject must not be null");
        }
        oracle.bpm.pml.service.StudioMetadataService metadataService = StudioMetadataService.getInstance().getService();
        ProjectFolder projectFolder = metadataService.findProjectByName(type, this.project.getName());
        MdProject mdProject = null;
        if (projectFolder != null) {
            mdProject = (MdProject)metadataService.loadProject(type, projectFolder.getLocation()).get();
        }
        return (T)mdProject;
    }

    private PublicShareProject findPublicShareProject() throws MetadataException {
        return this.findProject(PublicShareProject.class);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void publishPublicShareProject(ProjectFolder folder) throws MetadataException {
        oracle.bpm.pml.service.StudioMetadataService metadataService = StudioMetadataService.getInstance().getService();
        LocalRef<PublicShareProject> mdsPublicShareProject = this.getProject(folder.getLocation() + "/" + this.getProjectName());
        if (mdsPublicShareProject == null) {
            PublicShareProject publicShare = new PublicShareProject(this.getProjectName(), this.getDescription(), this.project);
            publicShare.setAllowSharing(true);
            PublicShareProject projectPublished = metadataService.savePublicShare(folder, publicShare, false, false);
            MdsProjectNavigatorManager.getInstance().addProjectArtifact(MdsArtifactType.PUBLIC_SHARE, (ProjectArtifact)projectPublished);
            return;
        }
        boolean letsPublish = false;
        if (MDSSecurityUtils.isNotShared(this.project)) {
            MessageDialog.showError((Msg)FusionStudioMsg.PROJECT_ALREADY_EXISTS_IN_THE_REPOSITORY);
            return;
        }
        if (!((PublicShareProject)mdsPublicShareProject.get()).isEditable()) {
            MessageDialog.showError((Msg)FusionStudioMsg.LACK_PERMISSIONS_TO_PUBLISH);
            return;
        }
        boolean keepLock = false;
        if (((PublicShareProject)mdsPublicShareProject.get()).isLocked()) {
            if (!MDSSecurityUtils.hasUserLoggedLock((PublicShareProject)mdsPublicShareProject.get())) {
                MessageDialog.showError((Msg)FusionStudioMsg.CANNOT_PUBLISH_PROJECT_IS_LOCKED);
                return;
            }
            letsPublish = true;
            keepLock = MessageDialog.showQuestion((Msg)FusionStudioMsg.PUBLISH_PROJECT_TO_MDS, (Msg)FusionStudioMsg.ASK_FOR_RELEASING_LOCK_AFTER_PUBLISHING, (int)6) == 4;
        } else {
            letsPublish = true;
        }
        if (!letsPublish) return;
        PublicShareProject publicShare = new PublicShareProject(this.getProjectName(), this.getDescription(), this.project);
        publicShare.setAllowSharing(true);
        PublicShareProject projectPublished = metadataService.savePublicShare(folder, publicShare, true, keepLock);
        MdsProjectNavigatorManager.getInstance().addProjectArtifact(MdsArtifactType.PUBLIC_SHARE, (ProjectArtifact)projectPublished);
        new RefreshMdsProjectCommand().execute();
    }

    private LocalRef<PublicShareProject> getProject(String fullProjectPath) throws MetadataException {
        LocalRef ret = null;
        try {
            ProjectFolder projectFolder = ProjectFolder.create((String)fullProjectPath);
            if (StudioMetadataService.getInstance().getService().existsProject(PublicShareProject.class, projectFolder)) {
                ret = StudioMetadataService.getInstance().getService().loadProject(PublicShareProject.class, fullProjectPath);
            }
        }
        catch (ProjectNotFoundException projectNotFoundException) {
            // empty catch block
        }
        return ret;
    }

    private void publishTemplateProject(ProjectFolder folder) throws MetadataException {
        oracle.bpm.pml.service.StudioMetadataService metadataService = StudioMetadataService.getInstance().getService();
        TemplateProject mdsProject = new TemplateProject(this.getProjectName(), this.getDescription(), this.project);
        mdsProject = metadataService.saveTemplateProject(folder, mdsProject, this.overwriteCheckBox.isSelected(), true);
        MdsProjectNavigatorManager.getInstance().addProjectArtifact(MdsArtifactType.TEMPLATE, (ProjectArtifact)mdsProject);
    }

    private MdsFolderNode getRootObject(Project project) throws MetadataException {
        return project.isTemplate() ? this.getMdsNodeNavigator().getTemplatesFolderNode() : this.getMdsNodeNavigator().getPublicSharesFolderNode();
    }

    private ProjectFolder getProjectLocation() {
        if (this.mdsFolderTreePanel.getSelectedNode().length == 1) {
            MdsFolderNode selectedMdsFolderNode = (MdsFolderNode)this.mdsFolderTreePanel.getSelectedNode()[0].getUserObject();
            return selectedMdsFolderNode.isDefault() ? ProjectFolder.create((String)"/") : (ProjectFolder)selectedMdsFolderNode.as(ProjectFolder.class);
        }
        return ProjectFolder.create((String)"/");
    }

    private String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private String getDescription() {
        return this.descriptionText.getText();
    }

    private class MdsFolderTreePanel
    extends TreeBasePanel {
        public MdsFolderTreePanel(UiContainer parent, MdsFolderNode rootObject, MdsNodeNavigator mdsNodeNavigator) {
            super(parent, FusionStudioMsg.MDS_PROJECT_LOCATION);
            this.init(rootObject, mdsNodeNavigator);
        }

        protected void addAction(@NotNull TreeNode selectedNode) {
            if (selectedNode == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ui/PublishMdsProjectDialog$MdsFolderTreePanel.addAction must not be null");
            }
            MdsFolderNode parentMdsFolderNode = (MdsFolderNode)selectedNode.getUserObject();
            CreateMdsFolderAction createMdsFolderAction = new CreateMdsFolderAction(parentMdsFolderNode);
            createMdsFolderAction.run();
            ProjectFolder newProjectFolder = createMdsFolderAction.getProjectFolderCreated();
            if (newProjectFolder != null) {
                StudioNode<ProjectArtifact> newMdsFolderNode = MdsNodeFactory.getInstance().createNode((ProjectArtifact)newProjectFolder);
                TreeNode newTreeNode = selectedNode.addDynamic(newMdsFolderNode);
                MdsFolderNode mdsFolderNode = (MdsFolderNode)newTreeNode.getUserObject();
                mdsFolderNode.setParent((MdsFolderNode)selectedNode.getUserObject());
                mdsFolderNode.setDefault(false);
                newTreeNode.select();
            }
        }

        protected void deleteAction(@NotNull TreeNode selectedNode) {
            if (selectedNode == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ui/PublishMdsProjectDialog$MdsFolderTreePanel.deleteAction must not be null");
            }
            MdsFolderNode mdsFolderNode = (MdsFolderNode)selectedNode.getUserObject();
            DeleteMdsFolderAction deleteMdsFolderAction = new DeleteMdsFolderAction(mdsFolderNode);
            deleteMdsFolderAction.run();
            if (deleteMdsFolderAction.wasDeleted()) {
                super.deleteAction(selectedNode);
            }
        }

        private void init(MdsFolderNode rootObject, MdsNodeNavigator mdsNodeNavigator) {
            MdsProjectFolderTreeNode node = (MdsProjectFolderTreeNode)TreeNode.createDynamic((Object)rootObject);
            node.setMdsNodeNavigator(mdsNodeNavigator);
            this.setRoot(node);
        }
    }
}

