/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.ui;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.action.ActionCancelledListener;
import oracle.bpm.fusion.soa.mds.action.AddSnapshotAction;
import oracle.bpm.fusion.soa.mds.action.DeleteSnapshotAction;
import oracle.bpm.fusion.soa.mds.action.ExportProjectSnapshotAction;
import oracle.bpm.fusion.soa.mds.model.MDSSecurityUtils;
import oracle.bpm.fusion.soa.mds.ui.GregorianCalendarLabelProvider;
import oracle.bpm.fusion.soa.mds.ui.IndProgressMonitorRunnableDecorator;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.SnapshotProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ProjectSnapshotsTable
extends BaseTablePanel {
    private ActionCancelledListener actionCancelledListener;
    private ColorProvider colorProvider;
    private ExportProjectSnapshotAction exportSnapshotAction;
    private PublicShareProject mdProject;
    private BaseAction refreshSnapshotsAction;
    private static final MsgList SNAPSHOTS_TABLE_COLUMNS = MsgList.create(FusionStudioMsg.NAME, FusionStudioMsg.DATE, FusionStudioMsg.AUTHOR, FusionStudioMsg.DESCRIPTION);

    public ProjectSnapshotsTable(UiContainer parent, @NotNull PublicShareProject mdProject) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ui/ProjectSnapshotsTable.<init> must not be null");
        }
        super(parent, null, null, (TableModel)new SnapshotsTableModel((MdProject)mdProject), BaseTablePanel.Style.TOOLBAR_TOP, ListSelectionMode.SINGLE_SELECTION);
        this.mdProject = mdProject;
        SnapshotsTableModel model = new SnapshotsTableModel((MdProject)mdProject, this.getSnapshots());
        this.setModel(model);
        this.getTable().getColumn(SNAPSHOTS_TABLE_COLUMNS.indexOf(FusionStudioMsg.DATE)).setLabelProvider((LabelProvider)GregorianCalendarLabelProvider.getInstance());
    }

    public void setActionsCancelledListener(@NotNull ActionCancelledListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ui/ProjectSnapshotsTable.setActionsCancelledListener must not be null");
        }
        this.actionCancelledListener = l;
    }

    protected void deleteAction() {
        int[] selectedRows = this.getTable().getSelectedRows();
        List selectedSnapshots = this.getModel().getRows(selectedRows);
        try {
            for (LocalRef selectedSnapshot : selectedSnapshots) {
                DeleteSnapshotAction deleteSnapshotAction = new DeleteSnapshotAction((LocalRef<SnapshotProject>)selectedSnapshot);
                deleteSnapshotAction.addActionCancelledListener(this.actionCancelledListener);
                deleteSnapshotAction.run();
                this.getModel().removeRow(selectedSnapshot);
            }
            this.updateSelection(selectedRows);
        }
        catch (ExecutionException e) {
            MdsLogger.getInstance().logStackTrace(e);
            MessageDialog.showError((Msg)UIMsg.TO_MSG((String)e.getMessage()));
        }
    }

    protected boolean showRemoveAction() {
        return this.getModel().getMdProject().isEditable();
    }

    protected void addAction() {
        AddSnapshotAction addSnapshotAction = new AddSnapshotAction(this.mdProject, this.getModel().getData());
        addSnapshotAction.addActionCancelledListener(this.actionCancelledListener);
        addSnapshotAction.run();
        LocalRef<SnapshotProject> snapshot = addSnapshotAction.getSnapshot();
        if (snapshot != null) {
            this.getModel().addRow(snapshot);
        }
    }

    protected boolean showAddAction() {
        return this.getModel().getMdProject().isEditable();
    }

    protected SnapshotsTableModel getModel() {
        return (SnapshotsTableModel)super.getModel();
    }

    protected void selectionChanged(int[] selectedRows) {
        super.selectionChanged(selectedRows);
        if (this.exportSnapshotAction != null) {
            if (selectedRows.length == 1) {
                LocalRef selectedSnapshot = (LocalRef)this.getModel().getRow(selectedRows[0]);
                this.exportSnapshotAction.addActionCancelledListener(this.actionCancelledListener);
                this.exportSnapshotAction.setSnapshotProject((LocalRef<SnapshotProject>)selectedSnapshot);
                this.exportSnapshotAction.setEnabled(true);
                this.getRemoveAction().setEnabled(this.getRemoveAction().isEnabled() && (MDSSecurityUtils.isUserLoggedSnapshotOwner((SnapshotProject)selectedSnapshot.get()) || this.mdProject.isManageable()));
            } else {
                this.exportSnapshotAction.setEnabled(false);
            }
        }
    }

    protected boolean showRefreshAction() {
        return true;
    }

    protected void refreshAction() {
        IndProgressMonitorRunnableDecorator monitor = new IndProgressMonitorRunnableDecorator(this.asSwing(), FusionStudioMsg.REFRESHING_SNAPSHOTS, new Runnable(){

            @Override
            public void run() {
                ProjectSnapshotsTable.this.getModel().removeAllElements();
                ProjectSnapshotsTable.this.getModel().addRows(ProjectSnapshotsTable.this.getSnapshots());
            }
        });
        monitor.run();
    }

    protected BaseAction[] getUserActions() {
        this.exportSnapshotAction = new ExportProjectSnapshotAction();
        this.exportSnapshotAction.setEnabled(false);
        return new BaseAction[]{this.exportSnapshotAction};
    }

    private List<LocalRef<SnapshotProject>> getSnapshots() {
        try {
            return StudioMetadataService.getInstance().getService().listSnapshots(this.mdProject.getId());
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logStackTrace(e);
            MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_OBTAINING_SNAPSHOTS);
            return new ArrayList<LocalRef<SnapshotProject>>();
        }
    }

    static class SnapshotsTableModel
    extends ProviderTableModel<LocalRef<SnapshotProject>> {
        private MdProject mdProject;

        public SnapshotsTableModel(MdProject mdProject) {
            this(mdProject, null);
        }

        public SnapshotsTableModel(MdProject mdProject, List<LocalRef<SnapshotProject>> snapshots) {
            super(SNAPSHOTS_TABLE_COLUMNS, snapshots);
            this.mdProject = mdProject;
        }

        public Object getValueAt(int row, int column) {
            SnapshotProject snapshotProject = (SnapshotProject)((LocalRef)this.getData().get(row)).get();
            switch (column) {
                case 0: {
                    return snapshotProject.getName();
                }
                case 1: {
                    return snapshotProject.getCreationTimestamp();
                }
                case 2: {
                    return snapshotProject.getOwnerName();
                }
                case 3: {
                    return snapshotProject.getDescription();
                }
            }
            return null;
        }

        public MdProject getMdProject() {
            return this.mdProject;
        }
    }
}

