/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.ui;

import java.awt.Component;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.EmptyNameValidator;
import oracle.bpm.designer.validator.StringValidator;
import oracle.bpm.designer.validator.Validator;
import oracle.bpm.fusion.soa.mds.MdsFolderNode;
import oracle.bpm.fusion.soa.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.text.TextField;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import org.jetbrains.annotations.NotNull;

public class CreateMdsFolderDialog
extends OkCancelDialog {
    private TextField nameTextField;
    private MdsFolderNode parentFolderNode;
    private ProjectFolder projectFolderCreated;

    public CreateMdsFolderDialog(@NotNull MdsFolderNode parentFolderNode, Msg title) {
        if (parentFolderNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ui/CreateMdsFolderDialog.<init> must not be null");
        }
        super(Ui.getRoot(), title);
        this.parentFolderNode = parentFolderNode;
        this.buildUi();
    }

    public ProjectFolder getProjectFolderCreated() {
        return this.projectFolderCreated;
    }

    public void ok() {
        final String folderName = this.nameTextField.getText();
        Msg validationMessage = this.getValidator().validate((Object)folderName);
        if (validationMessage != null) {
            MessageDialog.showError((Msg)validationMessage);
            return;
        }
        FuegoWorker.post((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)CreateMdsFolderDialog.this.getContentPane().asSwing(), FusionStudioMsg.CREATING_FOLDER.toString());
                progressMonitor.setCancellable(false);
                progressMonitor.start();
                try {
                    if (CreateMdsFolderDialog.this.parentFolderNode.isDefault()) {
                        CreateMdsFolderDialog.this.projectFolderCreated = ProjectFolder.create((String)("/" + folderName));
                    } else {
                        CreateMdsFolderDialog.this.projectFolderCreated = ProjectFolder.create((ProjectFolder)((ProjectFolder)CreateMdsFolderDialog.this.parentFolderNode.as(ProjectFolder.class)), (String)folderName);
                    }
                    StudioMetadataService.getInstance().getService().createFolder(CreateMdsFolderDialog.this.parentFolderNode.getType().getClassType(), CreateMdsFolderDialog.this.projectFolderCreated);
                    MdsProjectNavigatorManager.getInstance().addProjectArtifact(CreateMdsFolderDialog.this.parentFolderNode.getType(), (ProjectArtifact)CreateMdsFolderDialog.this.projectFolderCreated);
                }
                catch (MetadataException e) {
                    MdsLogger.getInstance().logStackTrace(e);
                    MessageDialog.showError((Throwable)e);
                    CreateMdsFolderDialog.this.projectFolderCreated = null;
                }
                finally {
                    CreateMdsFolderDialog.this.setVisible(false);
                    progressMonitor.finish();
                }
            }
        });
    }

    private void buildUi() {
        StandardForm form = FormsFactory.createStandardForm((UiContainer)this.getContentPane());
        this.nameTextField = new TextField(this.getContentPane());
        form.add(DesignerMsg.NAME, (UiComponent)this.nameTextField);
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private CompositeValidator<String> getValidator() {
        CompositeValidator validator = new CompositeValidator();
        validator.addValidator((Validator)new EmptyNameValidator());
        validator.addValidator((Validator)new ValidCharactersValidator());
        return validator;
    }

    private class ValidCharactersValidator
    extends StringValidator {
        private ValidCharactersValidator() {
        }

        public Msg validate(String objectToAdd) {
            for (int i = 0; i < objectToAdd.length(); ++i) {
                int c = objectToAdd.codePointAt(i);
                if (this.checkChar(c)) continue;
                return DesignerMsg.OBJECT_NAME_CANNOT_CONTAIN((String)("'" + objectToAdd.charAt(i) + "'"));
            }
            return null;
        }

        private boolean checkChar(int c) {
            return Character.isLetterOrDigit(c) || c == 95;
        }
    }
}

