/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.ui;

import java.awt.Component;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.fusion.soa.mds.command.CheckoutMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.command.LockMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.model.MDSSecurityUtils;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.project.ui.ProjectNamePanel;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.msg.UIMsg;
import oracle.ide.model.Project;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class CheckoutMdsProjectDialog
extends OkCancelDialog {
    private MdProject<? extends ProjectArtifact> mdsProject;
    private ProjectNamePanel projectNamePanel;

    public CheckoutMdsProjectDialog(UiWindow parent, MdProject<? extends ProjectArtifact> mdsProject) {
        super(parent, FusionStudioMsg.CHECKOUT_MDS_PROJECT, true);
        this.mdsProject = mdsProject;
        this.buildUi();
    }

    public void ok() {
        String projectName = this.projectNamePanel.getProjectName();
        Project existentJdevProject = FusionProjectRepository.findExistentJdevProject((String)(projectName + ".jpr"));
        if (existentJdevProject != null) {
            MessageDialog.showNotice((Msg)FusionStudioMsg.CHECKOUT_MDS_PROJECT, (Msg)FusionStudioMsg.PROJECT_ALREADY_EXISTS_REPLACE_IT);
            return;
        }
        FuegoWorker.post((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)CheckoutMdsProjectDialog.this.getContentPane().asSwing(), FusionStudioMsg.CHECKING_OUT_PROJECT.toString());
                progressMonitor.setCancellable(false);
                progressMonitor.start();
                try {
                    oracle.bpm.project.model.Project project = (oracle.bpm.project.model.Project)CheckoutMdsProjectDialog.this.mdsProject.getProject().get();
                    boolean isTemplate = project.isTemplate();
                    if (!isTemplate) {
                        PublicShareProject publicShareProject = (PublicShareProject)CheckoutMdsProjectDialog.this.mdsProject;
                        if (!publicShareProject.isLocked()) {
                            if (publicShareProject.isEditable()) {
                                new LockMdsProjectCommand(publicShareProject).execute();
                            }
                        } else if (!MDSSecurityUtils.hasUserLoggedLock(publicShareProject)) {
                            MessageDialog.showWarning((Msg)FusionStudioMsg.ANOTHER_USER_HAVE_THE_LOCK);
                        }
                    }
                    new CheckoutMdsProjectCommand((MdProject<? extends ProjectArtifact>)CheckoutMdsProjectDialog.this.mdsProject).execute();
                }
                catch (MetadataException e) {
                    MdsLogger.getInstance().logStackTrace(e);
                    MessageDialog.showError((Throwable)e);
                }
                catch (ExecutionException e) {
                    MdsLogger.getInstance().logStackTrace(e);
                    MessageDialog.showError((Msg)UIMsg.TO_MSG((String)e.getMessage()));
                }
                finally {
                    CheckoutMdsProjectDialog.this.setVisible(false);
                    progressMonitor.finish();
                }
            }
        });
    }

    private void buildUi() {
        StandardForm standardForm = FormsFactory.createStandardForm((UiContainer)this.getContentPane());
        this.projectNamePanel = new ProjectNamePanel(this.getContentPane(), this.getInitialProjectName());
        standardForm.add((UiComponent)this.projectNamePanel);
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private String getInitialProjectName() {
        return this.mdsProject.getName();
    }
}

