/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.ui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.ui.ArtifactImageHelper;
import oracle.bpm.fusion.soa.mds.ui.IndProgressMonitorRunnableDecorator;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.history.Criteria;
import oracle.bpm.metadata.history.LogicalArtifactRecognizer;
import oracle.bpm.metadata.history.model.Change;
import oracle.bpm.metadata.history.model.ChangeAction;
import oracle.bpm.metadata.history.model.ChangedFile;
import oracle.bpm.metadata.history.model.ChangedItem;
import oracle.bpm.metadata.history.model.LogicalArtifactType;
import oracle.bpm.metadata.history.msg.HistoryMsgHelper;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;

public class ChangesHistoryPanel
extends Panel {
    private TabbedPane affectedComponentsTabbedPane;
    private LabelProvider<LogicalArtifactType> artifactLabelProvider;
    private Table artifactsTable;
    private ArtifactsTableModel artifactsTableModel;
    private LabelProvider<Date> dateLabelProvider;
    private LabelProvider<ChangedFile> fileLabelProvider;
    private Table filesTable;
    private FilesTableModel filesTableModel;
    private Table historyTable;
    private HistoryTableModel historyTableModel;
    private MdProject<? extends ProjectArtifact> mdProject;
    private LabelProvider<ChangeAction> operationLabelProvider;
    private static MsgList HISTORY_TABLE_COLUMNS = MsgList.create(FusionStudioMsg.DATA, FusionStudioMsg.AUTHOR, FusionStudioMsg.COMMENT);

    public ChangesHistoryPanel(UiContainer parent, MdProject<? extends ProjectArtifact> mdProject) {
        super(parent);
        this.mdProject = mdProject;
        this.buildUi();
    }

    public LabelProvider<ChangeAction> getOperationLabelProvider() {
        if (this.operationLabelProvider == null) {
            this.operationLabelProvider = new LabelProvider<ChangeAction>(){

                public Image getIcon(ChangeAction element) {
                    switch (element) {
                        case ADDED: {
                            return Image.create((Msg)FusionStudioMsg.HISTORY_ADD);
                        }
                        case DELETED: {
                            return Image.create((Msg)FusionStudioMsg.HISTORY_DELETE);
                        }
                        case MODIFIED: {
                            return Image.create((Msg)FusionStudioMsg.HISTORY_EDIT);
                        }
                    }
                    return null;
                }

                public String getText(ChangeAction element) {
                    return null;
                }
            };
        }
        return this.operationLabelProvider;
    }

    public LabelProvider<Date> getDateLabelProvider() {
        if (this.dateLabelProvider == null) {
            this.dateLabelProvider = new LabelProvider<Date>(){

                public Image getIcon(Date element) {
                    return null;
                }

                public String getText(Date element) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    return dateFormat.format(element);
                }
            };
        }
        return this.dateLabelProvider;
    }

    public LabelProvider<LogicalArtifactType> getArtifactLabelProvider() {
        if (this.artifactLabelProvider == null) {
            this.artifactLabelProvider = new LabelProvider<LogicalArtifactType>(){

                public Image getIcon(LogicalArtifactType element) {
                    return ArtifactImageHelper.getInstance().resolveImage(element);
                }

                public String getText(LogicalArtifactType element) {
                    return null;
                }
            };
        }
        return this.artifactLabelProvider;
    }

    public LabelProvider<ChangedFile> getFileLabelProvider() {
        if (this.fileLabelProvider == null) {
            this.fileLabelProvider = new LabelProvider<ChangedFile>(){

                public Image getIcon(ChangedFile element) {
                    LogicalArtifactType typeFound = LogicalArtifactType.RESOURCE;
                    try {
                        LogicalArtifactRecognizer logicalArtifactRecognizer = StudioMetadataService.getInstance().getService().getLogicalArtifactRecognizer();
                        typeFound = logicalArtifactRecognizer.recognizeLogicalArtifactType(element);
                    }
                    catch (MetadataException e) {
                        MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_GETTING_HISTORY, (Throwable)e);
                    }
                    return ArtifactImageHelper.getInstance().resolveImage(typeFound);
                }

                public String getText(ChangedFile element) {
                    return null;
                }
            };
        }
        return this.fileLabelProvider;
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fill, gapx 5, ins 5"));
        this.historyTableModel = new HistoryTableModel(this.getHistoryOfChanges());
        HistoryTablePanel historyTablePanel = new HistoryTablePanel((UiContainer)this, this.historyTableModel);
        this.historyTable.setAutoResizeMode(AutoResizeMode.LAST_COLUMN);
        this.historyTable.getColumn(0).setLabelProvider(this.getDateLabelProvider());
        this.historyTable.getColumn(0).setWidth(100);
        this.historyTable.getColumn(1).setWidth(30);
        this.historyTable.getColumn(2).setWidth(250);
        this.historyTable.addListSelectionListener(this.getTableModelListener());
        this.add((UiComponent)historyTablePanel, "grow, width 500, height 250, wrap");
        this.add(this.buildAffectedComponentsPanel(), "grow, width 500, height 300, wrap");
    }

    private List<Change> getHistoryOfChanges() {
        Criteria criteria = new Criteria();
        criteria.setProjectId(this.mdProject.getId());
        try {
            return StudioMetadataService.getInstance().getService().listHistoryChanges(criteria, null);
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logStackTrace(e);
            MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_GETTING_HISTORY, (Throwable)e);
            return new ArrayList<Change>();
        }
    }

    private ListSelectionListener getTableModelListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int selectedRow = ChangesHistoryPanel.this.historyTable.getSelectedRow();
                    Change change = (Change)ChangesHistoryPanel.this.historyTableModel.getRow(selectedRow);
                    ChangesHistoryPanel.this.updateAffectedComponentsPanel(change);
                }
            }
        };
    }

    private void updateAffectedComponentsPanel(Change change) {
        ArrayList<ChangedItem> changedArtifacts = new ArrayList<ChangedItem>();
        ArrayList<ChangedFile> changedFiles = new ArrayList<ChangedFile>();
        if (change != null) {
            changedArtifacts.addAll(change.getChangedItems());
            changedFiles.addAll(change.getFilesChanged());
        }
        ArtifactsTableModel artifactsModel = new ArtifactsTableModel(changedArtifacts);
        this.artifactsTable.setModel((TableModel)artifactsModel);
        this.artifactsTable.getColumn(0).setLabelProvider(this.getOperationLabelProvider());
        this.artifactsTable.getColumn(1).setLabelProvider(this.getArtifactLabelProvider());
        this.configureAffectedCompTableSizes(this.artifactsTable);
        FilesTableModel filesModel = new FilesTableModel(changedFiles);
        this.filesTable.setModel((TableModel)filesModel);
        this.filesTable.getColumn(0).setLabelProvider(this.getOperationLabelProvider());
        this.filesTable.getColumn(1).setLabelProvider(this.getFileLabelProvider());
        this.configureAffectedCompTableSizes(this.filesTable);
    }

    private void configureAffectedCompTableSizes(Table table) {
        table.setRelativeSizes(new double[]{0.1, 0.1, 0.8});
        table.getColumn(0).setResizable(false);
        table.getColumn(1).setResizable(false);
    }

    private UiComponent buildAffectedComponentsPanel() {
        Panel panel = new Panel((UiContainer)this, FusionStudioMsg.AFFECTED_COMPONENTS);
        panel.setLayout((Layout)new BorderLayout());
        this.affectedComponentsTabbedPane = new TabbedPane((UiContainer)panel);
        Panel artifactsPanel = new Panel((UiContainer)this.affectedComponentsTabbedPane);
        artifactsPanel.setLayout((Layout)new BorderLayout());
        this.artifactsTableModel = new ArtifactsTableModel();
        this.artifactsTable = new Table((UiContainer)artifactsPanel, (TableModel)this.artifactsTableModel);
        this.configureAffectedCompTableSizes(this.artifactsTable);
        artifactsPanel.add((UiComponent)this.artifactsTable, (Object)"Center");
        Panel filesPanel = new Panel((UiContainer)this.affectedComponentsTabbedPane);
        filesPanel.setLayout((Layout)new BorderLayout());
        this.filesTableModel = new FilesTableModel();
        this.filesTable = new Table((UiContainer)filesPanel, (TableModel)this.filesTableModel);
        this.configureAffectedCompTableSizes(this.filesTable);
        filesPanel.add((UiComponent)this.filesTable, (Object)"Center");
        this.affectedComponentsTabbedPane.addTab(FusionStudioMsg.ARTIFACTS, (UiComponent)artifactsPanel);
        this.affectedComponentsTabbedPane.addTab(FusionStudioMsg.FILES, (UiComponent)filesPanel);
        panel.add((UiComponent)this.affectedComponentsTabbedPane, (Object)"Center");
        return panel;
    }

    private class HistoryTablePanel
    extends BaseTablePanel {
        public HistoryTablePanel(UiContainer parent, HistoryTableModel historyTableModel) {
            super(parent, null, null, (TableModel)historyTableModel, BaseTablePanel.Style.TOOLBAR_TOP, ListSelectionMode.SINGLE_SELECTION);
            ChangesHistoryPanel.this.historyTable = this.table;
        }

        protected boolean showRefreshAction() {
            return true;
        }

        protected void refreshAction() {
            IndProgressMonitorRunnableDecorator monitor = new IndProgressMonitorRunnableDecorator(this.asSwing(), FusionStudioMsg.REFRESHING_HISTORY, new Runnable(){

                @Override
                public void run() {
                    int selectedRow = ChangesHistoryPanel.this.historyTable.getSelectedRow();
                    Change selectedChange = (Change)ChangesHistoryPanel.this.historyTableModel.getRow(selectedRow);
                    ChangesHistoryPanel.this.historyTableModel.removeAllElements();
                    ChangesHistoryPanel.this.historyTableModel.addRows(ChangesHistoryPanel.this.getHistoryOfChanges());
                    int newSelectedRow = ChangesHistoryPanel.this.historyTableModel.getRowIndex(selectedChange);
                    ChangesHistoryPanel.this.historyTable.setSelectionInterval(newSelectedRow, newSelectedRow);
                }
            });
            monitor.run();
        }

        protected boolean showRemoveAction() {
            return false;
        }

        protected boolean showAddAction() {
            return false;
        }

        protected void addAction() {
        }
    }

    private class HistoryTableModel
    extends ProviderTableModel<Change> {
        private HistoryTableModel(List<Change> historyOfChanges) {
            super(HISTORY_TABLE_COLUMNS, historyOfChanges);
        }

        public Object getValueAt(int row, int column) {
            Change change = (Change)this.getData().get(row);
            switch (column) {
                case 0: {
                    return change.getChangeDate();
                }
                case 1: {
                    return change.getAuthor();
                }
                case 2: {
                    return HistoryMsgHelper.getChangeTitle((Change)change, (Locale)Locale.getDefault());
                }
            }
            return null;
        }
    }

    private class FilesTableModel
    extends ProviderTableModel<ChangedFile> {
        public FilesTableModel(List<ChangedFile> filesChanged) {
            super(MsgList.create(UIMsg.EMPTY_MSG, UIMsg.EMPTY_MSG, UIMsg.EMPTY_MSG), filesChanged);
        }

        private FilesTableModel() {
            this(new ArrayList<ChangedFile>());
        }

        public Object getValueAt(int row, int column) {
            ChangedFile changedFile = (ChangedFile)this.getData().get(row);
            switch (column) {
                case 0: {
                    return changedFile.getChangeAction();
                }
                case 1: {
                    return changedFile;
                }
                case 2: {
                    return changedFile.getCanonicalPath();
                }
            }
            return null;
        }
    }

    private class ArtifactsTableModel
    extends ProviderTableModel<ChangedItem> {
        public ArtifactsTableModel(List<ChangedItem> changedItems) {
            super(MsgList.create(UIMsg.EMPTY_MSG, UIMsg.EMPTY_MSG, UIMsg.EMPTY_MSG), changedItems);
        }

        private ArtifactsTableModel() {
            this(new ArrayList<ChangedItem>());
        }

        public Object getValueAt(int row, int column) {
            ChangedItem changedItem = (ChangedItem)this.getData().get(row);
            switch (column) {
                case 0: {
                    return changedItem.getChangeAction();
                }
                case 1: {
                    return changedItem.getType();
                }
                case 2: {
                    return changedItem.getLogicalName();
                }
            }
            return null;
        }
    }
}

