/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.ui;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.log.Log;
import oracle.bpm.metadata.history.model.LogicalArtifactType;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;

public class ArtifactImageHelper {
    private Map<LogicalArtifactType, Msg> imageMap = new HashMap<LogicalArtifactType, Msg>();
    private static ArtifactImageHelper instance;

    private ArtifactImageHelper() {
        this.imageMap.put(LogicalArtifactType.BPMN, FusionStudioMsg.BPMN_ARTIFACT);
        this.imageMap.put(LogicalArtifactType.BPEL, FusionStudioMsg.BPEL_ARTIFACT);
        this.imageMap.put(LogicalArtifactType.HUMAN_TASK, FusionStudioMsg.HUMAN_TASK_ARTIFACT);
        this.imageMap.put(LogicalArtifactType.BUSINESS_RULE, FusionStudioMsg.BUSINESS_RULE_ARTIFACT);
        this.imageMap.put(LogicalArtifactType.RESOURCE, FusionStudioMsg.RESOURCE_ARTIFACT);
        this.imageMap.put(LogicalArtifactType.ACTIVITY_GUIDE, ProjectMsg.ACTIVITY_GUIDES);
        this.imageMap.put(LogicalArtifactType.ORGANIZATION, DesignerMsg.ORGANIZATION);
        this.imageMap.put(LogicalArtifactType.MEASUREMENT, FusionStudioMsg.RESOURCE_ARTIFACT);
    }

    public static synchronized ArtifactImageHelper getInstance() {
        if (instance == null) {
            instance = new ArtifactImageHelper();
        }
        return instance;
    }

    public Image resolveImage(LogicalArtifactType artifactType) {
        Msg msg = this.imageMap.get(artifactType);
        if (msg == null) {
            Log.logWarning(FusionStudioMsg.IMAGE_NOT_FOUND((String)artifactType.toString()));
            msg = this.imageMap.get(LogicalArtifactType.RESOURCE);
        }
        return Image.create((Msg)msg);
    }
}

