/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.model;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionDescriptor;
import oracle.bpm.fusion.soa.mds.model.BpmConnectionException;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.mds.resourcepalette.BPMConnectionProvider;
import oracle.jdeveloper.rescat2.RescatContextRegistry;
import oracle.jdeveloper.rescat2.nodes.RescatContext;
import oracle.rc.asadapter.connection.AppServerConnection;
import oracle.rc.asadapter.connection.AppServerConnectionFactory;
import oracle.tip.tools.ide.common.resourcepalette.adapter.ConnectionsHelper;
import oracle.tip.tools.ide.fabric.asbrowser.ASBrowserHelper;
import oracle.tip.tools.ide.fabric.asbrowser.ListSOAServersCallback;

public class BPMConnectionsManager {
    RescatContextRegistry registry = RescatContextRegistry.getInstance();
    RescatContext resCatContext = this.registry.getResourcePaletteContext();
    AdfJndiContext connectionContext = this.resCatContext.getConnectionContext();
    private BPMConnectionDescriptor defaultBPMConnectionDescriptor;
    private Map<String, Collection<PropertyChangeListener>> propertyListeners = new HashMap<String, Collection<PropertyChangeListener>>();
    private static BPMConnectionsManager instance;
    public static final String BPM_CONNECTIONS_KEY = "BpmConnections";

    private BPMConnectionsManager() {
        this.propertyListeners.put(BPM_CONNECTIONS_KEY, new ArrayList());
    }

    public static synchronized BPMConnectionsManager getInstance() {
        if (instance == null) {
            instance = new BPMConnectionsManager();
        }
        return instance;
    }

    public static String nextNameForRepositoryConnection() throws Exception {
        String baseName;
        String validName = baseName = "BPMConnection0";
        List connectionsName = ConnectionsHelper.getResourcePaletteConnections(BPMConnectionProvider.class);
        int i = 1;
        while (connectionsName.contains(validName)) {
            validName = baseName + i;
            ++i;
        }
        return validName;
    }

    public void getSoaServers(String connectionId, Component parent, ListSOAServersCallback callback) {
        ASBrowserHelper.listSOAServersAsync((AppServerConnection)AppServerConnectionFactory.getInstance((AdfJndiContext)this.connectionContext).create(connectionId), (Component)parent, (ListSOAServersCallback)callback);
    }

    public void addBpmConnection(BPMConnectionDescriptor bpmConnectionDescriptor) throws BpmConnectionException {
        try {
            this.connectionContext.bind(bpmConnectionDescriptor.getName(), (Object)new BPMConnectionProvider(bpmConnectionDescriptor));
            this.connectionContext.save();
        }
        catch (NamingException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
        this.resCatContext.flushChanges();
        this.firePropertyChanged(BPM_CONNECTIONS_KEY, null, bpmConnectionDescriptor);
    }

    public void updateConnection(BPMConnectionDescriptor bpmConnectionDescriptor) throws BpmConnectionException {
        BPMConnectionDescriptor oldConnection = this.findConnectionByName(bpmConnectionDescriptor.getName());
        try {
            this.connectionContext.rebind(bpmConnectionDescriptor.getName(), (Object)new BPMConnectionProvider(bpmConnectionDescriptor));
        }
        catch (NamingException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
        this.resCatContext.flushChanges();
        this.firePropertyChanged(BPM_CONNECTIONS_KEY, oldConnection, bpmConnectionDescriptor);
    }

    public void removeBpmConnection(BPMConnectionDescriptor bpmConnectionDescriptor) throws BpmConnectionException {
        try {
            this.connectionContext.unbind(bpmConnectionDescriptor.getName());
            this.connectionContext.save();
        }
        catch (NamingException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
        this.resCatContext.flushChanges();
        this.firePropertyChanged(BPM_CONNECTIONS_KEY, bpmConnectionDescriptor, null);
    }

    public List<BPMConnectionDescriptor> getBpmConnections() throws BpmConnectionException {
        ArrayList<BPMConnectionDescriptor> connections = new ArrayList<BPMConnectionDescriptor>();
        try {
            List connectionsNameList = ConnectionsHelper.getResourcePaletteConnections(BPMConnectionProvider.class);
            for (String connectionName : connectionsNameList) {
                BPMConnectionProvider provider = (BPMConnectionProvider)ConnectionsHelper.getResourcePaletteProvider((String)connectionName);
                BPMConnectionDescriptor connectionDesc = provider.getBpmConnectionDescriptor();
                connections.add(connectionDesc);
            }
        }
        catch (Exception e) {
            throw new BpmConnectionException(e);
        }
        return connections;
    }

    public BPMConnectionDescriptor findConnectionByName(String bpmConnectionName) throws BpmConnectionException {
        try {
            List connectionsNameList = ConnectionsHelper.getResourcePaletteConnections(BPMConnectionProvider.class);
            for (String connectionName : connectionsNameList) {
                if (!connectionName.equals(bpmConnectionName)) continue;
                BPMConnectionProvider provider = (BPMConnectionProvider)ConnectionsHelper.getResourcePaletteProvider((String)connectionName);
                return provider.getBpmConnectionDescriptor();
            }
        }
        catch (Exception e) {
            throw new BpmConnectionException(e);
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners.get(BPM_CONNECTIONS_KEY).add(propertyChangeListener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        this.propertyListeners.get(propertyName).add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners.get(BPM_CONNECTIONS_KEY).remove(propertyChangeListener);
    }

    public BPMConnectionDescriptor getDefaultConnection() {
        return this.defaultBPMConnectionDescriptor;
    }

    public void setDefaultConnection(BPMConnectionDescriptor defaultBPMConnectionDescriptor) {
        this.defaultBPMConnectionDescriptor = defaultBPMConnectionDescriptor;
    }

    private void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent changeEvent = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.propertyListeners.get(propertyName)) {
            listener.propertyChange(changeEvent);
        }
    }
}

