/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.command;

import oracle.bpm.command.Command;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.SnapshotProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.ProjectNotFoundException;

public class DeleteSnapshotCommand
implements Command {
    private LocalRef<SnapshotProject> projectLocalRef;

    public DeleteSnapshotCommand(LocalRef<SnapshotProject> projectLocalRef) {
        this.projectLocalRef = projectLocalRef;
    }

    @Override
    public String getName() {
        return "Delete Snapshot Project: " + this.projectLocalRef.getName();
    }

    @Override
    public Object getAffectedObject() {
        return this.projectLocalRef;
    }

    @Override
    public void undo() {
    }

    @Override
    public Object execute() throws ExecutionException {
        try {
            StudioMetadataService.getInstance().getService().deleteSnapshot(((SnapshotProject)this.projectLocalRef.get()).getId());
        }
        catch (ProjectNotFoundException e) {
            MdsLogger.getInstance().logMessage(e.getStackTraceString());
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logMessage(e.getStackTraceString());
            throw new ExecutionException(e);
        }
        return null;
    }
}

