/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.command;

import oracle.bpm.command.Command;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.exception.MetadataException;

public class CreateSnapshotCommand
implements Command {
    private String comment;
    private PublicShareProject mdProject;
    private String name;

    public CreateSnapshotCommand(PublicShareProject mdProject, String name, String comment) {
        this.mdProject = mdProject;
        this.name = name;
        this.comment = comment;
    }

    @Override
    public String getName() {
        return "Create Snashot of :\u00a0" + this.mdProject.getName();
    }

    @Override
    public Object getAffectedObject() {
        return this.mdProject;
    }

    @Override
    public void undo() {
    }

    @Override
    public Object execute() throws ExecutionException {
        try {
            StudioMetadataService.getInstance().getService().createSnapshot(this.mdProject, this.name, this.comment);
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logMessage(e.getStackTraceString());
            throw new ExecutionException(e);
        }
        return null;
    }
}

