/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.command;

import oracle.bpm.command.Command;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionDescriptor;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionsManager;
import oracle.bpm.fusion.soa.mds.model.BpmConnectionException;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import org.jetbrains.annotations.NotNull;

public class AddBpmRepositoryConnectionCommand
implements Command {
    private BPMConnectionDescriptor bpmConnectionDescriptor;

    public AddBpmRepositoryConnectionCommand(@NotNull BPMConnectionDescriptor bpmConnectionDescriptor) {
        if (bpmConnectionDescriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/command/AddBpmRepositoryConnectionCommand.<init> must not be null");
        }
        this.bpmConnectionDescriptor = bpmConnectionDescriptor;
    }

    @Override
    public String getName() {
        return "Adding BPM Repository Connection: " + this.bpmConnectionDescriptor.getName();
    }

    @Override
    public Object getAffectedObject() {
        return this.bpmConnectionDescriptor;
    }

    @Override
    public void undo() {
    }

    @Override
    public Object execute() throws ExecutionException {
        try {
            BPMConnectionsManager.getInstance().addBpmConnection(this.bpmConnectionDescriptor);
        }
        catch (BpmConnectionException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new ExecutionException(e);
        }
        return null;
    }
}

