/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import java.awt.Component;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.action.AbstractMdsAction;
import oracle.bpm.fusion.soa.mds.command.LockMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.command.RefreshMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.msg.UIMsg;
import oracle.ide.Ide;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class LockMdsProjectAction
extends AbstractMdsAction {
    private PublicShareProject publicShareProject;

    public LockMdsProjectAction(PublicShareProject publicShareProject) {
        super(FusionStudioMsg.LOCK_PROJECT);
        this.requires(MdProject.class);
        this.publicShareProject = publicShareProject;
    }

    @Override
    public void actionPerformed() {
        this.lockMdsProject();
    }

    private void lockMdsProject() {
        if (!StudioMetadataService.getInstance().isStatusConnected()) {
            MessageDialog.showWarning((Msg)FusionStudioMsg.CONNECTION_COULD_NOT_BE_STABLISHED);
        } else {
            FuegoWorker.post((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), FusionStudioMsg.LOCKING_BPM_MDS_PROJECT.toString());
                    progressMonitor.setCancellable(false);
                    progressMonitor.start();
                    try {
                        new LockMdsProjectCommand(LockMdsProjectAction.this.publicShareProject).execute();
                        new RefreshMdsProjectCommand().execute();
                    }
                    catch (ExecutionException e) {
                        MdsLogger.getInstance().logStackTrace(e);
                        MessageDialog.showError((Msg)UIMsg.TO_MSG((String)e.getMessage()));
                    }
                    finally {
                        progressMonitor.finish();
                    }
                }
            });
        }
    }
}

