/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import oracle.bpm.fusion.soa.mds.action.AbstractMdsAction;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.SnapshotProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.ui.wizards.ExportFuegoProjectWizard;

public class ExportProjectSnapshotAction
extends AbstractMdsAction {
    private LocalRef<SnapshotProject> snapshotProject;

    public ExportProjectSnapshotAction() {
        super(FusionStudioMsg.EXPORT_PROJECT_SNAPSHOT);
        this.requires(MdProject.class);
    }

    @Override
    public void actionPerformed() {
        this.exportSnapshot();
    }

    public void setSnapshotProject(LocalRef<SnapshotProject> snapshotProject) {
        this.snapshotProject = snapshotProject;
    }

    private void exportSnapshot() {
        ExportFuegoProjectWizard exportWizard = new ExportFuegoProjectWizard(this.getProject(), true, FusionStudioMsg.EXPORT_MDS_PROJECT);
        exportWizard.run();
    }

    private Project getProject() {
        try {
            return (Project)((SnapshotProject)this.snapshotProject.get()).getProject().get();
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw ProgramException.wrap("Problems while getting the project from MDS.", e);
        }
    }
}

