/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import java.awt.Component;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.soa.mds.MdsProjectNode;
import oracle.bpm.fusion.soa.mds.action.AbstractMdsAction;
import oracle.bpm.fusion.soa.mds.command.DeleteMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.ide.Ide;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class DeletePublicShareAction
extends AbstractMdsAction {
    private MdsProjectNode mdsProjectNode;

    public DeletePublicShareAction() {
        super(FusionStudioMsg.DELETE_MDS_PROJECT);
        this.requires(MdsProjectNode.class);
    }

    public DeletePublicShareAction(MdsProjectNode mdsProjectNode) {
        this();
        this.mdsProjectNode = mdsProjectNode;
    }

    @Override
    public void actionPerformed() {
        if (!this.mdsProjectNode.getObject().isPublicShare()) {
            throw new IllegalArgumentException("Project to be deleted should be a " + PublicShareProject.class);
        }
        this.deleteMdsProject((PublicShareProject)this.mdsProjectNode.getObject());
    }

    private void deleteMdsProject(PublicShareProject publicShareProject) {
        boolean deleteAnyway;
        Msg msg = publicShareProject.isLocked() ? DesignerMsg.CONFIRM_DELETION_LOCKED((String)this.mdsProjectNode.getShortLabel()) : DesignerMsg.CONFIRM_DELETION((String)this.mdsProjectNode.getShortLabel());
        boolean bl = deleteAnyway = MessageDialog.showQuestion((Msg)FusionStudioMsg.DELETE_MDS_PROJECT_TITLE, (Msg)msg, (int)6) == 2;
        if (deleteAnyway) {
            FuegoWorker.post((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), FusionStudioMsg.DELETING_PROJECT.toString());
                    progressMonitor.setCancellable(false);
                    progressMonitor.start();
                    try {
                        new DeleteMdsProjectCommand(DeletePublicShareAction.this.mdsProjectNode.getObject()).execute();
                        MdsProjectNavigatorManager.getInstance().removeProjectArtifact(DeletePublicShareAction.this.mdsProjectNode);
                    }
                    catch (ExecutionException e) {
                        MdsLogger.getInstance().logStackTrace(e);
                        MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_DELETING_MDS_PROJECT((String)e.getMessage()));
                    }
                    finally {
                        progressMonitor.finish();
                    }
                }
            });
        }
    }
}

