/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.action.EditBpmRepositoryConnectionAction;
import oracle.bpm.fusion.soa.mds.action.NewBpmRepositoryConnectionAction;
import oracle.bpm.fusion.soa.mds.command.ConnectToBpmRepositoryCommand;
import oracle.bpm.fusion.soa.mds.command.RemoveBpmRepositoryConnectionCommand;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionDescriptor;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionsManager;
import oracle.bpm.fusion.soa.mds.model.BpmConnectionException;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;

public class ConfigureMdsConnectionAction
extends BaseAction {
    private boolean actionCancelled = false;
    private final BPMConnectionsManager connectionsManager = BPMConnectionsManager.getInstance();

    public ConfigureMdsConnectionAction() {
        super(FusionStudioMsg.CONFIGURE_MDS_CONNECTION_FAIL);
        this.requires(Void.class);
    }

    public void run() {
        this.configureMdsConnection();
    }

    public boolean isActionCancelled() {
        return this.actionCancelled;
    }

    protected void updateEnableStatus(Selection s) {
        if (StudioMetadataService.getInstance().isStatusConnected()) {
            this.setMsg(FusionStudioMsg.CONFIGURE_MDS_CONNECTION_SUCCESS);
        } else {
            this.setMsg(FusionStudioMsg.CONFIGURE_MDS_CONNECTION_FAIL);
        }
    }

    private void configureMdsConnection() {
        ConfigureMdsConnectionDialog dialog = new ConfigureMdsConnectionDialog(Ui.getRoot(), FusionStudioMsg.CONFIGURE_MDS_CONNECTION, true);
        dialog.setVisible(true);
        if (!dialog.userAccepted()) {
            this.actionCancelled = true;
        }
    }

    private class ConfigureMdsConnectionDialog
    extends OkCancelDialog {
        private PropertyChangeListener bpmConnectionsListener;
        private ComboBox<BPMConnectionDescriptor> connectionsCombo;
        private Button deleteConnectionButton;
        private Button editConnectionButton;

        public ConfigureMdsConnectionDialog(UiWindow owner, Msg msg, boolean modal) {
            super(owner, msg, modal);
            this.buildUi();
            this.startListeningBpmConnections();
            this.addVisibilityListener(new VisibilityListener(){

                public void onDispose() {
                    ConfigureMdsConnectionDialog.this.stopListeningBpmConnections();
                }
            });
        }

        public void ok() {
            this.setCursor(Cursor.get((Cursor.CursorType)Cursor.CursorType.WAIT_CURSOR));
            StudioMetadataService.getInstance().startStatusConnecting();
            BPMConnectionDescriptor selectedBPMConnectionDescriptor = (BPMConnectionDescriptor)this.connectionsCombo.getSelectedItem();
            try {
                new ConnectToBpmRepositoryCommand(selectedBPMConnectionDescriptor).execute();
                this.setVisible(false);
            }
            catch (ExecutionException e) {
                MdsLogger.getInstance().logStackTrace(e);
                MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_ESTABLISHING_MDS_CONNECTION((String)e.getMessage()));
                this.setCursor(Cursor.get((Cursor.CursorType)Cursor.CursorType.DEFAULT_CURSOR));
                try {
                    StudioMetadataService.getInstance().disconnect();
                }
                catch (BpmConnectionException e1) {
                    MdsLogger.getInstance().logStackTrace(e);
                    MessageDialog.showError((Throwable)e1);
                }
            }
            catch (RuntimeException e) {
                MdsLogger.getInstance().logStackTrace(e);
                MessageDialog.showError((Msg)UIMsg.TO_MSG((String)e.getMessage()));
                this.setCursor(Cursor.get((Cursor.CursorType)Cursor.CursorType.DEFAULT_CURSOR));
                try {
                    StudioMetadataService.getInstance().disconnect();
                }
                catch (BpmConnectionException e1) {
                    MdsLogger.getInstance().logStackTrace(e);
                    MessageDialog.showError((Throwable)e1);
                }
                throw e;
            }
        }

        private void startListeningBpmConnections() {
            this.bpmConnectionsListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BPMConnectionDescriptor oldValue = (BPMConnectionDescriptor)evt.getOldValue();
                    BPMConnectionDescriptor newValue = (BPMConnectionDescriptor)evt.getNewValue();
                    if (oldValue == null && newValue != null) {
                        ConfigureMdsConnectionDialog.this.connectionsCombo.addItem((Object)newValue);
                        ConfigureMdsConnectionDialog.this.connectionsCombo.setSelectedItem((Object)newValue);
                    }
                    if (oldValue != null && newValue == null) {
                        ConfigureMdsConnectionDialog.this.connectionsCombo.setSelectedItem(null);
                        ConfigureMdsConnectionDialog.this.connectionsCombo.removeItem((Object)oldValue);
                        if (ConfigureMdsConnectionDialog.this.connectionsCombo.getItemCount() > 0) {
                            ConfigureMdsConnectionDialog.this.connectionsCombo.setSelectedIndex(0);
                        }
                    }
                }
            };
            ConfigureMdsConnectionAction.this.connectionsManager.addPropertyChangeListener("BpmConnections", this.bpmConnectionsListener);
        }

        private void stopListeningBpmConnections() {
            ConfigureMdsConnectionAction.this.connectionsManager.removePropertyChangeListener(this.bpmConnectionsListener);
        }

        private void buildUi() {
            Panel mainPanel = Panel.createPanelWithBorder((UiContainer)this.getContentPane());
            mainPanel.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
            this.connectionsCombo = UiFactory.createComboBox((UiContainer)mainPanel);
            try {
                this.connectionsCombo.addItems(this.getBpmConnections());
            }
            catch (BpmConnectionException e) {
                MdsLogger.getInstance().logStackTrace(e);
                MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_LOADING_BPM_CONNECTIONS, (Throwable)e);
            }
            Label comboLabel = Label.create((UiContainer)mainPanel, (Msg)FusionStudioMsg.MDS_CONNECTIONS);
            this.connectionsCombo.setLabelProvider(this.getConnectionsLabelProvider());
            if (this.connectionsCombo.getItemCount() > 0) {
                if (StudioMetadataService.getInstance().isStatusConnected()) {
                    this.connectionsCombo.setSelectedItem((Object)StudioMetadataService.getInstance().getCurrentConnection());
                } else {
                    this.connectionsCombo.setSelectedIndex(0);
                }
            }
            Button newConnectionButton = Button.createIconic((UiContainer)mainPanel, (Msg)UIMsg.ADD);
            newConnectionButton.addActionListener(this.getNewConnectionActionListener());
            this.editConnectionButton = Button.createIconic((UiContainer)mainPanel, (Msg)UIMsg.EDIT);
            this.editConnectionButton.addActionListener(this.getEditConnectionActionListener());
            this.editConnectionButton.setEnabled(this.connectionsCombo.getSelectedItem() != null);
            this.deleteConnectionButton = Button.createIconic((UiContainer)mainPanel, (Msg)UIMsg.DELETE);
            this.deleteConnectionButton.addActionListener(this.getDeleteConnectionActionListener());
            this.deleteConnectionButton.setEnabled(this.connectionsCombo.getItemCount() > 0 && this.connectionsCombo.getSelectedItem() != null);
            this.connectionsCombo.addItemListener(this.getConnectionsComboItemListener());
            mainPanel.add((UiComponent)comboLabel);
            mainPanel.add(this.connectionsCombo, (Object)"growx, wmin 200");
            mainPanel.add((UiComponent)newConnectionButton);
            mainPanel.add((UiComponent)this.editConnectionButton);
            mainPanel.add((UiComponent)this.deleteConnectionButton);
            this.setIconImage(Image.create((Msg)this.getMsg()));
            this.getContentPane().add((UiComponent)mainPanel, (Object)"Center");
            this.pack();
            this.setLocationRelativeTo((UiComponent)this.getParent());
        }

        private ItemListener getConnectionsComboItemListener() {
            return new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ConfigureMdsConnectionDialog.this.editConnectionButton.setEnabled(ConfigureMdsConnectionDialog.this.connectionsCombo.getSelectedItem() != null);
                    ConfigureMdsConnectionDialog.this.deleteConnectionButton.setEnabled(ConfigureMdsConnectionDialog.this.connectionsCombo.getItemCount() > 0 && ConfigureMdsConnectionDialog.this.connectionsCombo.getSelectedItem() != null);
                }
            };
        }

        private List<BPMConnectionDescriptor> getBpmConnections() throws BpmConnectionException {
            return ConfigureMdsConnectionAction.this.connectionsManager.getBpmConnections();
        }

        private LabelProvider<BPMConnectionDescriptor> getConnectionsLabelProvider() {
            return new LabelProvider<BPMConnectionDescriptor>(){

                public Image getIcon(BPMConnectionDescriptor element) {
                    return null;
                }

                public String getText(BPMConnectionDescriptor element) {
                    return element.getName();
                }
            };
        }

        private ActionListener getNewConnectionActionListener() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    new NewBpmRepositoryConnectionAction().run();
                }
            };
        }

        private ActionListener getEditConnectionActionListener() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    new EditBpmRepositoryConnectionAction((BPMConnectionDescriptor)ConfigureMdsConnectionDialog.this.connectionsCombo.getSelectedItem()).run();
                }
            };
        }

        private ActionListener getDeleteConnectionActionListener() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    try {
                        new RemoveBpmRepositoryConnectionCommand((BPMConnectionDescriptor)ConfigureMdsConnectionDialog.this.connectionsCombo.getSelectedItem()).execute();
                    }
                    catch (ExecutionException e) {
                        MdsLogger.getInstance().logStackTrace(e);
                        MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_REMOVING_BPM_CONNECTION, (Throwable)e);
                    }
                }
            };
        }
    }
}

