/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.fusion.soa.mds.action.AbstractMdsAction;
import oracle.bpm.fusion.soa.mds.command.CheckoutMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.command.LockMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.command.RefreshMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.model.MDSSecurityUtils;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiRunnableDecorator;
import oracle.bpm.ui.msg.UIMsg;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.cmd.SaveCommand;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class CheckoutMdsProjectAction
extends AbstractMdsAction {
    private MdProject<? extends ProjectArtifact> mdsProject;

    public CheckoutMdsProjectAction() {
        super(FusionStudioMsg.CHECKOUT_MDS_PROJECT);
        this.requires(MdProject.class);
    }

    public CheckoutMdsProjectAction(MdProject<? extends ProjectArtifact> mdsProject) {
        this();
        this.mdsProject = mdsProject;
    }

    @Override
    public void actionPerformed() {
        this.checkoutProject();
    }

    private void checkoutProject() {
        if (Ide.getActiveWorkspace() == null) {
            MessageDialog.showError((Msg)FusionStudioMsg.NO_APPLICATION_OPENED);
            return;
        }
        FuegoWorker.post((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), FusionStudioMsg.CHECKING_OUT_PROJECT.toString());
                progressMonitor.setCancellable(false);
                progressMonitor.start();
                try {
                    if (CheckoutMdsProjectAction.this.mdsProject.isPublicShare()) {
                        boolean showWarning = false;
                        PublicShareProject publicShareProject = (PublicShareProject)CheckoutMdsProjectAction.this.mdsProject;
                        if (publicShareProject.isLocked()) {
                            if (!MDSSecurityUtils.hasUserLoggedLock(publicShareProject)) {
                                showWarning = true;
                            }
                        } else if (publicShareProject.isEditable()) {
                            try {
                                new LockMdsProjectCommand(publicShareProject).execute();
                                new RefreshMdsProjectCommand().execute();
                            }
                            catch (ExecutionException e) {
                                MdsLogger.getInstance().logStackTrace(e);
                                showWarning = true;
                            }
                        }
                        if (showWarning) {
                            MessageDialog.showWarning((Msg)FusionStudioMsg.ANOTHER_USER_HAVE_THE_LOCK);
                        }
                    }
                    boolean checkOut = true;
                    Project jdevProject = CheckoutMdsProjectAction.this.findJdevProject((MdProject<? extends ProjectArtifact>)CheckoutMdsProjectAction.this.mdsProject);
                    if (jdevProject != null) {
                        boolean replace;
                        boolean bl = replace = MessageDialog.showQuestion((Msg)FusionStudioMsg.CHECKOUT_MDS_PROJECT, (Msg)FusionStudioMsg.PROJECT_ALREADY_EXISTS_REPLACE_IT, (int)6) == 2;
                        if (replace) {
                            CheckoutMdsProjectAction.this.removeExistingProject(jdevProject);
                        } else {
                            checkOut = false;
                        }
                    }
                    if (checkOut) {
                        new CheckoutMdsProjectCommand((MdProject<? extends ProjectArtifact>)CheckoutMdsProjectAction.this.mdsProject).execute();
                    }
                }
                catch (ExecutionException e) {
                    MdsLogger.getInstance().logStackTrace(e);
                    MessageDialog.showError((Msg)UIMsg.TO_MSG((String)e.getMessage()));
                }
                finally {
                    progressMonitor.finish();
                }
            }
        });
    }

    private void removeExistingProject(final Project jdevProject) {
        UiRunnableDecorator runnableDecorator = new UiRunnableDecorator(1, new Runnable(){

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                List editors = editorManager.getAllEditors();
                ArrayList<Editor> editorsToClose = new ArrayList<Editor>();
                for (Editor editor : editors) {
                    if (editor.getContext().getProject() == null || !editor.getContext().getProject().equals((Object)jdevProject)) continue;
                    Node node = editor.getContext().getNode();
                    SaveCommand saveCmd = new SaveCommand();
                    saveCmd.setContext(Context.newIdeContext((Node)node));
                    saveCmd.doit();
                    CloseNodeCommand clsCmd = new CloseNodeCommand();
                    clsCmd.setContext(Context.newIdeContext((Node)node));
                    clsCmd.close(node);
                    editorsToClose.add(editor);
                }
                editorManager.closeEditors(editorsToClose);
                try {
                    Context context = Context.newIdeContext((Node)jdevProject);
                    SaveCommand saveCmd = new SaveCommand();
                    saveCmd.setContext(context);
                    saveCmd.doit();
                    Ide.getActiveWorkspace().remove((Element)jdevProject, true);
                    File projectDir = new File(jdevProject.getURL().getFile()).getParentFile();
                    File applicationDir = projectDir.getParentFile();
                    JavaFileSystem applicationFileSystem = new JavaFileSystem(applicationDir);
                    VFile projectVFile = applicationFileSystem.createFile(projectDir.getName());
                    VFileUtils.deleteDirectory((VFile)projectVFile);
                }
                catch (Exception e) {
                    MdsLogger.getInstance().logStackTrace(e);
                    MessageDialog.showError((Throwable)e);
                }
            }
        });
        runnableDecorator.run();
    }

    private Project findJdevProject(MdProject<? extends ProjectArtifact> mdsProject) {
        return FusionProjectRepository.findExistentJdevProject((String)(mdsProject.getName() + ".jpr"));
    }
}

