/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.fusion.soa.mds.action.AbstractMdsAction;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.soa.mds.ui.NewProjectSnapshotDialog;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.SnapshotProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.Nullable;

public class AddSnapshotAction
extends AbstractMdsAction {
    private List<LocalRef<SnapshotProject>> currentSnapshots;
    private PublicShareProject publicShareProject;
    private LocalRef<SnapshotProject> snapshot;

    public AddSnapshotAction(PublicShareProject publicShareProject, List<LocalRef<SnapshotProject>> currentSnapshots) {
        super(UIMsg.ADD);
        this.requires(PublicShareProject.class);
        this.publicShareProject = publicShareProject;
        this.currentSnapshots = currentSnapshots;
    }

    public LocalRef<SnapshotProject> getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void actionPerformed() {
        try {
            String nextName = this.getSuggestedName();
            NewProjectSnapshotDialog snapshotDialog = new NewProjectSnapshotDialog(Ui.getRoot(), this.publicShareProject, nextName, this.currentSnapshots);
            snapshotDialog.setVisible(true);
            this.snapshot = snapshotDialog.getSnapshot();
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logMessage(e.getStackTraceString());
            MessageDialog.showError((Throwable)e);
        }
    }

    private String getSuggestedName() throws MetadataException {
        String prefixId = this.publicShareProject.getName();
        int i = 0;
        String suggestedId = prefixId + i;
        while (this.nameAlreadyExists(suggestedId)) {
            suggestedId = prefixId + i++;
        }
        return suggestedId;
    }

    private boolean nameAlreadyExists(final String suggestedId) throws MetadataException {
        return CollectionUtils.exists(this.currentSnapshots, new Predicate<LocalRef<SnapshotProject>>(){

            @Override
            public boolean check(@Nullable LocalRef<SnapshotProject> value) {
                return value.getName().equals(suggestedId);
            }
        });
    }
}

