/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.MalformedObjectNameException;
import oracle.bpm.fusion.soa.mds.ApplicationServerConnectionFactory;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionDescriptor;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionsManager;
import oracle.bpm.fusion.soa.mds.model.BpmConnectionException;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.mds.MdsInstanceInitializer;
import oracle.bpm.metadata.mds.Namespace;
import oracle.bpm.pml.service.impl.StudioMetadataServiceImpl;
import oracle.bpm.pml.service.security.ApplicationServerConnection;
import oracle.bpm.pml.service.util.MdProjectUtil;
import oracle.bpm.pml.service.util.lookup.WasHelper;
import oracle.bpm.resources.Msg;
import oracle.jdeveloper.rcasadapter.AppServerProvider;
import oracle.jdeveloper.server.connection.AppServer;
import oracle.jdeveloper.server.connection.AppServerManager;
import oracle.mds.core.MDSInstance;
import oracle.mds.exception.MDSException;
import oracle.mds.exception.MDSRuntimeException;
import oracle.mds.persistence.MetadataStore;
import oracle.mds.persistence.stores.db.DBMetadataStore;
import oracle.tip.tools.ide.common.resourcepalette.adapter.ConnectionsHelper;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.MDSConnectionDescriptor;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.MDSProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioMetadataService {
    private BPMConnectionDescriptor bpmConnectionDescriptor;
    private Collection<ConfigurationListener> configurationListeners = new ArrayList<ConfigurationListener>();
    private MDSInstance mdsInstance;
    private ApplicationServerConnection securityConnection;
    private oracle.bpm.pml.service.StudioMetadataService service;
    private Status status = Status.DISCONNECTED;
    private Collection<StatusListener> statusListeners = new ArrayList<StatusListener>();
    public static final String MDS_BPM_PARTITION_NAME = "obpm";
    private static StudioMetadataService instance;
    private static final String MDS_HOME;

    private StudioMetadataService() {
        BPMConnectionsManager.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BPMConnectionDescriptor oldValue = (BPMConnectionDescriptor)evt.getOldValue();
                BPMConnectionDescriptor newValue = (BPMConnectionDescriptor)evt.getNewValue();
                if (oldValue != null && oldValue.equals(StudioMetadataService.this.bpmConnectionDescriptor)) {
                    try {
                        StudioMetadataService.this.changeConnection(newValue);
                    }
                    catch (BpmConnectionException e) {
                        try {
                            StudioMetadataService.this.changeConnection(null);
                        }
                        catch (BpmConnectionException e1) {
                            MdsLogger.getInstance().logStackTrace(e1);
                        }
                    }
                }
            }
        });
    }

    public static synchronized StudioMetadataService getInstance() {
        if (instance == null) {
            instance = new StudioMetadataService();
        }
        return instance;
    }

    public static ApplicationServerConnection createApplicationServerConnection(BPMConnectionDescriptor connectionDescriptor) throws BpmConnectionException, MalformedObjectNameException, IOException {
        String password;
        String userName;
        AppServer appServer = AppServerManager.getInstance().getAppServer(connectionDescriptor.getSoaInfraServer());
        oracle.rc.asadapter.connection.AppServerProvider appServerProvider = appServer.getAppServerProvider();
        if (connectionDescriptor.isUseAppServerUsrPass()) {
            userName = appServerProvider.getProperty("user");
            password = appServerProvider.getProperty("password");
        } else {
            userName = connectionDescriptor.getUser();
            password = connectionDescriptor.getPassword();
        }
        ApplicationServerConnection securityConnection = ApplicationServerConnectionFactory.getInstance().create(appServer, userName, password);
        if (appServerProvider.getProperty("ConnectionType").equals("WebSphere_7.x")) {
            try {
                securityConnection.setWebsphere7Descriptor(WasHelper.buildWebsphere7Descriptor((AppServerProvider)appServerProvider));
            }
            catch (MetadataException e) {
                throw new BpmConnectionException(e);
            }
        }
        return securityConnection;
    }

    public oracle.bpm.pml.service.StudioMetadataService getService() throws MetadataException {
        if (this.service == null) {
            throw new MetadataException(FusionStudioMsg.CONNECTION_COULD_NOT_BE_STABLISHED);
        }
        return this.service;
    }

    public MdTree getAllTemplates() throws MetadataException {
        return this.getService().getTemplates(null, null);
    }

    public MdTree getAllPublicShares() throws MetadataException {
        return this.getService().getPublicShares(MdProjectUtil.getAllProjectsFilter(), null);
    }

    public void changeConnection(@Nullable BPMConnectionDescriptor bpmConnectionDescriptor) throws BpmConnectionException {
        MDSInstance mdsInstance = null;
        this.securityConnection = null;
        try {
            if (bpmConnectionDescriptor != null) {
                mdsInstance = this.getMdsInstance(bpmConnectionDescriptor.getBPMRepositoryServer());
                this.securityConnection = StudioMetadataService.createApplicationServerConnection(bpmConnectionDescriptor);
            }
            this.setMdsInstance(bpmConnectionDescriptor, mdsInstance, this.securityConnection);
            this.status = null;
            this.updateConnectionStatus();
            this.fireConfigurationChanged();
        }
        catch (UnknownHostException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
        catch (MDSException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
        catch (MalformedObjectNameException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
        catch (IOException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
    }

    public boolean isActiveCurrentConnection() {
        if (this.isStatusConnected()) {
            try {
                ConnectionsHelper.getResourcePaletteProvider((String)this.getCurrentConnection().getBPMRepositoryServer());
            }
            catch (Exception e) {
                MdsLogger.getInstance().logStackTrace(e);
                try {
                    this.changeConnection(null);
                }
                catch (BpmConnectionException e1) {
                    MdsLogger.getInstance().logStackTrace(e);
                    this.mdsInstance = null;
                    this.securityConnection = null;
                    this.bpmConnectionDescriptor = null;
                    this.service = null;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void addStatusListener(StatusListener statusListener) {
        this.statusListeners.add(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.statusListeners.remove(statusListener);
    }

    @Nullable
    public BPMConnectionDescriptor getCurrentConnection() {
        return this.bpmConnectionDescriptor;
    }

    public boolean isStatusDisconnected() {
        this.updateConnectionStatus();
        return this.status == Status.DISCONNECTED;
    }

    public boolean isStatusConnecting() {
        this.updateConnectionStatus();
        return this.status == Status.CONNECTING;
    }

    public boolean isStatusConnected() {
        this.updateConnectionStatus();
        return this.status == Status.CONNECTED;
    }

    public void startStatusConnecting() {
        this.changeStatus(Status.CONNECTING);
    }

    public Status getStatus() {
        return this.status;
    }

    public void disconnect() throws BpmConnectionException {
        this.changeConnection(null);
    }

    public void addConfigurationListener(ConfigurationListener configurationListener) {
        this.configurationListeners.add(configurationListener);
    }

    public void removeConfigurationListener(ConfigurationListener configurationListener) {
        this.configurationListeners.remove(configurationListener);
    }

    public String getUserLogged() {
        return this.securityConnection.getUserName();
    }

    public void testConnection(BPMConnectionDescriptor connectionDescriptor) throws BpmConnectionException {
        try {
            MDSInstance mdsInstance = this.getMdsInstance(connectionDescriptor.getBPMRepositoryServer());
            ApplicationServerConnection securityConnection = StudioMetadataService.createApplicationServerConnection(connectionDescriptor);
            new StudioMetadataServiceImpl(mdsInstance, securityConnection);
        }
        catch (MDSException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
        catch (MalformedObjectNameException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
        catch (IOException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
        catch (MDSRuntimeException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(e);
        }
    }

    private MDSInstance getMdsInstance(@NotNull String selectedMdsConnection) throws MDSException, BpmConnectionException {
        MDSInstance result;
        if (selectedMdsConnection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/StudioMetadataService.getMdsInstance must not be null");
        }
        MDSProvider resourcePaletteProvider = null;
        try {
            resourcePaletteProvider = (MDSProvider)ConnectionsHelper.getResourcePaletteProvider((String)selectedMdsConnection);
        }
        catch (Exception e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmConnectionException(FusionStudioMsg.CANNOT_OBTAIN_CONNECTION_FROM_RESOURCE_PALETTE((String)selectedMdsConnection), e);
        }
        MDSConnectionDescriptor connectionDesc = resourcePaletteProvider.getConnectionDescriptor();
        if (MDS_BPM_PARTITION_NAME.equals(connectionDesc.getMDS_PARTITION_NAME()) && resourcePaletteProvider.isDBMDSProvider()) {
            DBMetadataStore store = new DBMetadataStore(resourcePaletteProvider.getDBUserId(), resourcePaletteProvider.getDBPassword(), connectionDesc.getDBMDS_JDBC_URL(), MDS_BPM_PARTITION_NAME);
            result = MdsInstanceInitializer.getMDSInstance((String)(MDS_BPM_PARTITION_NAME + selectedMdsConnection + System.currentTimeMillis()), (MetadataStore)store, (Namespace)Namespace.BPM);
        } else {
            try {
                result = resourcePaletteProvider.getMDSInstance();
            }
            catch (Exception e) {
                MdsLogger.getInstance().logStackTrace(e);
                throw new BpmConnectionException(FusionStudioMsg.CANNOT_OBTAIN_CONNECTION_FROM_RESOURCE_PALETTE((String)selectedMdsConnection), e);
            }
        }
        return result;
    }

    private void setMdsInstance(BPMConnectionDescriptor bpmConnectionDescriptor, MDSInstance mdsInstance, ApplicationServerConnection securityConnection) throws MetadataException {
        this.mdsInstance = mdsInstance;
        this.securityConnection = securityConnection;
        this.bpmConnectionDescriptor = bpmConnectionDescriptor;
        this.service = mdsInstance != null ? new StudioMetadataServiceImpl(mdsInstance, securityConnection) : null;
    }

    private void fireStatusChanged(Status newStatus, Status oldStatus) {
        for (StatusListener statusListener : this.statusListeners) {
            statusListener.statusChanged(newStatus, oldStatus);
        }
    }

    private void updateConnectionStatus() {
        if (this.status != Status.CONNECTING) {
            if (this.getMdsInstance() == null) {
                this.changeStatus(Status.DISCONNECTED);
            } else {
                this.changeStatus(Status.CONNECTED);
            }
        }
    }

    private void changeStatus(Status newStatus) {
        if (this.status != newStatus) {
            Status oldStatus = this.status;
            this.status = newStatus;
            this.fireStatusChanged(this.status, oldStatus);
        }
    }

    private MDSInstance getMdsInstance() {
        return this.mdsInstance;
    }

    private File findOrCreateMdsDirectory() {
        File mdsDirectory = new File(MDS_HOME);
        if (!mdsDirectory.exists()) {
            mdsDirectory.mkdirs();
        }
        return mdsDirectory;
    }

    private void fireConfigurationChanged() {
        for (ConfigurationListener configurationListener : this.configurationListeners) {
            configurationListener.configurationChanged(this.service);
        }
    }

    static {
        MDS_HOME = System.getProperty("user.home") + File.separator + "mdsrepo";
    }

    public static interface StatusListener {
        public void statusChanged(Status var1, Status var2);
    }

    public static interface ConfigurationListener {
        public void configurationChanged(oracle.bpm.pml.service.StudioMetadataService var1);
    }

    public static enum Status {
        CONNECTED(FusionStudioMsg.CONNECTED),
        DISCONNECTED(FusionStudioMsg.DISCONNECTED),
        CONNECTING(FusionStudioMsg.CONNECTING);

        private Msg msg;

        public Msg getMsg() {
            return this.msg;
        }

        private Status(Msg msg) {
            this.msg = msg;
        }
    }
}

