/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import oracle.bpm.fusion.core.BaseNavigatorWindow;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.fusion.soa.mds.MdsUiUtils;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.action.ConfigureMdsConnectionAction;
import oracle.bpm.fusion.soa.mds.action.CreateMdsFolderAction;
import oracle.bpm.fusion.soa.mds.action.RefreshMdsProjectsAction;
import oracle.bpm.fusion.soa.mds.action.StopMdsConnectionAction;
import oracle.bpm.fusion.studio.actions.DefaultStudioActionController;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.BaseAction;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;

public class MdsProjectNavigatorWindow
extends BaseNavigatorWindow {
    private Controller controller = new MdsNavigatorController();
    private JPanel mainPanel;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private Toolbar toolbar;
    private JLabel userLoggedLabel;

    protected MdsProjectNavigatorWindow(Context context, String viewId) {
        super(context, viewId, FusionStudioMsg.MDS_PROJECT_NAVIGATOR);
    }

    public Controller getController() {
        return this.controller;
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public Component getGUI() {
        if (this.mainPanel == null) {
            this.createToolbar();
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            Component component = super.getGUI();
            this.statusPanel = this.createStatusPanel();
            this.mainPanel.add((Component)this.toolbar, "North");
            this.mainPanel.add(component, "Center");
            this.mainPanel.add((Component)this.statusPanel, "South");
            this.mainPanel.setOpaque(false);
            this.statusPanel.setVisible(false);
            this.initListeners();
        }
        return this.mainPanel;
    }

    private void createToolbar() {
        this.toolbar = new Toolbar();
        this.toolbar.setPrimaryViewToolbar(true);
        this.addActionButton(this.toolbar, new RefreshMdsProjectsAction());
        this.addActionButton(this.toolbar, new ConfigureMdsConnectionAction(), new StopMdsConnectionAction());
        this.addActionButton(this.toolbar, new CreateMdsFolderAction());
        this.toolbar.addSeparator();
        Component glue = Box.createHorizontalGlue();
        Box box = Box.createHorizontalBox();
        this.userLoggedLabel = new JLabel();
        Icon userIcon = Image.create((Msg)FusionStudioMsg.USER).asSwingIcon();
        this.userLoggedLabel.setIcon(userIcon);
        this.userLoggedLabel.setVisible(false);
        box.add(glue);
        box.add(this.userLoggedLabel);
        this.toolbar.add((Component)box);
    }

    private void addActionButton(Toolbar toolbar, BaseAction ... baseActions) {
        if (baseActions.length == 1) {
            BaseAction baseAction = baseActions[0];
            IdeAction ideAction = this.adaptBaseAction(baseAction);
            toolbar.add((ToggleAction)ideAction);
        } else {
            ToggleAction[] actions = new ToggleAction[baseActions.length];
            int i = 0;
            for (BaseAction baseAction : baseActions) {
                IdeAction ideAction = this.adaptBaseAction(baseAction);
                actions[i] = ideAction;
                ++i;
            }
            MenuToolButton menuToolButton = new MenuToolButton(actions, actions[0]);
            toolbar.add((Component)menuToolButton);
        }
    }

    private IdeAction adaptBaseAction(BaseAction baseAction) {
        int cmdId = Ide.findOrCreateCmdID((String)baseAction.getMsg().toString());
        IdeAction ideAction = IdeAction.get((int)cmdId);
        ideAction.addController((Controller)new DefaultStudioActionController(baseAction));
        return ideAction;
    }

    private void initListeners() {
        this.addViewSelectionListener(new ViewSelectionListener(){

            public void viewSelectionChanged(ViewSelectionEvent e) {
                Element selection;
                Element[] elements = e.getSelection();
                if (elements.length == 1 && (selection = elements[0]) instanceof StudioNode) {
                    MdProject mdProject = (MdProject)((StudioNode)selection).as(MdProject.class);
                    if (mdProject != null) {
                        MdsProjectNavigatorWindow.this.statusPanel.setVisible(true);
                        MdsProjectNavigatorWindow.this.statusLabel.setText(MdsUiUtils.getStatusInformationFor(mdProject));
                    } else {
                        MdsProjectNavigatorWindow.this.statusPanel.setVisible(false);
                    }
                }
            }
        });
        StudioMetadataService.getInstance().addConfigurationListener(new StudioMetadataService.ConfigurationListener(){

            @Override
            public void configurationChanged(oracle.bpm.pml.service.StudioMetadataService service) {
                if (StudioMetadataService.getInstance().isStatusConnected()) {
                    String userLogged = StudioMetadataService.getInstance().getUserLogged();
                    MdsProjectNavigatorWindow.this.userLoggedLabel.setText(userLogged);
                    MdsProjectNavigatorWindow.this.userLoggedLabel.setVisible(true);
                } else {
                    MdsProjectNavigatorWindow.this.userLoggedLabel.setVisible(false);
                }
            }
        });
    }

    private JPanel createStatusPanel() {
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        statusPanel.setBorder(new EtchedBorder());
        statusPanel.setBackground(new Color(255, 255, 215));
        this.statusLabel = new JLabel("");
        statusPanel.add((Component)this.statusLabel, "West");
        return statusPanel;
    }

    private final class MdsNavigatorController
    implements Controller {
        private MdsNavigatorController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }
    }
}

