/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.fusion.core.model.DefaultRootNode;
import oracle.bpm.fusion.core.model.NodeFactory;
import oracle.bpm.fusion.core.model.StudioFolder;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.fusion.core.model.VirtualNode;
import oracle.bpm.fusion.soa.mds.IMdsNode;
import oracle.bpm.fusion.soa.mds.MdsArtifactType;
import oracle.bpm.fusion.soa.mds.MdsFolderNode;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.MdTreeNode;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.resources.Msg;
import oracle.ide.model.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MdsNodeNavigator {
    private NodeFactory<ProjectArtifact> nodeFactory;
    private MdsFolderNode publicSharesNode;
    private MdsFolderNode templatesNode;

    public MdsNodeNavigator(NodeFactory<ProjectArtifact> nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public MdsFolderNode getTemplatesFolderNode() throws MetadataException {
        if (this.templatesNode == null) {
            ProjectFolder templatesFolder = ProjectFolder.create((String)FusionStudioMsg.MDS_TEMPLATES.toString());
            this.templatesNode = new MdsFolderNode(templatesFolder, FusionStudioMsg.MDS_TEMPLATES);
            this.templatesNode.setDefault(true);
            this.initTemplatesChildren(this.templatesNode);
        }
        return this.templatesNode;
    }

    public MdsFolderNode getPublicSharesFolderNode() throws MetadataException {
        if (this.publicSharesNode == null) {
            ProjectFolder publicSharesFolder = ProjectFolder.create((String)FusionStudioMsg.MDS_PUBLIC.toString());
            this.publicSharesNode = new MdsFolderNode(publicSharesFolder, FusionStudioMsg.MDS_PUBLIC);
            this.publicSharesNode.setDefault(true);
            this.initPublicSharesChildren(this.publicSharesNode);
        }
        return this.publicSharesNode;
    }

    Iterable<Element> getChildren(StudioNode studioNode) throws MetadataException {
        ArrayList<Element> childrenNodes = new ArrayList<Element>();
        if (studioNode instanceof DefaultRootNode) {
            StudioMetadataService metadataService = StudioMetadataService.getInstance();
            if (metadataService.isStatusConnecting()) {
                childrenNodes.add((Element)this.constructConnectingNode());
                return childrenNodes;
            }
            if (metadataService.isStatusConnected()) {
                childrenNodes.add((Element)this.getTemplatesFolderNode());
                childrenNodes.add((Element)this.getPublicSharesFolderNode());
                return childrenNodes;
            }
        }
        if (studioNode instanceof IMdsNode) {
            ArrayList<Element> children = new ArrayList<Element>();
            Iterator elementIt = studioNode.getChildren();
            while (elementIt.hasNext()) {
                children.add((Element)elementIt.next());
            }
            return children;
        }
        return CollectionUtils.emptyIterable();
    }

    StudioFolder getParent(StudioNode studioNode) {
        if (studioNode instanceof IMdsNode) {
            IMdsNode mdsNode = (IMdsNode)studioNode;
            return mdsNode.getParent();
        }
        return null;
    }

    StudioNode findNode(@NotNull IMdsNode rootNode, final ProjectArtifact projectArtifact) {
        if (rootNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/MdsNodeNavigator.findNode must not be null");
        }
        Predicate<IMdsNode> projectArtifactPredicate = new Predicate<IMdsNode>(){

            @Override
            public boolean check(@Nullable IMdsNode value) {
                ProjectArtifact projectArtifactValue = (ProjectArtifact)value.as(ProjectArtifact.class);
                if (projectArtifactValue.isMdProject() && projectArtifact.isMdProject()) {
                    MdProject mdProjectValue = (MdProject)projectArtifactValue;
                    MdProject mdProject = (MdProject)projectArtifact;
                    return mdProjectValue.getId().equals(mdProject.getId());
                }
                if (!projectArtifactValue.isMdProject() && !projectArtifact.isMdProject()) {
                    ProjectFolder projectFolderValue = (ProjectFolder)projectArtifactValue;
                    ProjectFolder projectFolder = (ProjectFolder)projectArtifact;
                    return projectFolderValue.getLocation().equals(projectFolder.getLocation());
                }
                return false;
            }
        };
        return this.findNode(rootNode, projectArtifactPredicate);
    }

    MdProject findNodeByNameAndType(final String name, @NotNull MdsArtifactType type) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/mds/MdsNodeNavigator.findNodeByNameAndType must not be null");
        }
        Predicate<IMdsNode> namePredicate = new Predicate<IMdsNode>(){

            @Override
            public boolean check(@Nullable IMdsNode value) {
                ProjectArtifact projectArtifact = (ProjectArtifact)value.getObject();
                return projectArtifact.isMdProject() && ((MdProject)projectArtifact).getName().equals(name);
            }
        };
        return (MdProject)this.findNode((IMdsNode)this.getRootFolderByType(type), namePredicate);
    }

    void addNode(MdsArtifactType type, ProjectArtifact projectArtifact, boolean notify) throws MetadataException {
        this.createRootTypeFolderTree(this.getRootFolderByType(type), projectArtifact, notify);
    }

    void removeNode(IMdsNode mdsNode, boolean notify) {
        StudioFolder parentNode = this.getParent(mdsNode);
        if (parentNode != null) {
            parentNode.remove((Element)mdsNode, notify);
            parentNode.markDirty(false);
        }
    }

    private IMdsNode findNode(IMdsNode rootNode, Predicate<IMdsNode> predicate) {
        if (predicate.check(rootNode)) {
            return rootNode;
        }
        Iterator elementIt = rootNode.getChildren();
        while (elementIt.hasNext()) {
            IMdsNode node;
            Element element = (Element)elementIt.next();
            if (!(element instanceof IMdsNode) || (node = this.findNode((IMdsNode)element, predicate)) == null) continue;
            return node;
        }
        return null;
    }

    private MdsFolderNode getRootFolderByType(MdsArtifactType type) throws MetadataException {
        if (MdsArtifactType.TEMPLATE == type) {
            return this.getTemplatesFolderNode();
        }
        if (MdsArtifactType.PUBLIC_SHARE == type) {
            return this.getPublicSharesFolderNode();
        }
        return null;
    }

    private StudioNode constructConnectingNode() {
        Msg msg = StudioMetadataService.getInstance().getStatus().getMsg();
        return new VirtualNode(null, msg);
    }

    private void initTemplatesChildren(@NotNull MdsFolderNode mdsFolderNode) throws MetadataException {
        if (mdsFolderNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/MdsNodeNavigator.initTemplatesChildren must not be null");
        }
        MdTree mdTree = StudioMetadataService.getInstance().getAllTemplates();
        this.populateTree(mdsFolderNode, mdTree);
    }

    private void initPublicSharesChildren(MdsFolderNode mdsFolderNode) throws MetadataException {
        MdTree mdTree = StudioMetadataService.getInstance().getAllPublicShares();
        this.populateTree(mdsFolderNode, mdTree);
    }

    private void populateTree(@NotNull MdsFolderNode mdsFolderNode, @NotNull MdTree mdTree) {
        if (mdsFolderNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/MdsNodeNavigator.populateTree must not be null");
        }
        if (mdTree == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/mds/MdsNodeNavigator.populateTree must not be null");
        }
        MdTreeNode rootNode = mdTree.getRootNode();
        List treeNodeList = rootNode.getChildren();
        this.populateNode(mdsFolderNode, treeNodeList);
    }

    private void populateNode(@NotNull MdsFolderNode mdsFolderNode, @NotNull List<MdTreeNode<ProjectArtifact>> children) {
        if (mdsFolderNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/MdsNodeNavigator.populateNode must not be null");
        }
        if (children == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/mds/MdsNodeNavigator.populateNode must not be null");
        }
        if (!children.isEmpty()) {
            for (MdTreeNode<ProjectArtifact> node : children) {
                ProjectArtifact projectArtifact = node.getObject();
                IMdsNode rootTypeFolderTree = this.createRootTypeFolderTree(mdsFolderNode, projectArtifact, false);
                if (projectArtifact.isMdProject()) continue;
                this.populateNode((MdsFolderNode)rootTypeFolderTree, node.getChildren());
            }
        }
    }

    private IMdsNode createRootTypeFolderTree(@NotNull MdsFolderNode rootTypeFolderNode, @NotNull ProjectArtifact projectArtifact, boolean notify) {
        ProjectFolder parentFolder;
        if (rootTypeFolderNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/MdsNodeNavigator.createRootTypeFolderTree must not be null");
        }
        if (projectArtifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/mds/MdsNodeNavigator.createRootTypeFolderTree must not be null");
        }
        IMdsNode projectArtifactStudioNode = this.findOrCreateIMdsNode(rootTypeFolderNode, projectArtifact);
        ProjectFolder projectFolder = parentFolder = projectArtifact.getParentFolder() != null ? (ProjectFolder)projectArtifact.getParentFolder().get() : null;
        if (parentFolder == null || Str.isEmpty(parentFolder.getName())) {
            projectArtifactStudioNode.setParent(rootTypeFolderNode);
            rootTypeFolderNode.add((Element)projectArtifactStudioNode, notify);
            rootTypeFolderNode.markDirty(false);
        } else {
            StudioNode parentFolderNode = this.findNode((IMdsNode)rootTypeFolderNode, (ProjectArtifact)parentFolder);
            if (parentFolderNode == null) {
                this.createRootTypeFolderTree(rootTypeFolderNode, (ProjectArtifact)parentFolder, notify);
                parentFolderNode = this.findNode((IMdsNode)rootTypeFolderNode, (ProjectArtifact)parentFolder);
            }
            MdsFolderNode mdsFolderNode = (MdsFolderNode)parentFolderNode;
            projectArtifactStudioNode.setParent(mdsFolderNode);
            mdsFolderNode.add((Element)projectArtifactStudioNode, notify);
            mdsFolderNode.markDirty(false);
        }
        return projectArtifactStudioNode;
    }

    private IMdsNode findOrCreateIMdsNode(@NotNull IMdsNode rootNode, ProjectArtifact projectArtifact) {
        if (rootNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/MdsNodeNavigator.findOrCreateIMdsNode must not be null");
        }
        IMdsNode projectArtifactNode = (IMdsNode)this.findNode(rootNode, projectArtifact);
        return projectArtifactNode == null ? (IMdsNode)this.nodeFactory.createNode((Object)projectArtifact) : projectArtifactNode;
    }
}

