/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds;

import java.io.IOException;
import java.util.List;
import javax.management.MalformedObjectNameException;
import oracle.bpm.fusion.soa.mds.model.BpmConnectionException;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.pml.service.security.ApplicationServerConnection;
import oracle.bpm.pml.service.util.JmxServerHelper;
import oracle.bpm.pml.service.util.ServerInfo;
import oracle.bpm.pml.service.util.lookup.WasHelper;
import oracle.jdeveloper.rcasadapter.AppServerProvider;
import oracle.jdeveloper.server.connection.AppServer;
import oracle.rc.asadapter.connection.AppServerConnection;
import org.jetbrains.annotations.NotNull;

public class ApplicationServerConnectionFactory {
    private static ApplicationServerConnectionFactory instance;

    public static ApplicationServerConnectionFactory getInstance() {
        if (instance == null) {
            instance = new ApplicationServerConnectionFactory();
        }
        return instance;
    }

    public ApplicationServerConnection create(@NotNull AppServer appServer, @NotNull String userName, @NotNull String password) throws BpmConnectionException, MalformedObjectNameException, IOException {
        if (appServer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ApplicationServerConnectionFactory.create must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ApplicationServerConnectionFactory.create must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ApplicationServerConnectionFactory.create must not be null");
        }
        oracle.rc.asadapter.connection.AppServerProvider appServerProvider = appServer.getConnection().getAppServerProvider();
        String soaUser = appServerProvider.getProperty("user");
        String soaPassword = appServerProvider.getProperty("password");
        ServerInfo serverInfo = this.getRunningServerUrl(appServer, userName, password);
        boolean useSsl = serverInfo.isSslEnabled();
        ApplicationServerConnection result = new ApplicationServerConnection(useSsl, serverInfo.getHost(), Integer.toString(serverInfo.getPort()), soaUser, soaPassword, userName, password);
        if (appServerProvider.getProperty("ConnectionType").equals("WebSphere_7.x")) {
            try {
                result.setWebsphere7Descriptor(WasHelper.buildWebsphere7Descriptor((AppServerProvider)appServerProvider));
            }
            catch (MetadataException e) {
                throw new BpmConnectionException(e);
            }
        }
        return result;
    }

    private ServerInfo getRunningServerUrl(@NotNull AppServer appServer, @NotNull String username, @NotNull String password) throws MalformedObjectNameException, IOException, BpmConnectionException {
        if (appServer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ApplicationServerConnectionFactory.getRunningServerUrl must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ApplicationServerConnectionFactory.getRunningServerUrl must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ApplicationServerConnectionFactory.getRunningServerUrl must not be null");
        }
        AppServerConnection connection = appServer.getConnection();
        boolean useSsl = Boolean.valueOf((String)connection.getAppServerProvider().get((Object)"USE_SSL"));
        String host = (String)connection.getAppServerProvider().get((Object)"JMX_CONNECTOR_HOST");
        String port = (String)(useSsl ? connection.getAppServerProvider().get((Object)"JMX_CONNECTOR_SSL_PORT") : connection.getAppServerProvider().get((Object)"JMX_CONNECTOR_PORT"));
        JmxServerHelper helper = new JmxServerHelper();
        try {
            ServerInfo serverInfo;
            helper.connect((AppServerProvider)connection.getAppServerProvider(), host, port, username, password, useSsl);
            List runningManagedNodes = helper.getRunningManagedNodes();
            if (runningManagedNodes.isEmpty()) {
                throw new BpmConnectionException(FusionStudioMsg.CONNECTION_COULD_NOT_BE_STABLISHED);
            }
            ServerInfo serverInfo2 = serverInfo = (ServerInfo)runningManagedNodes.iterator().next();
            return serverInfo2;
        }
        catch (SecurityException e) {
            throw new BpmConnectionException(e);
        }
        catch (Exception e) {
            throw new BpmConnectionException(e);
        }
        finally {
            helper.close();
        }
    }
}

