/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.humantask;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import oracle.bpel.services.common.util.JaxbUtil;
import oracle.bpel.services.workflow.metadata.config.model.OutcomesType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ExcludedParticipantsType;
import oracle.bpel.services.workflow.metadata.routingslip.model.GlobalConfigurationType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ListType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ManagementChainListType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ObjectFactory;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParallelCompletionCriteriaType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParameterType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParticipantsType;
import oracle.bpel.services.workflow.metadata.routingslip.model.Resource;
import oracle.bpel.services.workflow.metadata.routingslip.model.ResourceType;
import oracle.bpel.services.workflow.metadata.taskdefinition.TaskDefinitionUtil;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TranslatableValueType;
import oracle.bpm.fusion.soa.humantask.HumanTaskInfo;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.util.Identifier;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.ide.workflow.WorkflowProject;
import oracle.tip.tools.ide.common.jdev.JDevHelper;
import oracle.tip.tools.ide.rules.dictionarybuilder.jdev.DictionaryBuilderUtil;
import oracle.tip.tools.ide.workflow.editor.data.CompoundTextData;
import oracle.tip.tools.ide.workflow.editor.data.OwnerData;
import oracle.tip.tools.ide.workflow.editor.data.WFEditorData;
import oracle.tip.tools.ide.workflow.editor.outcomes.OutComesDataUtil;
import oracle.tip.tools.ide.workflow.ide.jdeveloper.JDevWorkflowProject;
import oracle.tip.tools.ide.workflow.projectwizard.WizardData;
import oracle.tip.tools.ide.workflow.util.CreateWorkflowCommand;
import oracle.xml.jaxb.JaxbNode;

public class HumanTaskUtils {
    private static final String TASK_EXTENSION = ".task";
    private static final String XPATH = "XPATH";
    private static final String IDS_NAMESPACE = "http://xmlns.oracle.com/bpel/services/IdentityService/xpath";
    private static final String IDS_PREFIX = "ids";
    private static final String BPM_NAMESPACE = "http://xmlns.oracle.com/bpmn20/extensions";
    private static final String BPM_PREFIX = "bpm";
    private static final String TASK_CREATOR_XPATH = "/task:task/task:creator";
    private static final String BPM_PERFORMER = "bpm:getPerformer()";
    private static final String BPM_LAST_PERFORMER = "bpm:getLastPerformer()";
    private static final String BPM_GROUP_PERFORMER = "ids:getUsersInAppRole(bpm:getPerformer(), 'OracleBPMProcessRolesApp', 'false')";
    private static final String IDENTITY_TYPE_APPLICATION_ROLE = "application_role";
    private static final String IDENTITY_TYPE_USER = "user";
    private static final String PROCESS_OWNER = "ProcessOwner";
    private static final String PARTICIPANT_NAME = "default.DefaultPerformer";
    private static final String STATIC = "STATIC";
    private static final String APPROVE = "APPROVE";
    private static final String APPLICATION_CONTEXT = "OracleBPMProcessRolesApp";

    private HumanTaskUtils() {
    }

    public static HumanTask createHumanTask(final oracle.bpm.project.model.Project project, final WizardData data, final WFEditorData editorData, final HumanTaskInfo humanTaskInfo) throws ProjectException {
        final Any.Holder result = new Any.Holder();
        VFileSystem dataFileSystem = project.getLoader().getProjectFileSystem().getDataFileSystem();
        dataFileSystem.runWithEventsDelayed(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Transactable root = (Transactable)project.getCatalogRoot();
                    try {
                        root.beginTransaction();
                        Project jdevProject = (Project)HumanTaskUtils.adaptTo(project, Project.class);
                        result.value = HumanTaskUtils.createHumanTask(jdevProject, data, editorData, humanTaskInfo);
                        try {
                            ComponentCatalog catalog = project.getComponentCatalog();
                            catalog.sync();
                            String humanTaskName = data.getWorkflowName();
                            String normalizedName = Identifier.classname(humanTaskName);
                            String humanTaskCatalogId = "HumanTasks." + normalizedName;
                            result.value = project.findCatalogObject(humanTaskCatalogId);
                        }
                        catch (Throwable e) {
                            result.value = new ProjectException((ProjectObject)project, FusionSoaMsg.ERROR_CATALOGING_HUMANTASK(data.getWorkflowName()), e);
                        }
                    }
                    finally {
                        root.endTransaction();
                    }
                }
                catch (Throwable e) {
                    result.value = new ProjectException((ProjectObject)project, FusionSoaMsg.ERROR_CREATING_HUMANTASK(data.getWorkflowName()), e);
                }
            }
        });
        if (result.value instanceof ProjectException) {
            throw (ProjectException)((Object)result.value);
        }
        return result.value instanceof HumanTask ? (HumanTask)result.value : null;
    }

    public static WFEditorData createDefaultWFEditorData(String projectName) {
        WFEditorData data = new WFEditorData();
        OwnerData ownerData = data.getOwnerData();
        ownerData.setIsStatic(true);
        ownerData.setExpression(projectName + "." + PROCESS_OWNER);
        return data;
    }

    private static URL createHumanTask(Project jdevProject, WizardData data, WFEditorData editorData, HumanTaskInfo humanTaskInfo) throws Exception {
        Workspace workspace = DictionaryBuilderUtil.getWorkspace((Project)jdevProject);
        String name = data.getWorkflowName();
        JDevWorkflowProject workflowProject = new JDevWorkflowProject(jdevProject, name);
        CreateWorkflowCommand creator = new CreateWorkflowCommand();
        String nameSpace = data.getNamespace();
        Collection outcomes = OutComesDataUtil.customOutcomesToStrings((Collection)editorData.getOutComes());
        Collection payloadData = editorData.getPayloadContainer().getPayloadData();
        creator.doIt(workspace, (WorkflowProject)workflowProject, name, nameSpace, payloadData, "", outcomes, editorData.getPriority());
        URL projectUrl = data.getProjectDirectory();
        URL url = URLFactory.newURL((URL)projectUrl, (String)(name + TASK_EXTENSION));
        HumanTaskUtils.updateHumanTask(url, editorData, humanTaskInfo);
        JDevHelper.refreshProjectInAppNavigator((Project)jdevProject);
        return url;
    }

    private static void updateHumanTask(URL taskUrl, WFEditorData editorData, HumanTaskInfo humanTaskInfo) throws Exception {
        oracle.bpel.services.workflow.metadata.taskdefinition.model.ObjectFactory objectFactory;
        CompoundTextData titleTextData;
        OutcomesType outcomes;
        String defaultOutcome;
        File taskFile = HumanTaskUtils.createFileFromUrl(taskUrl);
        TaskDefinition taskDefinition = HumanTaskUtils.loadTask(taskFile);
        if (taskDefinition instanceof JaxbNode) {
            JaxbUtil.setNamespaceDeclaration((JaxbNode)((JaxbNode)taskDefinition), (String)BPM_PREFIX, (String)BPM_NAMESPACE);
            if (humanTaskInfo.getHumanTaskType().isGroup()) {
                JaxbUtil.setNamespaceDeclaration((JaxbNode)((JaxbNode)taskDefinition), (String)IDS_PREFIX, (String)IDS_NAMESPACE);
            }
        }
        if (!Str.isEmpty(defaultOutcome = editorData.getDefaultOutcome()) && (outcomes = taskDefinition.getWorkflowConfiguration().getOutcomes()) != null) {
            outcomes.setDefault(defaultOutcome);
        }
        if ((titleTextData = editorData.getTaskTitle()) != null) {
            objectFactory = new oracle.bpel.services.workflow.metadata.taskdefinition.model.ObjectFactory();
            TranslatableValueType tvt = objectFactory.createTranslatableValueType();
            CompoundTextData.TYPE type = titleTextData.getType();
            if (CompoundTextData.TYPE.STATIC.equals((Object)type)) {
                tvt.setType(STATIC);
                tvt.setValue(titleTextData.getText());
            } else if (CompoundTextData.TYPE.XPATH.equals((Object)type)) {
                tvt.setType(XPATH);
                tvt.setValue(titleTextData.getText());
            } else if (CompoundTextData.TYPE.RESOURCE.equals((Object)type)) {
                tvt.setType("RESOURCE");
                tvt.setValue(titleTextData.getKey());
                Collection values = titleTextData.getValues();
                List param = tvt.getParam();
                param.clear();
                for (String s : values) {
                    param.add(s);
                }
            }
            taskDefinition.setTitle(tvt);
        }
        switch (humanTaskInfo.getHumanTaskType()) {
            case COMPLEX: {
                HumanTaskUtils.includeComplexPattern(taskDefinition, humanTaskInfo);
                break;
            }
            case FYI: {
                HumanTaskUtils.includeFYIPattern(taskDefinition, humanTaskInfo);
                break;
            }
            case GROUP: {
                HumanTaskUtils.includeGroupVotePattern(taskDefinition, humanTaskInfo);
                break;
            }
            case MANAGEMENT: {
                HumanTaskUtils.includeManagementPattern(taskDefinition, humanTaskInfo);
                break;
            }
            case SIMPLE: {
                HumanTaskUtils.includeSimplePattern(taskDefinition, humanTaskInfo);
                break;
            }
            case INITIATOR: {
                HumanTaskUtils.includeInitiatorPattern(taskDefinition, humanTaskInfo);
            }
        }
        HumanTaskUtils.includeApplicationRoleAndContext(taskDefinition, editorData.getOwnerData());
        if (humanTaskInfo.isCurrentLaneParticipant() && humanTaskInfo.isExcludePreviousParticipant()) {
            objectFactory = new ObjectFactory();
            ExcludedParticipantsType excludedParticipantsType = objectFactory.createExcludedParticipantsType();
            ExcludedParticipantsType.ExcludedParticipant excludedParticipant = objectFactory.createExcludedParticipantsTypeExcludedParticipant();
            excludedParticipant.setValue("previousLaneParticipant");
            excludedParticipantsType.getExcludedParticipant().add(excludedParticipant);
            taskDefinition.getRoutingSlip().setExcludedParticipants(excludedParticipantsType);
        }
        TaskDefinitionUtil.getInstance().marshal((Object)taskDefinition, taskFile.getAbsolutePath());
    }

    private static void includeInitiatorPattern(TaskDefinition taskDefinition, HumanTaskInfo humanTaskInfo) {
        List list = HumanTaskUtils.getParticipantOrSequentialParticipantOrAdhoc(taskDefinition);
        ObjectFactory objectFactory = new ObjectFactory();
        ParticipantsType.Participant participant = objectFactory.createParticipantsTypeParticipant();
        participant.setName(PARTICIPANT_NAME);
        list.add(participant);
        Resource resource = objectFactory.createResource();
        resource.setType(XPATH);
        resource.setIdentityType(IDENTITY_TYPE_USER);
        resource.setValue(TASK_CREATOR_XPATH);
        participant.getResource().add(resource);
        taskDefinition.getWorkflowConfiguration().setGlobalCreationTask(true);
    }

    private static File createFileFromUrl(URL url) {
        File f;
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            f = new File(url.getPath());
        }
        return f;
    }

    private static void includeSimplePattern(TaskDefinition taskDefinition, HumanTaskInfo humanTaskInfo) {
        List list = HumanTaskUtils.getParticipantOrSequentialParticipantOrAdhoc(taskDefinition);
        ObjectFactory objectFactory = new ObjectFactory();
        ParticipantsType.Participant participant = objectFactory.createParticipantsTypeParticipant();
        participant.setName(PARTICIPANT_NAME);
        list.add(participant);
        Resource resource = HumanTaskUtils.createBpmPerformerResource(objectFactory, humanTaskInfo);
        participant.getResource().add(resource);
    }

    private static void includeManagementPattern(TaskDefinition taskDefinition, HumanTaskInfo humanTaskInfo) {
        List list = HumanTaskUtils.getParticipantOrSequentialParticipantOrAdhoc(taskDefinition);
        ObjectFactory objectFactory = new ObjectFactory();
        ParticipantsType.SequentialParticipant sequentialParticipant = objectFactory.createParticipantsTypeSequentialParticipant();
        sequentialParticipant.setName(PARTICIPANT_NAME);
        ListType listType = objectFactory.createListType();
        ManagementChainListType managementChain = objectFactory.createManagementChainListType();
        Resource resource = HumanTaskUtils.createBpmPerformerResource(objectFactory, humanTaskInfo);
        managementChain.getResource().add(resource);
        HumanTaskInfo.Management management = humanTaskInfo.getManagement();
        ParameterType topParticipantType = objectFactory.createParameterType();
        topParticipantType.setType(STATIC);
        topParticipantType.setValue(String.valueOf(management.getTopParticipant()));
        managementChain.setTitle(topParticipantType);
        ParameterType levelType = objectFactory.createParameterType();
        levelType.setType(STATIC);
        levelType.setValue(String.valueOf(management.getNumberOfLevel()));
        managementChain.setLevels(levelType);
        listType.setManagementChain(managementChain);
        sequentialParticipant.setList(listType);
        list.add(sequentialParticipant);
    }

    private static Resource createBpmPerformerResource(ObjectFactory objectFactory, HumanTaskInfo humanTaskInfo) {
        String identityType;
        String performer;
        Resource resource = objectFactory.createResource();
        if (humanTaskInfo.isCurrentLaneParticipant()) {
            if (humanTaskInfo.getHumanTaskType().isGroup()) {
                performer = BPM_GROUP_PERFORMER;
                identityType = IDENTITY_TYPE_USER;
            } else {
                performer = BPM_PERFORMER;
                identityType = IDENTITY_TYPE_APPLICATION_ROLE;
            }
        } else {
            performer = BPM_LAST_PERFORMER;
            identityType = IDENTITY_TYPE_USER;
        }
        resource.setType(XPATH);
        resource.setIdentityType(identityType);
        resource.setValue(performer);
        return resource;
    }

    private static void includeGroupVotePattern(TaskDefinition taskDefinition, HumanTaskInfo humanTaskInfo) {
        List list = HumanTaskUtils.getParticipantOrSequentialParticipantOrAdhoc(taskDefinition);
        ObjectFactory objectFactory = new ObjectFactory();
        ParticipantsType.Parallel parallel = objectFactory.createParticipantsTypeParallel();
        parallel.setName(PARTICIPANT_NAME);
        parallel.setCollaboration(false);
        list.add(parallel);
        ParallelCompletionCriteriaType vote = objectFactory.createParallelCompletionCriteriaType();
        ParameterType defaultOutcome = objectFactory.createParameterType(APPROVE);
        defaultOutcome.setType(STATIC);
        vote.setDefaultOutcome(defaultOutcome);
        ParameterType percentageOfOutcome = objectFactory.createParameterType("50");
        percentageOfOutcome.setType(STATIC);
        vote.setPercentageOfOutcome(percentageOfOutcome);
        parallel.setVote(vote);
        Resource resource = HumanTaskUtils.createBpmPerformerResource(objectFactory, humanTaskInfo);
        parallel.getResourceOrRoutingSlip().add(resource);
    }

    private static void includeApplicationRoleAndContext(TaskDefinition taskDefinition, OwnerData ownerData) {
        ObjectFactory objectFactory = new ObjectFactory();
        ResourceType taskOwner = objectFactory.createResourceType();
        taskOwner.setType(ownerData.isStatic() ? STATIC : XPATH);
        taskOwner.setIdentityType(IDENTITY_TYPE_APPLICATION_ROLE);
        taskOwner.setValue(ownerData.getExpression());
        GlobalConfigurationType globalConfiguration = objectFactory.createGlobalConfigurationType();
        globalConfiguration.setTaskOwner(taskOwner);
        globalConfiguration.setApplicationContext(APPLICATION_CONTEXT);
        taskDefinition.getRoutingSlip().setGlobalConfiguration(globalConfiguration);
    }

    private static void includeFYIPattern(TaskDefinition taskDefinition, HumanTaskInfo humanTaskInfo) {
        List list = HumanTaskUtils.getParticipantOrSequentialParticipantOrAdhoc(taskDefinition);
        taskDefinition.getWorkflowConfiguration().setBpelNoCallbacks(true);
        ObjectFactory objectFactory = new ObjectFactory();
        ParticipantsType.Fyi fyi = objectFactory.createParticipantsTypeFyi();
        fyi.setName(PARTICIPANT_NAME);
        list.add(fyi);
        Resource resource = HumanTaskUtils.createBpmPerformerResource(objectFactory, humanTaskInfo);
        fyi.getResource().add(resource);
    }

    private static List getParticipantOrSequentialParticipantOrAdhoc(TaskDefinition taskDefinition) {
        ParticipantsType participantsType = taskDefinition.getRoutingSlip().getParticipants();
        ParticipantsType.Stage stage = (ParticipantsType.Stage)participantsType.getParticipantOrSequentialParticipantOrAdhoc().get(0);
        return stage.getParticipantOrSequentialParticipantOrAdhoc();
    }

    private static void includeComplexPattern(TaskDefinition taskDefinition, HumanTaskInfo humanTaskInfo) {
    }

    private static TaskDefinition loadTask(File taskFile) throws Exception {
        return (TaskDefinition)TaskDefinitionUtil.getInstance().unmarshal(taskFile.getAbsolutePath());
    }

    private static <T> T adaptTo(Object object, Class<T> cl) {
        return Platform.getAdapterService().adaptTo(object, cl);
    }
}

