/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.humantask;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.HumanTaskData;
import oracle.bpm.designer.HumanTaskPreferences;
import oracle.bpm.designer.HumanTaskService;
import oracle.bpm.fusion.soa.humantask.HumanTaskDialog;
import oracle.bpm.fusion.soa.humantask.HumanTaskPanel;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.ide.workflow.WorkflowProject;
import oracle.tip.tools.ide.workflow.ide.jdeveloper.JDevWorkflowProject;
import oracle.tip.tools.ide.workflow.util.CreateCustomFormAction;
import oracle.tip.tools.ide.workflow.util.CreateDefaultFormAction;
import oracle.tip.tools.ide.workflow.util.OutcomesProvider;
import oracle.tip.tools.ide.workflow.util.WorkflowDataLoader;
import oracle.tip.tools.ide.workflow.util.notifications.NotificationHeader;

public class HumanTaskServiceImpl
implements HumanTaskService {
    private static HumanTaskServiceImpl instance = null;

    private HumanTaskServiceImpl() {
    }

    public static HumanTaskServiceImpl getInstance() {
        if (instance == null) {
            instance = new HumanTaskServiceImpl();
        }
        return instance;
    }

    public HumanTaskData createHumanTask(UiWindow parent, UserTask userTask, HumanTaskPreferences humanTaskPreferences) {
        HumanTaskData result = null;
        oracle.bpm.project.model.Project project = userTask.getProject();
        Project jdevProject = HumanTaskServiceImpl.getJDevProject(project);
        if (jdevProject != null) {
            HumanTaskDialog dialog = HumanTaskPanel.createDialog(parent, userTask, humanTaskPreferences);
            dialog.setVisible(true);
            if (dialog.userAccepted()) {
                result = dialog.getHumanTaskData();
            }
        } else {
            MessageDialog.showError((UiContainer)parent, (Msg)FusionSoaMsg.ERROR_NO_JDEV_PROJECT_HUMANTASK(project.getId()));
        }
        return result;
    }

    public void createDefaultForm(UiWindow parent, HumanTask humanTask) {
        CreateDefaultFormAction defaultFormAction = new CreateDefaultFormAction();
        WorkflowProject workflowProject = HumanTaskServiceImpl.createWorkflowProject(humanTask);
        defaultFormAction.setWorkflowProject(workflowProject);
        ActionEvent actionEvent = HumanTaskServiceImpl.createActionEvent((Component)parent.getNative());
        defaultFormAction.actionPerformed(actionEvent);
    }

    public void createCustomForm(UiWindow parent, HumanTask humanTask) {
        CreateCustomFormAction customFormAction = new CreateCustomFormAction();
        WorkflowProject workflowProject = HumanTaskServiceImpl.createWorkflowProject(humanTask);
        customFormAction.setWorkflowProject(workflowProject);
        ActionEvent actionEvent = HumanTaskServiceImpl.createActionEvent((Component)parent.getNative());
        customFormAction.actionPerformed(actionEvent);
    }

    public Sequence<String> getUserNotificationHeaders() {
        ArrayList<String> result = new ArrayList<String>();
        WorkflowDataLoader loader = new WorkflowDataLoader();
        List headers = loader.getNotificationHeaders();
        for (NotificationHeader header : headers) {
            result.add(header.getName());
        }
        return CollectionUtils.asSequence(result);
    }

    public Sequence<String> getHumanTaskOutcomes() {
        OutcomesProvider outcomesProvider = new OutcomesProvider();
        return CollectionUtils.asSequence(outcomesProvider.getOutcomes());
    }

    private static Project getJDevProject(oracle.bpm.project.model.Project project) {
        Project result = null;
        if (project instanceof Adaptable) {
            Adaptable adaptable = (Adaptable)project;
            result = adaptable.as(Project.class);
        }
        return result;
    }

    private static WorkflowProject createWorkflowProject(HumanTask humanTask) {
        oracle.bpm.project.model.Project project = humanTask.getProject();
        String name = humanTask.getName();
        Project jdevProject = HumanTaskServiceImpl.getJDevProject(project);
        System.out.println("HumanTaskServiceImpl.createWorkflowProject name=" + name + " jDevproject=" + jdevProject.getShortLabel());
        return new JDevWorkflowProject(jdevProject, name);
    }

    private static ActionEvent createActionEvent(Component component) {
        return new ActionEvent(component, 1001, "");
    }
}

