/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.humantask;

import oracle.bpm.designer.HumanTaskPreferences;
import oracle.bpm.fusion.soa.humantask.HumanTaskDialog;
import oracle.bpm.fusion.soa.humantask.HumanTaskGeneralPanel;
import oracle.bpm.fusion.soa.humantask.HumanTaskInfo;
import oracle.bpm.fusion.soa.humantask.HumanTaskUtils;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.tip.tools.ide.workflow.editor.data.WFEditorData;
import oracle.tip.tools.ide.workflow.projectwizard.WizardData;

public class HumanTaskPanel
extends Panel {
    private HumanTaskGeneralPanel generalPanel;
    private UserTask userTask;

    public HumanTaskPanel(UiContainer parent, UserTask userTask, HumanTaskPreferences humanTaskPreferences, String defaultName) {
        super(parent);
        this.userTask = userTask;
        this.init(humanTaskPreferences, defaultName);
    }

    public static HumanTaskDialog createDialog(UiWindow parent, UserTask userTask, HumanTaskPreferences humanTaskPreferences) {
        return new HumanTaskDialog(parent, userTask, humanTaskPreferences);
    }

    public HumanTaskInfo getHumanTaskInfo() {
        HumanTaskInfo data = new HumanTaskInfo();
        this.generalPanel.applyToHumanTaskInfo(data);
        return data;
    }

    public WizardData getWizardData() {
        WizardData data = new WizardData();
        this.generalPanel.applyToWizardData(data);
        data.setOpenEditor(false);
        return data;
    }

    public WFEditorData getWFEditorData() {
        WFEditorData data = HumanTaskUtils.createDefaultWFEditorData(this.getProject().getId());
        this.generalPanel.applyToWFEditorData(data);
        return data;
    }

    boolean validateData() {
        return this.generalPanel.validateData();
    }

    private UserTask getUserTask() {
        return this.userTask;
    }

    private Project getProject() {
        return this.getUserTask().getProject();
    }

    private void init(HumanTaskPreferences humanTaskPreferences, String defaultName) {
        this.setLayout((Layout)new BorderLayout());
        TabbedPane tabbedPane = new TabbedPane((UiContainer)this);
        this.generalPanel = new HumanTaskGeneralPanel((UiContainer)tabbedPane, this.getUserTask(), humanTaskPreferences, defaultName);
        tabbedPane.addTab(UIMsg.GENERAL, (UiComponent)this.generalPanel);
        this.add((UiComponent)tabbedPane, "Center");
    }
}

