/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.humantask;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.HumanTaskPreferences;
import oracle.bpm.designer.flowpanels.HumanTaskTypeCombo;
import oracle.bpm.designer.flowpanels.PriorityCombo;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.soa.humantask.HumanTaskInfo;
import oracle.bpm.fusion.soa.humantask.ParametersPanel;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.soa.humantask.msg.HumantaskMsg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextField;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.utils.XMLUtil;
import oracle.tip.tools.ide.workflow.editor.OutcomesComponent;
import oracle.tip.tools.ide.workflow.editor.data.CompoundTextData;
import oracle.tip.tools.ide.workflow.editor.data.WFEditorData;
import oracle.tip.tools.ide.workflow.editor.outcomes.OutComesData;
import oracle.tip.tools.ide.workflow.editor.outcomes.OutComesDataUtil;
import oracle.tip.tools.ide.workflow.projectwizard.WizardData;
import oracle.tip.tools.ide.workflow.util.TaskDefinitionBuilder;
import oracle.tip.tools.ide.workflow.util.WorkflowResourceUtil;

class HumanTaskGeneralPanel
extends Panel {
    private HumanTaskTypeCombo humanTaskTypeComboBox;
    private IdentifierTextField nameTextField;
    private OutcomesComponent outcomesComponent;
    private ParametersPanel parametersPanel;
    private PriorityCombo priorityComboBox;
    private PropertiesCardPanel propertiesCardPanel;
    private TextField titleTextField;
    private UserTask userTask;
    private static final String WORKFLOW_EXISTS = WorkflowResourceUtil.getString((String)"WORKFLOW_EXISTS");
    private static final String INVALID_WORKFLOW_NAME = WorkflowResourceUtil.getString((String)"INVALID_WORKFLOW_NAME");
    private static final StringList INITIATOR_OUTCOMES = StringList.create("SUBMIT");

    HumanTaskGeneralPanel(UiContainer parent, UserTask userTask, HumanTaskPreferences humanTaskPreferences, String defaultName) {
        super(parent);
        this.userTask = userTask;
        this.init(humanTaskPreferences, defaultName);
    }

    public void applyToHumanTaskInfo(HumanTaskInfo data) {
        data.setHumanTaskType(this.getHumanTaskType());
        this.propertiesCardPanel.applyToHumanTaskInfo(data);
        data.setInputParameters(this.parametersPanel.createInputParameters());
        data.setOutputParameters(this.parametersPanel.createOutputParameters());
    }

    boolean validateData() {
        String workflowName = this.getHumanTaskName();
        if (!XMLUtil.isNCName((String)workflowName)) {
            GraphUtils.displayMessage((Component)this.asSwing(), (String)INVALID_WORKFLOW_NAME, (int)0);
            return false;
        }
        URL url = URLFileSystem.getParent((URL)this.getJDevProject().getURL());
        URL taskURL = URLFactory.newURL((URL)url, (String)(workflowName + ".task"));
        if (URLFileSystem.exists((URL)taskURL)) {
            GraphUtils.displayMessage((Component)this.asSwing(), (String)WORKFLOW_EXISTS, (int)0);
            return false;
        }
        return this.parametersPanel.validateData();
    }

    void applyToWizardData(WizardData data) {
        String taskName = this.getHumanTaskName();
        data.setProjectName(taskName);
        data.setWorkflowName(taskName);
        URL projectUrl = this.getProjectURL();
        data.setProjectDirectory(URLFileSystem.getParent((URL)projectUrl));
        data.setNamespace(this.getDefaultNamespace(taskName));
    }

    void applyToWFEditorData(WFEditorData data) {
        data.setOutComes(this.getOutcomes());
        data.setDefaultOutcome(this.getDefaultOutcome());
        data.setTaskTitle(this.getCompoundTextData());
        data.setPriority(this.getPriority());
        this.parametersPanel.applyToWFEditorData(data);
    }

    private static Collection<OutComesData> getDefaultOutcomes(HumanTaskType humanTaskType) {
        Collection<String> outcomes = humanTaskType.isInitiator() ? INITIATOR_OUTCOMES : TaskDefinitionBuilder.getDefaultOutcomes();
        return OutComesDataUtil.stringsToOutcomes((Collection)outcomes);
    }

    private HumanTaskType getHumanTaskType() {
        return (HumanTaskType)this.humanTaskTypeComboBox.getSelectedItem();
    }

    private IdentifierTextField getNameTextField() {
        return this.nameTextField;
    }

    private String getHumanTaskName() {
        return this.getNameTextField().getText().trim();
    }

    private Collection<OutComesData> getOutcomes() {
        return this.outcomesComponent.getOutcomes();
    }

    private String getDefaultOutcome() {
        return this.outcomesComponent.getDefaultOutcome();
    }

    private CompoundTextData getCompoundTextData() {
        CompoundTextData textData = new CompoundTextData();
        textData.setType(CompoundTextData.TYPE.STATIC);
        textData.setText(this.getTitle());
        return textData;
    }

    private String getTitle() {
        return this.titleTextField.getText();
    }

    private void init(HumanTaskPreferences humanTaskPreferences, String defaultName) {
        this.setLayout((Layout)new MigLayout("fill, gapx 5, ins 5"));
        this.nameTextField = new IdentifierTextField((UiContainer)this, defaultName, 30, true);
        HumanTaskType type = this.userTask.getHumanTaskType();
        HumanTaskType defaultHumanTaskType = type != null ? type : HumanTaskType.SIMPLE;
        this.priorityComboBox = new PriorityCombo((UiContainer)this);
        this.priorityComboBox.setSelectedItem((Object)humanTaskPreferences.getPriority());
        this.titleTextField = new TextField((UiContainer)this, 40);
        this.humanTaskTypeComboBox = HumanTaskTypeCombo.create((UiContainer)this, (HumanTaskType)defaultHumanTaskType);
        this.humanTaskTypeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HumanTaskGeneralPanel.this.changeHumanTaskType((HumanTaskType)HumanTaskGeneralPanel.this.humanTaskTypeComboBox.getSelectedItem());
            }
        });
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.NAME));
        this.add((UiComponent)this.nameTextField, "growx 70");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectModelMsg.VAR_PRIORITY_KEY));
        this.add((UiComponent)this.priorityComboBox, "growx 30, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.TITLE));
        this.add((UiComponent)this.titleTextField, "spanx 3, growx, wrap");
        this.outcomesComponent = new OutcomesComponent();
        this.updateOutcomesComponent(defaultHumanTaskType);
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.OUTCOMES));
        this.add(UiComponent.get((Object)this.outcomesComponent), "spanx 3, growx, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.PATTERN));
        this.add((UiComponent)this.humanTaskTypeComboBox, "wrap");
        this.propertiesCardPanel = PropertiesCardPanel.create((UiContainer)this, defaultHumanTaskType);
        this.add((UiComponent)this.propertiesCardPanel, "skip 1, spanx 3, growx, wrap");
        this.parametersPanel = new ParametersPanel((UiContainer)this, this.userTask);
        this.add((UiComponent)this.parametersPanel, "spanx 4, grow");
    }

    private void changeHumanTaskType(HumanTaskType humanTaskType) {
        this.propertiesCardPanel.show(humanTaskType);
        this.updateOutcomesComponent(humanTaskType);
        this.getOwnerWindow().pack();
    }

    private void updateOutcomesComponent(HumanTaskType humanTaskType) {
        Collection<OutComesData> outcomes = HumanTaskGeneralPanel.getDefaultOutcomes(humanTaskType);
        this.outcomesComponent.setData(outcomes);
        this.outcomesComponent.setPreActionOutcomes(outcomes);
    }

    private int getPriority() {
        return (Integer)this.priorityComboBox.getSelectedItem();
    }

    private URL getProjectURL() {
        return this.getJDevProject().getURL();
    }

    private oracle.bpm.project.model.Project getProject() {
        return this.userTask.getProject();
    }

    private Project getJDevProject() {
        return ((Adaptable)this.getProject()).as(Project.class);
    }

    private String getDefaultNamespace(String workflowName) {
        URL url = URLFileSystem.getParent((URL)this.getJDevProject().getURL());
        URL parent = URLFileSystem.getParent((URL)url);
        String application = URLFileSystem.getName((URL)parent);
        String scaProject = URLFileSystem.getFileName((URL)url);
        String name = application + "/" + scaProject + "/" + workflowName;
        return TaskDefinitionBuilder.generateTargetNamespace((String)name);
    }

    private static class PropertiesCardPanel
    extends Panel {
        private PropertiesPanel activePanel = null;
        private CommonParticipantPanel commonPanel;
        private EmptyPanel emptyPanel;
        private ManagementPanel managementPanel;

        private PropertiesCardPanel(UiContainer parent, HumanTaskType type) {
            super(parent);
            this.setLayout((Layout)new CardLayout());
            this.show(type);
        }

        public static PropertiesCardPanel create(UiContainer parent, HumanTaskType type) {
            return new PropertiesCardPanel(parent, type);
        }

        public CardLayout getLayout() {
            return (CardLayout)super.getLayout();
        }

        public void show(HumanTaskType type) {
            String key = type.name();
            if (this.activePanel != null) {
                this.remove((UiComponent)this.activePanel);
            }
            if (type.isManagement()) {
                if (this.managementPanel == null) {
                    this.managementPanel = ManagementPanel.create((UiContainer)this);
                }
                this.add((UiComponent)this.managementPanel, key);
                this.activePanel = this.managementPanel;
            } else if (type.isSimple() || type.isFyi() || type.isGroup()) {
                if (this.commonPanel == null) {
                    this.commonPanel = CommonParticipantPanel.create((UiContainer)this);
                }
                this.add((UiComponent)this.commonPanel, key);
                this.activePanel = this.commonPanel;
            } else {
                if (this.emptyPanel == null) {
                    this.emptyPanel = EmptyPanel.create((UiContainer)this);
                }
                this.add((UiComponent)this.emptyPanel, key);
                this.activePanel = this.emptyPanel;
            }
            this.getLayout().show((UiContainer)this, key);
        }

        public void applyToHumanTaskInfo(HumanTaskInfo data) {
            if (this.activePanel != null) {
                this.activePanel.applyToHumanTaskInfo(data);
            }
        }

        private static class ManagementPanel
        extends LaneParticipantPanel {
            private NumericField<Integer> levelsNumericField;
            private TextField topParticipantTextField;

            private ManagementPanel(UiContainer parent) {
                super(parent);
                this.init();
            }

            public static ManagementPanel create(UiContainer parent) {
                return new ManagementPanel(parent);
            }

            @Override
            protected void applyToHumanTaskInfo(HumanTaskInfo data) {
                super.applyToHumanTaskInfo(data);
                HumanTaskInfo.Management management = data.getManagement();
                management.setTopParticipant(this.topParticipantTextField.getText());
                management.setNumberOfLevels((Integer)this.levelsNumericField.getValue());
            }

            private static NumericField<Integer> createLevelsNumericField(UiContainer parent) {
                NumericField result = NumericField.createIntegerNumericField((UiContainer)parent, (boolean)true);
                result.setMinimum((Number)1);
                result.setValue((Number)1);
                return result;
            }

            private void init() {
                this.setLayout((Layout)new MigLayout("fill, gapx 5, ins 0"));
                this.addPerformerComponents((UiContainer)this);
                this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.TOP_PARTICIPANT));
                this.topParticipantTextField = new TextField((UiContainer)this, 30);
                this.add((UiComponent)this.topParticipantTextField, "wrap");
                this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.NUMBER_OF_LEVELS));
                this.levelsNumericField = ManagementPanel.createLevelsNumericField((UiContainer)this);
                this.add((UiComponent)this.levelsNumericField, "wrap");
            }
        }

        private static class EmptyPanel
        extends PropertiesPanel {
            private EmptyPanel(UiContainer parent) {
                super(parent);
            }

            public static EmptyPanel create(UiContainer parent) {
                return new EmptyPanel(parent);
            }

            @Override
            protected void applyToHumanTaskInfo(HumanTaskInfo data) {
            }
        }

        private static class CommonParticipantPanel
        extends LaneParticipantPanel {
            private CommonParticipantPanel(UiContainer parent) {
                super(parent);
                this.init();
            }

            public static CommonParticipantPanel create(UiContainer parent) {
                return new CommonParticipantPanel(parent);
            }

            private void init() {
                this.setLayout((Layout)new MigLayout("fill, gapx 5, ins 0"));
                this.addPerformerComponents((UiContainer)this);
            }
        }

        private static abstract class PropertiesPanel
        extends Panel {
            protected PropertiesPanel(UiContainer parent) {
                super(parent, null);
            }

            protected abstract void applyToHumanTaskInfo(HumanTaskInfo var1);
        }

        private static abstract class LaneParticipantPanel
        extends PropertiesPanel {
            private RadioButton currentLaneButton;
            private CheckBox excludeCheckBox;

            protected LaneParticipantPanel(UiContainer parent) {
                super(parent);
            }

            @Override
            protected void applyToHumanTaskInfo(HumanTaskInfo data) {
                boolean isCurrentLaneParticipant = this.currentLaneButton.isSelected();
                boolean isExcludePreviousParticipant = isCurrentLaneParticipant && this.excludeCheckBox.isSelected();
                data.setCurrentLaneParticipant(isCurrentLaneParticipant);
                data.setExcludePreviousParticipant(isExcludePreviousParticipant);
            }

            protected void addPerformerComponents(UiContainer container) {
                Panel radioPanels = new Panel(container);
                radioPanels.setLayout((Layout)new FlowLayout(0, 0, 0));
                this.currentLaneButton = new RadioButton((UiContainer)radioPanels, HumantaskMsg.CURRENT_LANE_PARTICIPANT);
                this.currentLaneButton.setSelected(true);
                RadioButton previousLaneButton = new RadioButton((UiContainer)radioPanels, HumantaskMsg.PREVIOUS_LANE_PARTICIPANT);
                this.excludeCheckBox = CheckBox.create((UiContainer)container, (Msg)HumantaskMsg.EXCLUDE_PREVIOUS_PARTICIPANTS, (boolean)false);
                this.currentLaneButton.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        LaneParticipantPanel.this.excludeCheckBox.setEnabled(e.isStateSelected());
                    }
                });
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add((AbstractButton)this.currentLaneButton);
                buttonGroup.add((AbstractButton)previousLaneButton);
                radioPanels.add((UiComponent)this.currentLaneButton);
                radioPanels.add(Box.createHorizontalStrut((UiContainer)radioPanels, (int)10));
                radioPanels.add((UiComponent)previousLaneButton);
                container.add((UiComponent)Label.create((UiContainer)container, (Msg)ProjectMsg.PERFORMER));
                container.add((UiComponent)radioPanels, (Object)"growx, wrap");
                container.add((UiComponent)this.excludeCheckBox, (Object)"skip 1, gapx 25, wrap");
            }
        }
    }
}

