/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.customization;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bpmobject.BpmObjectFactory;
import oracle.bpm.fusion.soa.customization.CustomizableArgument;
import oracle.bpm.fusion.soa.customization.CustomizableBPMObjectData;
import oracle.bpm.fusion.soa.customization.CustomizableOperation;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.model.Project;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class CustomizedServiceBuilder {
    private CustomizableBPMObjectData customizableBpmObjectData;
    private CustomizableOperation[] operations;
    private Project project;

    private CustomizedServiceBuilder(@NotNull Project project, @NotNull CustomizableBPMObjectData data, CustomizableOperation ... operations) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceBuilder.<init> must not be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceBuilder.<init> must not be null");
        }
        if (operations == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceBuilder.<init> must not be null");
        }
        this.operations = operations;
        this.project = project;
        this.customizableBpmObjectData = data;
    }

    public static CustomizedServiceBuilder create(@NotNull Project project, @NotNull CustomizableBPMObjectData data, CustomizableOperation ... operations) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceBuilder.create must not be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceBuilder.create must not be null");
        }
        if (operations == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceBuilder.create must not be null");
        }
        return new CustomizedServiceBuilder(project, data, operations);
    }

    public void addToBusinessCatalog() throws TypeCatalogException {
        MutableComponentCatalog componentCatalog = (MutableComponentCatalog)this.project.getComponentCatalog();
        this.createModules(componentCatalog);
    }

    public XObjectTypeDescription createBpmObjects(@NotNull String parentModule) throws TypeCatalogException {
        if (parentModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceBuilder.createBpmObjects must not be null");
        }
        String bpmObjectName = this.customizableBpmObjectData.getName();
        MutableComponentCatalog componentCatalog = (MutableComponentCatalog)this.project.getComponentCatalog();
        XObjectTypeDescription bpmObject = BpmObjectFactory.createXObjectTypeDescription((String)bpmObjectName, (String)parentModule, (ComponentCatalog)componentCatalog);
        bpmObject.setDescription(this.customizableBpmObjectData.getDescription());
        String target = this.customizableBpmObjectData.getTarget();
        String targetPort = this.customizableBpmObjectData.getTargetPort();
        bpmObject.setProperty("target", target);
        bpmObject.setProperty("target.port", targetPort);
        String interfaceObjectValue = this.customizableBpmObjectData.isServiceObject() ? "service.object" : "reference.object";
        bpmObject.setProperty("interface.object", interfaceObjectValue);
        TypeRef service = this.customizableBpmObjectData.getService();
        bpmObject.setTransientProperty("service.type.ref", (Object)service);
        WsdlTypeDescription wsdlType = (WsdlTypeDescription)service.get();
        bpmObject.setProperty("service.object.id", UUIDFactory.createServiceId((String)wsdlType.getNamespace(), (String)wsdlType.getNativeName(), (String)target, (String)targetPort).getId());
        bpmObject.setProperty("from.spring.component", wsdlType.getProperty("from.spring.component"));
        List<CustomizableOperation> operations = this.getOperationsByTypeRef(service);
        for (CustomizableOperation operation : operations) {
            if (operation.isCallback()) continue;
            this.createDelegatedMethod(bpmObject, operation, false);
        }
        TypeRef callbackTypeRef = this.customizableBpmObjectData.getCallback();
        if (callbackTypeRef != null) {
            WsdlTypeDescription callBackService = (WsdlTypeDescription)callbackTypeRef.get();
            bpmObject.setTransientProperty("callback.type.ref", (Object)callbackTypeRef);
            XObjectTypeDescription callbackOtd = BpmObjectFactory.createCallbackXObjectTypeDescription((ComponentCatalog)componentCatalog, (XObjectTypeDescription)bpmObject, (WsdlTypeDescription)callBackService, (String)parentModule);
            List<CustomizableOperation> callbackOperations = this.getOperationsByTypeRef(callbackTypeRef);
            ArrayList<CustomizableOperation> callbakcsOp = new ArrayList<CustomizableOperation>();
            for (CustomizableOperation callbackOperation : callbackOperations) {
                if (!callbackOperation.isCallback()) continue;
                callbakcsOp.add(callbackOperation);
            }
            if (!callbakcsOp.isEmpty()) {
                callbackOtd.setProperty("interface.object", interfaceObjectValue);
            }
            for (CustomizableOperation operation : callbakcsOp) {
                this.createDelegatedMethod(callbackOtd, operation, true);
            }
        }
        return bpmObject;
    }

    private List<CustomizableOperation> getOperationsByTypeRef(@NotNull TypeRef type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceBuilder.getOperationsByTypeRef must not be null");
        }
        ArrayList<CustomizableOperation> result = new ArrayList<CustomizableOperation>();
        for (CustomizableOperation operation : this.operations) {
            MethodTypeDescription method = operation.getDelegatedOperation();
            TypeRef parent = method.getParentRef();
            if (parent == null || !type.get().equals(parent.get())) continue;
            result.add(operation);
        }
        return result;
    }

    private void createDelegatedMethod(@NotNull XObjectTypeDescription otd, @NotNull CustomizableOperation operation, boolean isCallback) {
        if (otd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceBuilder.createDelegatedMethod must not be null");
        }
        if (operation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceBuilder.createDelegatedMethod must not be null");
        }
        MethodTypeDescription method = operation.getDelegatedOperation();
        String displayName = operation.getDisplayName();
        String description = operation.getDescription();
        DelegatedMethodTypeDescription member = new DelegatedMethodTypeDescription(displayName, (WsdlTypeDescription)method.getParent(), method.getSignature());
        member.setDescription(description);
        if (isCallback) {
            member.setProperty("is.callback", Boolean.TRUE.toString());
        }
        for (CustomizableArgument delegatedArgument : operation.getCustomizedArguments()) {
            TypeRef argumentTypeRef = delegatedArgument.getArgumentTypeRef();
            Argument newArgument = new Argument(delegatedArgument.getArgumentName(), argumentTypeRef.getRef(), delegatedArgument.getArgumentModifiers());
            newArgument.setDescription(delegatedArgument.getDescription());
            newArgument.setDefaultValue(delegatedArgument.getDefaultValue());
            newArgument.setProperty("nativeName", delegatedArgument.getNativeName());
            member.addArgument(newArgument);
        }
        otd.addMember((MethodTypeDescription)member);
    }

    private void createModules(@NotNull MutableComponentCatalog componentCatalog) throws TypeCatalogException {
        if (componentCatalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceBuilder.createModules must not be null");
        }
        String bpmObjectModule = this.customizableBpmObjectData.getModule();
        TypeRef moduleRef = componentCatalog.find(bpmObjectModule);
        if (moduleRef == null) {
            throw new IllegalStateException("Module '" + bpmObjectModule + "' does not exist in the project");
        }
        ObjectTypeDescription parentFromModule = moduleRef.get().asObject();
        XObjectTypeDescription xotd = this.createBpmObjects(bpmObjectModule);
        parentFromModule.addInnerType(xotd.getRef());
        componentCatalog.add((ObjectTypeDescription)xotd);
    }
}

