/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.customization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.fusion.soa.customization.CustomizableArgument;
import oracle.bpm.fusion.soa.customization.CustomizableOperationError;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.catalog.CatalogArgument;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizableOperation {
    @NotNull
    private List<CustomizableArgument> arguments;
    @NotNull
    private CatalogMember catalogMember;
    @NotNull
    private MethodTypeDescription delegatedOperation;
    @Nullable
    private String description;
    @NotNull
    private String displayName;
    private Boolean isCallback;

    CustomizableOperation(@NotNull CatalogMember catalogMember, @NotNull MethodTypeDescription delegatedOperation, @NotNull String displayName, @Nullable String description) {
        if (catalogMember == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableOperation.<init> must not be null");
        }
        if (delegatedOperation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableOperation.<init> must not be null");
        }
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableOperation.<init> must not be null");
        }
        this.delegatedOperation = delegatedOperation;
        this.displayName = displayName;
        this.description = description;
        this.arguments = new ArrayList<CustomizableArgument>();
        this.catalogMember = catalogMember;
        for (CatalogArgument catalogArgument : catalogMember.getArguments()) {
            this.arguments.add(CustomizableArgument.createDelegatedArgument(catalogArgument));
        }
    }

    public static CustomizableOperation createOperation(@NotNull CatalogMember catalogMember, @Nullable String displayName, @Nullable String description) {
        if (catalogMember == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableOperation.createOperation must not be null");
        }
        MethodTypeDescription delegatedOperation = catalogMember.getMemberType();
        if (Str.isEmpty(displayName)) {
            displayName = delegatedOperation.getName();
        }
        assert (displayName != null);
        if (delegatedOperation.isDelegated()) {
            DelegatedMethodTypeDescription delegatedMethod = delegatedOperation.asDelegated();
            TypeRef serviceRef = delegatedMethod.getDelegatedServiceRef();
            ObjectTypeDescription service = serviceRef.get().asObject();
            String signature = delegatedMethod.getDelegatedMethodSignature();
            delegatedOperation = service.getMemberBySignature(signature);
        }
        CustomizableOperation customizableOperation = new CustomizableOperation(catalogMember, delegatedOperation, displayName, description);
        CatalogObject parentObject = catalogMember.getParentObject();
        if (parentObject.isService()) {
            customizableOperation.setCallback(parentObject.asInterfaceObject().isCallback());
        }
        return customizableOperation;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getDisplayName() {
        String string = this.displayName;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/customization/CustomizableOperation.getDisplayName must not return null");
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDisplayName(@NotNull String displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableOperation.setDisplayName must not be null");
        }
        if (Str.isEmpty(displayName)) {
            displayName = this.delegatedOperation.getName();
        }
        this.displayName = displayName;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public List<CustomizableArgument> getCustomizedArguments() {
        return this.arguments;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<CustomizableOperationError> getOperationErrors() {
        List<CustomizableOperationError> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/customization/CustomizableOperation.getOperationErrors must not return null");
        }
        return list;
    }

    public boolean isCallback() {
        if (this.isCallback == null) {
            boolean result = false;
            CatalogObject serviceParent = this.catalogMember.getParentObject();
            if (serviceParent.isService()) {
                InterfaceObject serviceObject = serviceParent.asInterfaceObject();
                result = serviceObject.isCallback();
            }
            return result;
        }
        return this.isCallback;
    }

    public void setCallback(boolean value) {
        this.isCallback = value;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public MethodTypeDescription getDelegatedOperation() {
        MethodTypeDescription methodTypeDescription = this.delegatedOperation;
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/customization/CustomizableOperation.getDelegatedOperation must not return null");
        }
        return methodTypeDescription;
    }
}

