/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.action;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.lang.Time;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.io.serializers.simulation.model.ModelSimulationJaxbLoader;
import oracle.bpm.project.model.ModelSimulationsContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.RealDistributionCriteria;
import oracle.bpm.resources.Msg;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ProcessMetadataServiceException;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.processsimulation.DistributionCriteria;
import oracle.bpm.services.processsimulation.IProcessSimulationService;
import oracle.bpm.services.processsimulation.model.ProcessSimulationModel;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.DefaultComponentFactory;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.ui.text.ValueChangedEvent;
import oracle.bpm.ui.text.ValueChangedListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportRoundTripSimulationAction
extends DesignerAction {
    private ImportHelper helper;
    private Properties soaConnectionInfo;
    private ProcessSimulationModel view;

    public ImportRoundTripSimulationAction() {
        this(DesignerMsg.IMPORT_RUNTIME_PROCESS_SIMULATION);
    }

    public ImportRoundTripSimulationAction(Msg msg) {
        super(msg);
        this.requires(FuegoProject.class);
        this.requires(Process.class);
        this.requires(ModelSimulationsContainer.class);
        this.helper = new RealImportHelper();
    }

    public boolean doIt() {
        boolean result = false;
        try {
            if (this.getApplicationServerConnectionInfo()) {
                this.connect();
                boolean createNew = this.chooseModel();
                if (this.view != null) {
                    result = this.addSimulationToProcess(true);
                } else if (createNew && (result = this.generateSimulation())) {
                    if (this.view != null) {
                        this.addSimulationToProcess(true);
                    } else {
                        Msg[] options = new Msg[]{DesignerMsg.SIMULATION_CHECK_BACK, DesignerMsg.SIMULATION_NOTIFY};
                        int option = MessageDialog.showQuestion((Msg)DesignerMsg.IMPORT_RUNTIME_PROCESS_SIMULATION, (Msg)DesignerMsg.SIMULATION_ASK_TO_CHECK, (Msg[])options, (int)0);
                        if (option == 1) {
                            int initialDelay = 5000;
                            int period = 5000;
                            final Timer timer = new Timer();
                            final Project project = this.getProject();
                            TimerTask task = new TimerTask(){

                                @Override
                                public void run() {
                                    try {
                                        ProcessSimulationModel currentView = ImportRoundTripSimulationAction.this.helper.getSimulation();
                                        ImportRoundTripSimulationAction.this.view = currentView;
                                        if (currentView != null) {
                                            int userOption = MessageDialog.showQuestion((Msg)DesignerMsg.IMPORT_RUNTIME_PROCESS_SIMULATION, (Msg)DesignerMsg.SIMULATION_WISH_TO_OPEN((String)currentView.getName()), (int)6);
                                            ImportRoundTripSimulationAction.doAddSimulationToProcess(userOption == 2, project, currentView);
                                            timer.cancel();
                                        }
                                    }
                                    catch (BPMException e) {
                                        e.printStackTrace();
                                    }
                                    catch (ProjectException e) {
                                        e.printStackTrace();
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        e.printStackTrace();
                                    }
                                }
                            };
                            timer.scheduleAtFixedRate(task, initialDelay, (long)period);
                        }
                    }
                }
            }
        }
        catch (ExecutionException ee) {
            MessageDialog.showError((Throwable)ee);
        }
        catch (Exception e) {
            MessageDialog.showError((Throwable)e);
        }
        return result;
    }

    private static boolean doAddSimulationToProcess(boolean open, final Project project, final ProcessSimulationModel view) throws ProjectException, UnsupportedEncodingException {
        Command loadSimulation = new Command(){

            @Override
            public String getName() {
                return "add simulation command";
            }

            @Override
            public Object getAffectedObject() {
                return project.getSimulations();
            }

            @Override
            public void undo() {
            }

            @Override
            public Object execute() throws ExecutionException {
                ModelSimulation modelSimulation;
                String modelXMl = view.getModel();
                StringReader reader = new StringReader(modelXMl);
                ModelSimulationJaxbLoader projectSimulationJaxbLoader = ModelSimulationJaxbLoader.create(reader, (ResourceContainer)project.getSimulations().getModelSimulationsContainer());
                try {
                    modelSimulation = projectSimulationJaxbLoader.load();
                    if (modelSimulation != null && modelSimulation.getProcess() != null) {
                        project.getSimulations().addModelSimulation(modelSimulation.getProcess().getId(), modelSimulation);
                    }
                }
                catch (ProjectException e) {
                    throw new ExecutionException(e);
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
                return modelSimulation;
            }
        };
        final ModelSimulation modelSimulation = (ModelSimulation)loadSimulation.execute();
        if (open) {
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    new OpenObjectAction((Object)modelSimulation).doIt();
                }
            });
        }
        return true;
    }

    private boolean generateSimulation() throws BPMException {
        List<ProcessMetadataSummary> processes = this.helper.getProcessList(this.getProject());
        Panel panel = new Panel(null);
        FormLayout form = new FormLayout("15dlu,pref,5dlu,pref:grow,15dlu", "15dlu,pref,5dlu,pref,5dlu,pref,5dlu,pref,5dlu,pref,5dlu,pref,15dlu:grow");
        panel.setLayout((Layout)form);
        CellConstraints cc = form.createCellConstraints();
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.MODEL_SIMULATION_NAME), (Object)cc.xy(2, 2));
        final TextField modelName = new TextField((UiContainer)panel);
        panel.add((UiComponent)modelName, (Object)cc.xy(4, 2));
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.PROCESS), (Object)cc.xy(2, 4));
        final ComboBox processCombo = UiFactory.createComboBox((UiContainer)panel, processes);
        processCombo.setLabelProvider((LabelProvider)new LabelProvider<ProcessMetadataSummary>(){

            public Image getIcon(ProcessMetadataSummary element) {
                return null;
            }

            public String getText(ProcessMetadataSummary element) {
                return element.getProcessName() + " v" + element.getRevision();
            }
        });
        panel.add((UiComponent)processCombo, (Object)cc.xy(4, 4));
        Process processSelection = (Process)this.getSelection().as(Process.class);
        if (processSelection != null) {
            for (ProcessMetadataSummary process : processes) {
                if (!process.getProcessName().equals(processSelection.getName())) continue;
                processCombo.setSelectedItem((Object)process);
            }
        }
        TimeField fromField = new TimeField((UiContainer)panel, TimeField.Style.DATE);
        fromField.setTime(fromField.getTime().addMonths(-1));
        final TimeField toField = new TimeField((UiContainer)panel, TimeField.Style.DATE);
        toField.addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueChangedEvent valuechangedevent) {
                if (toField.getTime().getDateValue().getTime() > new Date().getTime()) {
                    toField.setTime(new Time());
                }
            }
        });
        UiComponent separator = DefaultComponentFactory.getInstance().createSeparator((UiContainer)panel, DesignerMsg.RANGES.toString(), 2);
        panel.add(separator, (Object)cc.xyw(2, 8, 3));
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.FROM), (Object)cc.xy(2, 10));
        panel.add((UiComponent)fromField, (Object)cc.xy(4, 10));
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.TO), (Object)cc.xy(2, 12));
        panel.add((UiComponent)toField, (Object)cc.xy(4, 12));
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.DISTRIBUTION_CRITERIA), (Object)cc.xy(2, 6));
        ComboBox criteriaCombo = UiFactory.createComboBox((UiContainer)panel, (Object[])RealDistributionCriteria.values());
        criteriaCombo.setSelectedIndex(0);
        panel.add((UiComponent)criteriaCombo, (Object)cc.xy(4, 6));
        OkCancelDialog dialog = new OkCancelDialog(Ui.getRoot(), DesignerMsg.CREATE_NEW_MODEL_FROM_RUNTIME_DATA, true){

            public void ok() {
                if (modelName.getText().trim().isEmpty()) {
                    MessageDialog.showError((Msg)DesignerMsg.MODEL_NAME_CANNOT_BE_EMPTY);
                } else if (processCombo.getSelectedIndex() == -1) {
                    MessageDialog.showError((Msg)DesignerMsg.PROCESS_NOT_SELECTED);
                } else if (ImportRoundTripSimulationAction.this.getProject().findDescendant(Process.class, ((ProcessMetadataSummary)processCombo.getSelectedItem()).getProcessId()) != null && ImportRoundTripSimulationAction.this.getProject().getSimulations().findModelSimulation((Process)ImportRoundTripSimulationAction.this.getProject().findDescendant(Process.class, ((ProcessMetadataSummary)processCombo.getSelectedItem()).getProcessId()), modelName.getText()) != null) {
                    MessageDialog.showError((UiContainer)Ui.getRoot(), (Msg)DesignerMsg.MODEL_SIMULATION_EXISTS);
                } else {
                    this.close();
                }
            }
        };
        boolean accepted = OkCancelDialog.doShowDialog((OkCancelDialog)dialog, (UiComponent)panel);
        if (accepted) {
            Calendar javaCalendarFrom = Calendar.getInstance();
            javaCalendarFrom.setTime(fromField.getTime().dateValue());
            javaCalendarFrom.set(14, 0);
            javaCalendarFrom.set(13, 0);
            javaCalendarFrom.set(12, 0);
            javaCalendarFrom.set(11, 0);
            Calendar javaCalendarTo = Calendar.getInstance();
            javaCalendarTo.setTime(toField.getTime().dateValue());
            javaCalendarTo.set(14, 999);
            javaCalendarTo.set(13, 59);
            javaCalendarTo.set(12, 59);
            javaCalendarTo.set(11, 23);
            this.helper.generateSimulation(modelName.getText(), (ProcessMetadataSummary)processCombo.getSelectedItem(), javaCalendarFrom, javaCalendarTo, (RealDistributionCriteria)criteriaCombo.getSelectedItem());
            this.view = this.helper.getSimulation();
        }
        return accepted;
    }

    private boolean chooseModel() throws BPMException {
        final List<ProcessSimulationModel> simulations = this.helper.getGeneratedSimulations();
        Panel panel = new Panel(null);
        FormLayout form = new FormLayout("15dlu,pref,5dlu,pref:grow,15dlu", "15dlu,pref,5dlu,pref,5dlu,pref,15dlu:grow");
        panel.setLayout((Layout)form);
        CellConstraints cc = form.createCellConstraints();
        Collection processes = this.getProject().getProcesses();
        final DescriptionPanel description = new DescriptionPanel((UiContainer)panel);
        final ComboBox simulationModelComboBox = UiFactory.createComboBox((UiContainer)panel, new ArrayList<ProcessSimulationModel>(simulations));
        simulationModelComboBox.setSelectedIndex(-1);
        simulationModelComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                description.setData((ProcessSimulationModel)simulationModelComboBox.getSelectedItem());
            }
        });
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.CHOOSE_PROCESS), (Object)cc.xy(2, 2));
        final ComboBox processList = UiFactory.createComboBox((UiContainer)panel, (Collection)processes);
        processList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ImportRoundTripSimulationAction.this.updateCombo((ComboBox<ProcessSimulationModel>)simulationModelComboBox, (ComboBox<Process>)processList, simulations);
            }
        });
        Process processSelection = (Process)this.getSelection().as(Process.class);
        if (processSelection != null) {
            processList.setSelectedItem((Object)processSelection);
            this.updateCombo((ComboBox<ProcessSimulationModel>)simulationModelComboBox, (ComboBox<Process>)processList, simulations);
        } else {
            processList.setSelectedIndex(-1);
            this.updateCombo((ComboBox<ProcessSimulationModel>)simulationModelComboBox, (ComboBox<Process>)processList, simulations);
        }
        panel.add((UiComponent)processList, (Object)cc.xy(4, 2));
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.CHOOSE_PROCESS_METADATA), (Object)cc.xy(2, 4));
        simulationModelComboBox.setLabelProvider((LabelProvider)new LabelProvider<ProcessSimulationModel>(){

            public Image getIcon(ProcessSimulationModel element) {
                return null;
            }

            public String getText(ProcessSimulationModel element) {
                ComponentDNModel componentDNModel = ComponentDNModel.parseComponentDN((String)element.getProcess());
                return element.getName() + " - " + componentDNModel.getComponentName();
            }
        });
        panel.add((UiComponent)simulationModelComboBox, (Object)cc.xy(4, 4));
        panel.add((UiComponent)description, (Object)cc.xyw(2, 6, 3));
        class MyOkCancelDialog
        extends OkCancelDialog {
            private boolean doContinue;

            public MyOkCancelDialog() {
                super(Ui.getRoot(), DesignerMsg.IMPORT_RUNTIME_PROCESS_SIMULATION, true);
                this.doContinue = false;
            }

            public void ok() {
                this.close();
            }

            protected UiComponent internalBuildButtons(UiContainer parent) {
                UiComponent component = super.internalBuildButtons(parent);
                Button button = new Button(this.getAditionalButtonsAddPoint(), DesignerMsg.GENERATE_NEW_ROUNDTRIP);
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        doContinue = true;
                        this.close();
                    }
                });
                this.okButton.setMsg(DesignerMsg.LOAD);
                this.addAditionalButton(new Button[]{button});
                return component;
            }
        }
        MyOkCancelDialog dialog = new MyOkCancelDialog();
        boolean accepted = OkCancelDialog.doShowDialog((OkCancelDialog)dialog, (UiComponent)panel);
        if (accepted) {
            if (simulationModelComboBox.getSelectedItem() == null) {
                MessageDialog.showError((Msg)DesignerMsg.MUST_SELECT_MODEL);
                return this.chooseModel();
            }
            this.view = (ProcessSimulationModel)simulationModelComboBox.getSelectedItem();
            return false;
        }
        return dialog.doContinue;
    }

    private void updateCombo(ComboBox<ProcessSimulationModel> simulationModelComboBox, ComboBox<Process> processList, List<ProcessSimulationModel> simulations) {
        simulationModelComboBox.removeAllItems();
        final Process selectedProcess = (Process)processList.getSelectedItem();
        Sequence<ProcessSimulationModel> items = CollectionUtils.select(simulations, new Predicate<ProcessSimulationModel>(){

            @Override
            public boolean check(@Nullable ProcessSimulationModel value) {
                return selectedProcess == null || selectedProcess.getId().equals(ComponentDNModel.parseComponentDN((String)value.getProcess()).getComponentName());
            }
        });
        simulationModelComboBox.addItems(items);
        if (simulationModelComboBox.getItemCount() > 0) {
            simulationModelComboBox.setSelectedIndex(0);
        } else {
            simulationModelComboBox.setSelectedIndex(-1);
        }
    }

    private void connect() throws BPMException {
        this.helper.connect(this.soaConnectionInfo);
    }

    private boolean getApplicationServerConnectionInfo() {
        this.soaConnectionInfo = this.helper.promptRoundTripConnection();
        return this.soaConnectionInfo != null;
    }

    private Project getProject() {
        ProjectObject projectObject = (ProjectObject)this.getSelection().as(ProjectObject.class);
        return projectObject.getProject();
    }

    private boolean addSimulationToProcess(boolean open) throws ProjectException, UnsupportedEncodingException {
        return ImportRoundTripSimulationAction.doAddSimulationToProcess(open, this.getProject(), this.view);
    }

    private static class RealImportHelper
    implements ImportHelper {
        private IBPMContext bpmContext;
        private BPMServiceClientFactory bpmServiceClientFactory;
        private String modelName;
        private String processDn;

        private RealImportHelper() {
        }

        @Override
        public Properties promptRoundTripConnection() {
            return AbstractStudioWorkbench.getInstance().promptRoundTripConnection();
        }

        @Override
        public void connect(Properties soaConnectionInfo) throws BPMException {
            this.connect(soaConnectionInfo.getProperty("host"), soaConnectionInfo.getProperty("port"), soaConnectionInfo.getProperty("user"), soaConnectionInfo.getProperty("password").toCharArray(), Boolean.parseBoolean(soaConnectionInfo.getProperty("useSSL")));
        }

        @Override
        public void connect(String host, String port, String user, char[] password, Boolean useSSL) throws BPMException {
            String protocol = useSSL != false ? "t3s" : "t3";
            String ejbHost = protocol + "://" + host + ":" + port;
            HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, ejbHost);
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory");
            this.bpmServiceClientFactory = BPMServiceClientFactory.getInstance(properties, null, null);
            this.bpmContext = this.bpmServiceClientFactory.getBPMUserAuthenticationService().authenticate(user, password, null);
        }

        @Override
        public List<ProcessMetadataSummary> getProcessList(Project project) throws ProcessMetadataServiceException {
            IBPMServiceClient bpmServiceClient = this.bpmServiceClientFactory.getBPMServiceClient();
            IProcessMetadataService processMetadataService = bpmServiceClient.getProcessMetadataService();
            List processes = processMetadataService.listProcessMetadataSummary(this.bpmContext, project.getId(), null, null);
            return processes;
        }

        @Override
        public void generateSimulation(String modelName, ProcessMetadataSummary processMetadataSummary, Calendar javaCalendarFrom, Calendar javaCalendarTo, RealDistributionCriteria criteria) throws BPMException {
            DistributionCriteria serviceCriteria;
            IBPMServiceClient bpmServiceClient = this.bpmServiceClientFactory.getBPMServiceClient();
            IProcessSimulationService processSimulationService = bpmServiceClient.getProcessSimulationService();
            ComponentDNModel componentDN = ComponentDNModel.buildComponentDN((String)processMetadataSummary.getDomainName(), (String)processMetadataSummary.getCompositeName(), (String)processMetadataSummary.getRevision(), (String)processMetadataSummary.getLabel(), (String)processMetadataSummary.getProcessName());
            switch (criteria) {
                case HOURLY: {
                    serviceCriteria = DistributionCriteria.HOURLY;
                    break;
                }
                case DAILY: {
                    serviceCriteria = DistributionCriteria.DAILY;
                    break;
                }
                case WEEKLY: {
                    serviceCriteria = DistributionCriteria.WEEKLY;
                    break;
                }
                case MONTHLY: {
                    serviceCriteria = DistributionCriteria.MONTHLY;
                    break;
                }
                default: {
                    serviceCriteria = DistributionCriteria.HOURLY;
                }
            }
            this.modelName = modelName;
            this.processDn = componentDN.getDNString();
            processSimulationService.generateProcessSimulationModel(this.bpmContext, modelName, this.processDn, javaCalendarFrom, javaCalendarTo, serviceCriteria);
        }

        @Override
        public ProcessSimulationModel getSimulation() throws BPMException {
            IBPMServiceClient bpmServiceClient = this.bpmServiceClientFactory.getBPMServiceClient();
            IProcessSimulationService processSimulationService = bpmServiceClient.getProcessSimulationService();
            List<ProcessSimulationModel> simulations = this.getGeneratedSimulations();
            for (ProcessSimulationModel processSimulationModelView : simulations) {
                if (!this.modelName.equals(processSimulationModelView.getName()) || !this.processDn.equals(processSimulationModelView.getProcess())) continue;
                return processSimulationModelView;
            }
            return null;
        }

        @Override
        public List<ProcessSimulationModel> getGeneratedSimulations() throws BPMException {
            IBPMServiceClient bpmServiceClient = this.bpmServiceClientFactory.getBPMServiceClient();
            IProcessSimulationService processSimulationService = bpmServiceClient.getProcessSimulationService();
            List generated = processSimulationService.listUserProcessSimulationModel(this.bpmContext, null);
            return generated;
        }
    }

    private static class MockImportHelper
    implements ImportHelper {
        int count = 0;

        private MockImportHelper() {
        }

        @Override
        public void connect(String host, String port, String user, char[] password, Boolean useSSL) {
        }

        @Override
        public List<ProcessMetadataSummary> getProcessList(Project project) {
            ArrayList<ProcessMetadataSummary> list = new ArrayList<ProcessMetadataSummary>();
            list.add(this.newProcessMetadataSummary("Process1", "TimerEvent"));
            list.add(this.newProcessMetadataSummary("Echo", "TimerEvent"));
            return list;
        }

        @Override
        public void generateSimulation(String modelName, ProcessMetadataSummary processMetadataSummary, Calendar javaCalendarFrom, Calendar javaCalendarTo, RealDistributionCriteria criteria) {
        }

        @Override
        public void connect(Properties soaConnectionInfo) {
        }

        @Override
        public Properties promptRoundTripConnection() {
            return new Properties();
        }

        @Override
        public ProcessSimulationModel getSimulation() throws BPMException {
            if (this.count == 3) {
                return new MockProcessSimulationModel();
            }
            ++this.count;
            return null;
        }

        @Override
        public List<ProcessSimulationModel> getGeneratedSimulations() throws BPMException {
            ArrayList<ProcessSimulationModel> list = new ArrayList<ProcessSimulationModel>();
            list.add(new MockProcessSimulationModel());
            return list;
        }

        private ProcessMetadataSummary newProcessMetadataSummary(String processName, String projectName) {
            ProcessMetadataSummary summary = new ProcessMetadataSummary();
            summary.setProcessName(processName);
            summary.setProjectName(projectName);
            summary.setRevision("v1");
            summary.setLabel("l1");
            summary.setProcessId(processName);
            return summary;
        }

        private class MockProcessSimulationModel
        implements ProcessSimulationModel {
            private MockProcessSimulationModel() {
            }

            public String getId() {
                return "default/TimerEvent!1.0*soa_c4820d55-6a9c-4315-88a9-eade7ab29fb7/Echo";
            }

            public String getName() {
                return "Model1";
            }

            public String getProcess() {
                return "default/TimerEvent!1.0*soa_c4820d55-6a9c-4315-88a9-eade7ab29fb7/Echo";
            }

            public Calendar getFrom() {
                Calendar calendar = Calendar.getInstance();
                calendar.set(2, calendar.get(2) - 3);
                return calendar;
            }

            public Calendar getTo() {
                Calendar calendar = Calendar.getInstance();
                calendar.set(2, calendar.get(2) - 2);
                return calendar;
            }

            public DistributionCriteria getDistributionCriteria() {
                return DistributionCriteria.DAILY;
            }

            public String getCreatedBy() {
                return null;
            }

            public Calendar getCreatedDate() {
                return Calendar.getInstance();
            }

            public String getUpdatedBy() {
                return null;
            }

            public Calendar getUpdatedDate() {
                return Calendar.getInstance();
            }

            public String getModel() {
                try {
                    String file = "/home/sandrau/Model.xml";
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    String line = null;
                    StringBuilder stringBuilder = new StringBuilder();
                    String ls = System.getProperty("line.separator");
                    while ((line = reader.readLine()) != null) {
                        stringBuilder.append(line);
                        stringBuilder.append(ls);
                    }
                    return stringBuilder.toString();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public void setModel(@NotNull String model) {
                if (model == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/action/ImportRoundTripSimulationAction$MockImportHelper$MockProcessSimulationModel.setModel must not be null");
                }
            }

            public List<PrincipleRefType> getGrantees() {
                return null;
            }

            public void addGrantee(@NotNull PrincipleRefType principleRef) {
                if (principleRef == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/action/ImportRoundTripSimulationAction$MockImportHelper$MockProcessSimulationModel.addGrantee must not be null");
                }
            }

            public void removeGrantee(@NotNull PrincipleRefType principleRef) {
                if (principleRef == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/action/ImportRoundTripSimulationAction$MockImportHelper$MockProcessSimulationModel.removeGrantee must not be null");
                }
            }

            public void clearGrantees() {
            }
        }
    }

    private static class DescriptionPanel
    extends Panel {
        Label creationLabel;
        Label criteriaLabel;
        DateFormat dateFormat = TimeField.getDateFormat((TimeField.Style)TimeField.Style.DATE, (TimeField.Format)TimeField.Format.DEFAULT, (Locale)Locale.getDefault());
        Label fromLabel;
        Label toLabel;
        private Color defaultForeground;

        public DescriptionPanel(UiContainer parent) {
            super(parent, DesignerMsg.DETAILS);
            this.build();
        }

        public void setData(ProcessSimulationModel selectedItem) {
            this.set(this.creationLabel, selectedItem.getCreatedDate());
            this.set(this.fromLabel, selectedItem.getFrom());
            this.set(this.toLabel, selectedItem.getTo());
            this.setCriteria(selectedItem.getDistributionCriteria());
        }

        private static Label create(Panel parent, Msg msg) {
            Label result = Label.create((UiContainer)parent, (Msg)msg);
            DescriptionPanel.fixFont(result);
            return result;
        }

        private static Label create(Panel parent) {
            Label result = Label.createWithNoColon((UiContainer)parent, (Msg)Msg.QUOTE(""));
            DescriptionPanel.fixFont(result);
            return result;
        }

        private static void fixFont(Label result) {
            result.setFont(result.getFont().smaller(2));
        }

        private void build() {
            FormLayout form = new FormLayout("0dlu, pref,3dlu, pref,3dlu, pref,3dlu, pref, 0dlu", "0dlu,pref,3dlu,pref,3dlu,pref,0dlu");
            this.setLayout((Layout)form);
            this.creationLabel = this.createDate(this);
            this.fromLabel = this.createDate(this);
            this.toLabel = this.createDate(this);
            this.criteriaLabel = DescriptionPanel.create(this);
            CellConstraints cc = form.createCellConstraints();
            this.add((UiComponent)DescriptionPanel.create(this, DesignerMsg.CREATION_DATE), cc.xy(2, 2));
            this.add((UiComponent)this.creationLabel, cc.xy(4, 2));
            this.add((UiComponent)DescriptionPanel.create(this, DesignerMsg.FROM), cc.xy(2, 4));
            this.add((UiComponent)this.fromLabel, cc.xy(4, 4));
            this.add((UiComponent)DescriptionPanel.create(this, DesignerMsg.TO), cc.xy(6, 4));
            this.add((UiComponent)this.toLabel, cc.xy(8, 4));
            this.add((UiComponent)DescriptionPanel.create(this, DesignerMsg.DISTRIBUTION_CRITERIA), cc.xy(2, 6));
            this.add((UiComponent)this.criteriaLabel, cc.xy(4, 6));
        }

        private Label createDate(Panel parent) {
            Label result = Label.createWithNoColon((UiContainer)parent, (Msg)Msg.QUOTE(""));
            this.defaultForeground = result.getForeground();
            this.set(result, Calendar.getInstance());
            result.setForeground(result.getBackground());
            DescriptionPanel.fixFont(result);
            return result;
        }

        private void setCriteria(DistributionCriteria criteria) {
            RealDistributionCriteria realDistributionCriteria;
            switch (criteria) {
                case HOURLY: {
                    realDistributionCriteria = RealDistributionCriteria.HOURLY;
                    break;
                }
                case DAILY: {
                    realDistributionCriteria = RealDistributionCriteria.DAILY;
                    break;
                }
                case WEEKLY: {
                    realDistributionCriteria = RealDistributionCriteria.WEEKLY;
                    break;
                }
                case MONTHLY: {
                    realDistributionCriteria = RealDistributionCriteria.MONTHLY;
                    break;
                }
                default: {
                    realDistributionCriteria = RealDistributionCriteria.HOURLY;
                }
            }
            this.criteriaLabel.setText(realDistributionCriteria.getMsg());
        }

        private void set(Label label, Calendar calendar) {
            String string = Time.valueOf(calendar.getTime()).format(this.dateFormat);
            label.setText(string);
            label.setForeground(this.defaultForeground);
        }
    }

    private static interface ImportHelper {
        public ProcessSimulationModel getSimulation() throws BPMException;

        public List<ProcessSimulationModel> getGeneratedSimulations() throws BPMException;

        public void connect(String var1, String var2, String var3, char[] var4, Boolean var5) throws BPMException;

        public List<ProcessMetadataSummary> getProcessList(Project var1) throws ProcessMetadataServiceException;

        public void generateSimulation(String var1, ProcessMetadataSummary var2, Calendar var3, Calendar var4, RealDistributionCriteria var5) throws BPMException;

        public void connect(Properties var1) throws BPMException;

        public Properties promptRoundTripConnection();
    }
}

