/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.conversational;

import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.UseInterfaceConversationDefinition;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.UseInterfaceConversationalDefinition;
import oracle.bpm.project.process.conversational.ConversationalDefinitionImpl;
import org.jetbrains.annotations.NotNull;

public class UseInterfaceConversationalDefinitionImpl
extends ConversationalDefinitionImpl
implements UseInterfaceConversationalDefinition {
    private String errorId;
    private String operationId;

    public UseInterfaceConversationalDefinitionImpl(@NotNull Conversational conversational) {
        super(conversational);
    }

    @Override
    public ReferenceObject getReference() {
        ReferenceObject result = null;
        UseInterfaceConversationDefinition conversationDefinition = this.getUseInterfaceConversationDefinition();
        if (conversationDefinition != null) {
            Conversational conversational = this.getParentObject();
            ReferenceObject reference = conversationDefinition.getReference();
            if (reference != null) {
                if (conversational.getConversationalType().isReceiver() || conversational.getConversationalType().isSender() && reference.isSync()) {
                    result = reference;
                } else {
                    InterfaceObject callbackInterface = ConversationalHelper.getCallbackInterface((InterfaceObject)reference);
                    if (callbackInterface instanceof ReferenceObject) {
                        result = (ReferenceObject)callbackInterface;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public CatalogMember getOperation() {
        ReferenceObject service;
        CatalogMember result = null;
        if (!Str.isEmpty((String)this.operationId) && (service = this.getReference()) != null) {
            result = service.findMember(this.operationId);
        }
        return result;
    }

    @Override
    public void setOperation(CatalogMember operation) {
        String operationId = operation != null ? operation.getName() : null;
        this.setOperationId(operationId);
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        if (Any.equals((Object)this.operationId, (Object)operationId)) {
            return;
        }
        this.operationId = operationId;
        this.errorId = null;
        this.events().objectChanged();
    }

    @Override
    public ErrorObject getError() {
        CatalogMember operation;
        ErrorObject result = null;
        if (!Str.isEmpty((String)this.errorId) && (operation = this.getOperation()) != null) {
            Sequence<ErrorObject> exceptions = operation.getExceptions();
            for (ErrorObject exception : exceptions) {
                if (!this.errorId.equals(exception.getId())) continue;
                result = exception;
            }
        }
        return result;
    }

    @Override
    public void setError(ErrorObject error) {
        String errorId = error != null ? error.getId() : null;
        this.setErrorId(errorId);
    }

    public void setErrorId(String errorId) {
        if (Any.equals((Object)this.errorId, (Object)errorId)) {
            return;
        }
        this.errorId = errorId;
        this.events().objectChanged();
    }

    public String getErrorId() {
        return this.errorId;
    }

    private UseInterfaceConversationDefinition getUseInterfaceConversationDefinition() {
        UseInterfaceConversationDefinition result = null;
        Conversation conversation = this.getParentObject().getConversation();
        if (conversation != null) {
            result = conversation.getConversationDefinition().as(UseInterfaceConversationDefinition.class);
        }
        return result;
    }
}

