/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.conversational;

import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ProcessCallConversationDefinition;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ProcessCallConversationalDefinition;
import oracle.bpm.project.process.conversational.ConversationalDefinitionImpl;
import org.jetbrains.annotations.NotNull;

public class ProcessCallConversationalDefinitionImpl
extends ConversationalDefinitionImpl
implements ProcessCallConversationalDefinition {
    private String targetConversationalId;

    public ProcessCallConversationalDefinitionImpl(@NotNull Conversational conversational) {
        super(conversational);
    }

    @Override
    public Conversational getTargetConversational() {
        Process process;
        ProcessCallConversationDefinition definition;
        Conversational result = null;
        if (!Str.isEmpty((String)this.targetConversationalId) && (definition = this.getProcessCallConversationDefinition()) != null && (process = this.getProcess()) != null) {
            result = process.findDescendant(Conversational.class, this.targetConversationalId);
        }
        return result;
    }

    @Override
    public void setTargetConversational(Conversational targetConversational) {
        String targetConversationalId = targetConversational != null ? targetConversational.getId() : null;
        this.setTargetConversationalId(targetConversationalId);
    }

    public String getTargetConversationalId() {
        return this.targetConversationalId;
    }

    public void setTargetConversationalId(String targetConversationalId) {
        if (Any.equals((Object)this.targetConversationalId, (Object)targetConversationalId)) {
            return;
        }
        this.targetConversationalId = targetConversationalId;
        this.events().objectChanged();
    }

    @Override
    public Process getProcess() {
        ProcessCallConversationDefinition conversationDefinition = this.getProcessCallConversationDefinition();
        return conversationDefinition != null ? conversationDefinition.getProcess() : null;
    }

    private ProcessCallConversationDefinition getProcessCallConversationDefinition() {
        ProcessCallConversationDefinition result = null;
        Conversation conversation = this.getParentObject().getConversation();
        if (conversation != null) {
            result = conversation.getConversationDefinition().as(ProcessCallConversationDefinition.class);
        }
        return result;
    }
}

