/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.conversational;

import java.util.ArrayList;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.ImmutableDataDeclarationContainer;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.InputArgumentsEnabled;
import oracle.bpm.project.model.processes.OutputArgumentsEnabled;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.ProcessCallConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.ServiceCallConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.UseInterfaceConversationalDefinition;
import org.jetbrains.annotations.NotNull;

public class ConversationalHelper {
    public static DataDeclarationContainer getArgumentsContainer(@NotNull Conversational conversational, boolean isInputContainer) {
        DataDeclarationContainer result = null;
        Conversation conversation = conversational.getConversation();
        if (conversation != null) {
            ProcessCallConversationalDefinition processCallConversationalDefinition;
            Conversational targetConversational;
            ConversationType type = conversation.getConversationType();
            ConversationalDefinition conversationalDefinition = conversational.getConversationalDefinition();
            if (type == ConversationType.DEFINE_INTERFACE) {
                DefineInterfaceConversationalDefinition defineInterfaceConversationalDefinition = conversationalDefinition.as(DefineInterfaceConversationalDefinition.class);
                ErrorObject error = defineInterfaceConversationalDefinition.getError();
                if (error != null) {
                    AccessType accessType = isInputContainer ? AccessType.IN : AccessType.OUT;
                    result = ConversationalHelper.createErrorArgumentsContainer(error, accessType);
                } else {
                    result = defineInterfaceConversationalDefinition.getArgumentsContainer();
                }
            } else if (type == ConversationType.USE_INTERFACE) {
                UseInterfaceConversationalDefinition useInterfaceConversationalDefinition = conversationalDefinition.as(UseInterfaceConversationalDefinition.class);
                CatalogMember operation = useInterfaceConversationalDefinition.getOperation();
                if (operation != null) {
                    boolean mustInvert;
                    ReferenceObject reference = useInterfaceConversationalDefinition.getReference();
                    boolean bl = mustInvert = !reference.isCallback();
                    result = isInputContainer ? (mustInvert ? operation.getOutputArgumentsContainer() : operation.getInputArgumentsContainer()) : (mustInvert ? operation.getInputArgumentsContainer() : operation.getOutputArgumentsContainer());
                }
            } else if (type == ConversationType.SERVICE_CALL) {
                ServiceCallConversationalDefinition serviceCallConversationalDefinition = conversationalDefinition.as(ServiceCallConversationalDefinition.class);
                CatalogMember operation = serviceCallConversationalDefinition.getOperation();
                if (operation != null) {
                    ServiceObject service = serviceCallConversationalDefinition.getService();
                    boolean mustInvert = service.isCallback();
                    result = isInputContainer ? (mustInvert ? operation.getOutputArgumentsContainer() : operation.getInputArgumentsContainer()) : (mustInvert ? operation.getInputArgumentsContainer() : operation.getOutputArgumentsContainer());
                }
            } else if (type == ConversationType.PROCESS_CALL && (targetConversational = (processCallConversationalDefinition = conversationalDefinition.as(ProcessCallConversationalDefinition.class)).getTargetConversational()) != null) {
                if (isInputContainer) {
                    if (targetConversational.isOutputArgumentsEnabled()) {
                        OutputArgumentsEnabled targetOutputEnabled = (OutputArgumentsEnabled)((Object)targetConversational);
                        result = targetOutputEnabled.getOutputArgumentsContainer();
                    }
                } else if (targetConversational.isInputArgumentsEnabled()) {
                    InputArgumentsEnabled targetInputEnabled = (InputArgumentsEnabled)((Object)targetConversational);
                    result = targetInputEnabled.getInputArgumentsContainer();
                } else {
                    Conversation targetConversationalConversation = targetConversational.getConversation();
                    if (targetConversationalConversation != null) {
                        UseInterfaceConversationalDefinition definition;
                        CatalogMember targetConversationalOperation;
                        ConversationType targetType = targetConversationalConversation.getConversationType();
                        if (targetType == ConversationType.DEFINE_INTERFACE) {
                            Conversational replier;
                            Sequence repliers = oracle.bpm.project.compile.process.ConversationalHelper.getAllRepliers((Conversational)targetConversational, (boolean)true);
                            if (!repliers.isEmpty() && (replier = (Conversational)repliers.iterator().next()).isInputArgumentsEnabled()) {
                                InputArgumentsEnabled replierInputEnabled = (InputArgumentsEnabled)((Object)replier);
                                result = replierInputEnabled.getInputArgumentsContainer();
                            }
                        } else if (targetType == ConversationType.USE_INTERFACE && (targetConversationalOperation = (definition = targetConversational.getConversationalDefinition().as(UseInterfaceConversationalDefinition.class)).getOperation()) != null) {
                            result = targetConversationalOperation.getOutputArgumentsContainer();
                        }
                    }
                }
            }
        }
        return result;
    }

    private static DataDeclarationContainer createErrorArgumentsContainer(final @NotNull ErrorObject error, final @NotNull AccessType accessType) {
        return new ImmutableDataDeclarationContainer(error.getProject()){

            @Override
            public Sequence<DataDeclaration> getLocalDeclarations() {
                ArrayList<DataDeclaration> declarations = new ArrayList<DataDeclaration>();
                Map<String, CatalogType> attributes = error.getErrorInfoAttributes();
                for (Map.Entry<String, CatalogType> entry : attributes.entrySet()) {
                    try {
                        DataDeclaration dataDeclaration = this.createDeclaration(entry.getKey(), entry.getValue(), accessType);
                        declarations.add(dataDeclaration);
                    }
                    catch (ProjectException e) {
                        e.printStackTrace();
                    }
                }
                return CollectionUtils.asSequence(declarations);
            }
        };
    }
}

