/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.conversation;

import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationDefinition;
import oracle.bpm.project.model.processes.conversation.ProcessCallConversationDefinition;
import oracle.bpm.project.process.conversation.ConversationDefinitionImpl;
import org.jetbrains.annotations.NotNull;

public class ProcessCallConversationDefinitionImpl
extends ConversationDefinitionImpl
implements ProcessCallConversationDefinition {
    private String processId;

    public ProcessCallConversationDefinitionImpl(@NotNull Conversation conversation) {
        super(conversation);
    }

    @Override
    public Process getProcess() {
        Project project;
        Process result = null;
        if (!Str.isEmpty((String)this.processId) && (project = this.getProject()) != null) {
            result = project.findProcess(this.processId);
        }
        return result;
    }

    @Override
    public void setProcess(Process process) {
        String processId = process != null ? process.getId() : null;
        this.setProcessId(processId);
    }

    public void setProcessId(String processId) {
        if (Any.equals((Object)this.processId, (Object)processId)) {
            return;
        }
        this.processId = processId;
        this.events().objectChanged();
    }

    public String getProcessId() {
        return this.processId;
    }

    @Override
    public ConversationDefinition copy() {
        ProcessCallConversationDefinitionImpl result = new ProcessCallConversationDefinitionImpl(this.getParentObject());
        result.setProcess(this.getProcess());
        return result;
    }

    @Override
    public void applyFrom(@NotNull ConversationDefinition source) {
        if (source instanceof ProcessCallConversationDefinition) {
            ProcessCallConversationDefinition sourceDefinition = source.as(ProcessCallConversationDefinition.class);
            this.setProcess(sourceDefinition.getProcess());
        }
    }
}

