/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process;

import oracle.bpm.lang.Any;
import oracle.bpm.project.EventDefinitionImpl;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.features.ErrorEventDefinitionFeature;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;

public class ErrorEventDefinitionImpl
extends EventDefinitionImpl
implements ErrorEventDefinition {
    private ErrorEventDefinitionFeature error;

    public ErrorEventDefinitionImpl(Event event) {
        super(event);
    }

    @Override
    public String getErrorCode() {
        return this.getErrorFeature().getErrorCode();
    }

    @Override
    public void setError(ErrorObject errorObject) {
        if (Any.equals((Object)this.getError(), (Object)errorObject)) {
            return;
        }
        this.getErrorFeature().setError(errorObject);
        this.clearDataAssociations();
    }

    @Override
    public void setErrorCode(String errorCode) {
        this.getErrorFeature().setValue(errorCode);
    }

    @Override
    public boolean isCatchAll() {
        return this.getErrorFeature().isCatchAll();
    }

    @Override
    public boolean isCatchAllSystemExceptions() {
        return this.getErrorFeature().isCatchAllSystemExceptions();
    }

    @Override
    public void setCatchAll(boolean isCatchAll) {
        this.getErrorFeature().setIsCatchAll(isCatchAll);
    }

    @Override
    public void setCatchAllSystemExceptions(boolean isCatchAll) {
        this.getErrorFeature().setIsCatchAllSystemExceptions(isCatchAll);
    }

    @Override
    public ErrorObject getError() {
        return this.getErrorFeature().getError();
    }

    public ErrorEventDefinitionFeature getErrorFeature() {
        if (this.error == null) {
            this.error = this.getEvent().getFeature(ErrorEventDefinitionFeature.class);
        }
        return this.error;
    }

    private void clearDataAssociations() {
        Event event = this.getEvent();
        if (event.isDataAssociationsEnabled()) {
            DataAssociationEnabled dataAssociationEnabled = event.asAnyNode(DataAssociationEnabled.class);
            dataAssociationEnabled.clearDataAssociations();
        }
    }
}

