/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler.checker;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;

public class ParticipantChecker
implements ProjectObjectChecker<Participant> {
    private Collection<ProjectObjectChecker> participantCheckers = new ArrayList<ProjectObjectChecker>();

    public ParticipantChecker(Organization organization) {
        this.participantCheckers.add(OrganizationCheckerFactory.getParticipantOrganizationalUnitChecker(organization));
        this.participantCheckers.add(OrganizationCheckerFactory.getRolesAssignedChecker(organization));
        this.participantCheckers.add(OrganizationCheckerFactory.getGroupsAssignedChecker(organization));
    }

    @Override
    public MsgList check(Participant participant) {
        MsgList messages = MsgList.create();
        for (ProjectObjectChecker projectObjectChecker : this.participantCheckers) {
            messages.addAll((Collection)projectObjectChecker.check(participant));
        }
        return messages;
    }
}

