/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;
import oracle.bpm.resources.Msg;

@CompilerExtensionMetadata
public class RoleCompiler
extends AbstractCompilerExtension<Role> {
    public RoleCompiler() {
        super(Role.class, Arrays.asList(ProjectObjectType.ORGANIZATION_ROLE));
    }

    @Override
    public void compile(Role role, CompilationSession session) throws ProjectException {
        ProjectObjectChecker<Role> roleChecker = OrganizationCheckerFactory.getRoleChecker(role.getOrganization());
        super.reportErrors((List<Msg>)roleChecker.check(role), role);
    }

    @Override
    public boolean supports(Role role) {
        return true;
    }
}

