/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;
import oracle.bpm.resources.Msg;

@CompilerExtensionMetadata
public class OrganizationalUnitCompiler
extends AbstractCompilerExtension<OrganizationalUnit> {
    public OrganizationalUnitCompiler() {
        super(OrganizationalUnit.class, Arrays.asList(ProjectObjectType.OU));
    }

    @Override
    public void compile(OrganizationalUnit ou, CompilationSession session) throws ProjectException {
        ProjectObjectChecker<OrganizationalUnit> ouChecker = OrganizationCheckerFactory.getOrganizationalUnitChecker(ou.getOrganization());
        super.reportWarnings((List<Msg>)ouChecker.check(ou), ou);
    }

    @Override
    public boolean supports(OrganizationalUnit ou) {
        return true;
    }
}

