/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;
import oracle.bpm.resources.Msg;

@CompilerExtensionMetadata
public class HolidayRuleCompiler
extends AbstractCompilerExtension<HolidayRule> {
    public HolidayRuleCompiler() {
        super(HolidayRule.class, Arrays.asList(ProjectObjectType.HOLIDAY_RULE));
    }

    @Override
    public void compile(HolidayRule holidayRule, CompilationSession session) throws ProjectException {
        ProjectObjectChecker<HolidayRule> holidayRuleChecker = OrganizationCheckerFactory.getHolidayRuleChecker(holidayRule.getOrganization());
        super.reportErrors((List<Msg>)holidayRuleChecker.check(holidayRule), holidayRule);
    }

    @Override
    public boolean supports(HolidayRule holidayRule) {
        return true;
    }
}

