/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.List;
import java.util.TreeMap;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Any;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.CalendarRulesContainer;
import oracle.bpm.project.model.GroupsContainer;
import oracle.bpm.project.model.HolidayRulesContainer;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.OrganizationalUnitsContainer;
import oracle.bpm.project.model.ParticipantsContainer;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectList;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.OrganizationObject;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.organization.CalendarRuleImpl;
import oracle.bpm.project.organization.HolidayRuleImpl;
import oracle.bpm.project.organization.OrganizationalChartImpl;
import oracle.bpm.project.organization.RoleImpl;
import org.jetbrains.annotations.NotNull;

public class OrganizationImpl
extends ResourceObjectImpl
implements Organization {
    private Project project;
    private ProjectListener projectListener;
    private boolean updateExistingObjects = false;

    public OrganizationImpl(Project project) throws ProjectException {
        super(project);
        this.adaptProjectObject(this.getVFile(Path.ORGANIZATION, project));
        this.setDeletable(false);
        project.addListener(this.getProjectListener());
        this.project = project;
    }

    @Override
    public Sequence<OrganizationalUnit> getOrganizationalUnits() {
        return this.getOrganizationalChart().getDescendants(OrganizationalUnit.class);
    }

    @Override
    public OrganizationalChart getOrganizationalChart() {
        return (OrganizationalChart)this.getChildrenByType(OrganizationalChart.class).iterator().next();
    }

    @Override
    public OrganizationalUnit createOrganizationalUnit(String ouId, OrganizationalUnit parent) throws ProjectException {
        return this.getOrganizationalUnitsContainer().createOrganizationalUnit(ouId, parent);
    }

    @Override
    public Path getPath() {
        return Path.ORGANIZATION;
    }

    @Override
    public OrganizationalUnit findOrganizationalUnit(String id) {
        return this.getOrganizationalUnitsContainer().findOrganizationalUnit(id);
    }

    @Override
    public OrganizationalUnit getRootOrganizationalUnit() {
        return this.getOrganizationalUnitsContainer().getRootOrganizationalUnit();
    }

    @Override
    public Sequence<Role> getDeclaredRoles() {
        return this.getChildrenByType(Role.class);
    }

    @Override
    public Sequence<Role> getRoles() {
        TreeMap<String, Role> result = new TreeMap<String, Role>();
        for (Role role : this.getDeclaredRoles()) {
            result.put(role.getId(), role);
        }
        return CollectionUtils.asSequence(result.values());
    }

    @Override
    public Role createRole(String id, String name) throws ProjectException {
        return new RoleImpl(this, id, name);
    }

    @Override
    public Role findDeclaredRoleById(String roleId) {
        return this.findChild(Role.class, roleId);
    }

    @Override
    public Role findRoleById(String roleId) {
        Role result = null;
        if (roleId != null) {
            result = this.findDeclaredRoleById(roleId);
        }
        return result;
    }

    @Override
    public Sequence<CalendarRule> getCalendarRules() {
        return this.getChildrenByType(CalendarRule.class);
    }

    @Override
    public CalendarRule createCalendarRule(String calendarRuleId) {
        CalendarRule.Mutable calendarRule = new CalendarRuleImpl(this).asMutable();
        calendarRule.setId(calendarRuleId);
        return calendarRule;
    }

    @Override
    public CalendarRule findCalendarRule(String calendarRuleId) {
        return this.findChild(CalendarRule.class, calendarRuleId);
    }

    @Override
    public Sequence<HolidayRule> getHolidayRules() {
        return this.getChildrenByType(HolidayRule.class);
    }

    @Override
    public HolidayRule createHolidayRule(String holidayRuleId) throws ProjectException {
        HolidayRule.Mutable holidayRule = new HolidayRuleImpl(this).asMutable();
        holidayRule.setId(holidayRuleId);
        return holidayRule;
    }

    @Override
    public HolidayRule findHolidayRule(String holidayRuleId) {
        return this.findChild(HolidayRule.class, holidayRuleId);
    }

    @Override
    public Sequence<Group> getGroups() {
        GroupsContainer container = this.getGroupsContainer();
        return container == null ? CollectionUtils.emptySequence() : container.getChildrenByType(Group.class);
    }

    @Override
    public Group createGroup(String groupId) throws ProjectException {
        return this.getGroupsContainer().createGroup(groupId);
    }

    @Override
    public void addOrganizationalObject(ProjectObject object) throws ProjectException {
        if (object.getParentObject() instanceof ProjectObjectContainer) {
            ((ProjectObjectContainer)object.getParentObject()).addChild(object);
        }
    }

    @Override
    public CalendarRule findCalendarRuleByName(String name) {
        Sequence<CalendarRule> descendants = this.getDescendants(CalendarRule.class);
        for (CalendarRule descendant : descendants) {
            if (!Any.equals((Object)descendant.getName(), (Object)name)) continue;
            return descendant;
        }
        return null;
    }

    @Override
    public void setUpdateExistingObject(boolean updateExistingObjects) {
        Boolean oldValue = this.isUpdateExistingObjects();
        this.updateExistingObjects = updateExistingObjects;
        this.events().objectChanged("updateExistingObjects", oldValue, updateExistingObjects);
    }

    @Override
    public void addChild(ProjectObject child) throws ProjectException {
        if (child instanceof OrganizationalUnit) {
            this.getOrganizationalChart().addChild(child);
        } else {
            super.addChild(child);
        }
    }

    @Override
    public Group findGroup(String groupId) {
        return this.getGroupsContainer().findChild(Group.class, groupId);
    }

    @Override
    public Sequence<Participant> getParticipants() {
        ParticipantsContainer container = this.getParticipantsContainer();
        return container == null ? CollectionUtils.emptySequence() : container.getChildrenByType(Participant.class);
    }

    @Override
    public Participant createParticipant(String participantId) throws ProjectException {
        return this.getParticipantsContainer().createParticipant(participantId);
    }

    @Override
    public Participant findParticipant(String participantId) {
        return this.getParticipantsContainer().findChild(Participant.class, participantId);
    }

    @Override
    public String getId() {
        return this.getPath().getName();
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.ORGANIZATION;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.project;
    }

    @Override
    public void replace(ProjectObject newObject) throws ProjectException {
        this.project.replace(newObject);
    }

    @NotNull
    public ProjectObject.Mutable asMutable() {
        return this;
    }

    public void replaceRole(Role role) throws ProjectException {
        Role oldRole = this.findChild(Role.class, role.getId());
        this.replaceChild(oldRole, role);
    }

    public void replaceParticipant(Participant participant) throws ProjectException {
        Participant oldParticipant = this.getParticipantsContainer().findChild(Participant.class, participant.getId());
        this.getParticipantsContainer().replaceChild(oldParticipant, participant);
    }

    @Override
    public Sequence<OrganizationObject> getAllOrganizationObjects() {
        return CollectionUtils.concat((Iterable[])new Iterable[]{this.getCalendarRules(), this.getGroups(), this.getHolidayRules(), this.getOrganizationalUnitsWithoutRoot(), this.getParticipants(), this.getDeclaredRoles()});
    }

    @Override
    public Sequence<OrganizationalUnit> getOrganizationalUnitsWithoutRoot() {
        OrganizationalUnitsContainer container = this.getOrganizationalUnitsContainer();
        return container == null ? CollectionUtils.emptySequence() : container.getOrganizationalUnitsWithoutRoot();
    }

    public void replaceGroup(Group group) throws ProjectException {
        Group oldGroup = this.getGroupsContainer().findChild(Group.class, group.getId());
        this.getGroupsContainer().replaceChild(oldGroup, group);
    }

    public void replaceOrganizationalUnit(OrganizationalUnit ou) throws ProjectException {
        OrganizationalUnit oldOu = this.getOrganizationalUnitsContainer().findOrganizationalUnit(ou.getId());
        this.getOrganizationalUnitsContainer().replaceChild(oldOu, ou);
    }

    public void replaceOrganizationalChart(OrganizationalChart oc) throws ProjectException {
        this.replaceChild(this.getOrganizationalUnitsContainer(), oc);
    }

    public void replaceCalendarRule(CalendarRule calendarRule) throws ProjectException {
        CalendarRule oldCalendarRule = this.findChild(CalendarRule.class, calendarRule.getId());
        this.replaceChild(oldCalendarRule, calendarRule);
    }

    public void replaceHolidayRule(HolidayRule holidayRule) throws ProjectException {
        HolidayRule oldHolidayRule = this.findChild(HolidayRule.class, holidayRule.getId());
        this.replaceChild(oldHolidayRule, holidayRule);
    }

    public Organization getOrganization() {
        return this;
    }

    public List<String> getInternalPathList() {
        return null;
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public boolean existsOrganizationalUnit(OrganizationalUnit ou) {
        return this.findOrganizationalUnit(ou.getId()) != null;
    }

    @Override
    public CalendarRulesContainer getCalendarRulesContainer() {
        return this.findChild(CalendarRulesContainer.class, Path.CALENDAR.getName());
    }

    @Override
    public GroupsContainer getGroupsContainer() {
        return this.findChild(GroupsContainer.class, Path.GROUP.getName());
    }

    @Override
    public HolidayRulesContainer getHolidayRulesContainer() {
        return this.findChild(HolidayRulesContainer.class, Path.HOLIDAY.getName());
    }

    @Override
    public OrganizationalUnitsContainer getOrganizationalUnitsContainer() {
        return this.findChild(OrganizationalChart.class, Path.ORGANIZATIONAL_CHART.getName());
    }

    @Override
    public ParticipantsContainer getParticipantsContainer() {
        return this.findChild(ParticipantsContainer.class, Path.PARTICIPANT.getName());
    }

    public ProjectListener getProjectListener() {
        if (this.projectListener == null) {
            return new ProjectListenerAdapter<Lane>(Lane.class){

                @Override
                public void postObjectAdded(Lane object, ProjectObject parent) {
                    OrganizationImpl.this.setDirty(true);
                }

                @Override
                public void postObjectRemoved(Lane object, ProjectObject parent) {
                    OrganizationImpl.this.setDirty(true);
                }
            };
        }
        return this.projectListener;
    }

    @Override
    public boolean isUpdateExistingObjects() {
        return this.updateExistingObjects;
    }

    @Override
    protected ProjectObjectList<ProjectObject> loadChildren() throws ProjectException {
        ProjectObjectList<ProjectObject> list = new ProjectObjectList<ProjectObject>();
        list.add(new OrganizationalChartImpl(this, Path.ORGANIZATIONAL_CHART.getName()));
        return list;
    }
}

