/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.holidays.HolidayCalendar;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.HolidayRuleAssignment;
import oracle.bpm.project.organization.OrganizationObjectImpl;
import org.jetbrains.annotations.NotNull;

public class HolidayRuleImpl
extends OrganizationObjectImpl
implements HolidayRule.Mutable {
    private Collection<HolidayRuleAssignment> holidaRuleAssignments = new ArrayList<HolidayRuleAssignment>();
    private HolidayCalendar holidayCalendar;

    public HolidayRuleImpl(Organization organization) {
        super(organization);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.HOLIDAY_RULE;
    }

    @Override
    public HolidayCalendar getHolidayCalendar() {
        return this.holidayCalendar;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.HOLIDAY.create(this.getId());
        }
        return this.path;
    }

    @Override
    @NotNull
    public HolidayRule.Mutable asMutable() {
        return this;
    }

    @Override
    public void setHolidayCalendar(HolidayCalendar holidayCalendar) {
        HolidayCalendar prevHolidayCalendar = this.holidayCalendar;
        this.holidayCalendar = holidayCalendar;
        this.events().objectChanged(this.getOrganization(), "holidayCalendar", prevHolidayCalendar, this.holidayCalendar);
    }

    @Override
    public void addHolidayRuleAssignment(HolidayRuleAssignment holidayRuleAssignment) {
        this.holidaRuleAssignments.add(holidayRuleAssignment);
        this.events().objectChanged(this.getOrganization(), "holidayAssignment", null, holidayRuleAssignment);
    }

    @Override
    public void removeHolidayRuleAssignment(HolidayRuleAssignment holidayRuleAssignment) {
        this.holidaRuleAssignments.remove(holidayRuleAssignment);
        this.events().objectChanged(this.getOrganization(), "holidayAssignment", holidayRuleAssignment, null);
    }

    @Override
    public Collection<HolidayRuleAssignment> getHolidayRuleAssignments() {
        return this.holidaRuleAssignments;
    }

    @Override
    public void removeAllHolidayRuleAssignments() {
        this.holidaRuleAssignments.clear();
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getOrganization();
    }

    @Override
    public int compareTo(HolidayRule holidayRule) {
        return this.getId().compareTo(holidayRule.getId());
    }
}

