/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import oracle.bpm.project.ResourceContainerImpl;
import oracle.bpm.project.model.CalendarRulesContainer;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.organization.CalendarRuleImpl;
import org.jetbrains.annotations.NotNull;

public class CalendarRulesContainerImpl
extends ResourceContainerImpl
implements CalendarRulesContainer {
    private Project project;

    public CalendarRulesContainerImpl(Project project) {
        super(project);
        this.path = Path.CALENDAR;
        this.project = project;
        this.id = this.path.getName();
        this.setDeletable(false);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.CALENDAR_RULES_CONTAINER;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.project.getOrganization();
    }

    @Override
    public CalendarRule createCalendarRule() {
        return new CalendarRuleImpl(this.project.getOrganization());
    }

    @Override
    public CalendarRule createCalendarRule(String id) {
        CalendarRule.Mutable calendarRule = this.createCalendarRule().asMutable();
        calendarRule.setId(id);
        return calendarRule;
    }
}

