/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectRelation;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Role;

public class CalendarRuleAssignmentImpl
implements CalendarRuleAssignment.Mutable,
ProjectObjectRelation {
    private CalendarRule calendarRule;
    private String calendarRuleId;
    private String calendarRuleName;
    private OrganizationalUnit organizationalUnit;
    private String organizationalUnitId;
    private String organizationalUnitName;
    private Role role;
    private String roleId;
    private String roleName;

    @Override
    public String getCalendarRuleName() {
        return this.calendarRuleName;
    }

    @Override
    public void setCalendarRuleName(String calendarRuleName) {
        this.calendarRuleName = calendarRuleName;
    }

    @Override
    public String getOrganizationalUnitName() {
        return this.organizationalUnitName;
    }

    @Override
    public void setOrganizationalUnitName(String organizationalUnitName) {
        this.organizationalUnitName = organizationalUnitName;
    }

    @Override
    public CalendarRuleAssignment.Mutable asMutable() {
        return this;
    }

    @Override
    public void setCalendarRule(CalendarRule calendarRule) {
        this.calendarRule = calendarRule;
        this.calendarRuleId = calendarRule.getId();
        this.calendarRuleName = calendarRule.getName();
    }

    @Override
    public void setOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
        this.organizationalUnitId = organizationalUnit.getId();
        this.organizationalUnitName = organizationalUnit.getName();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Override
    public void setRole(Role role) {
        this.role = role;
        this.roleId = role.getId();
        this.roleName = role.getName();
    }

    @Override
    public CalendarRule getCalendarRule() {
        if (this.calendarRuleId != null && this.getOrganization().findCalendarRule(this.calendarRuleId) != null) {
            this.calendarRule = this.getOrganization().findCalendarRule(this.calendarRuleId);
        }
        return this.calendarRule;
    }

    @Override
    public OrganizationalUnit getOrganizationalUnit() {
        if (this.organizationalUnitId != null && this.getOrganization().findOrganizationalUnit(this.organizationalUnitId) != null) {
            this.organizationalUnit = this.getOrganization().findOrganizationalUnit(this.organizationalUnitId);
        }
        return this.organizationalUnit;
    }

    @Override
    public Role getRole() {
        if (this.roleId != null && this.getOrganization().findRoleById(this.roleId) != null) {
            this.role = this.getOrganization().findRoleById(this.roleId);
        }
        return this.role;
    }

    @Override
    public void addRelation() {
        this.organizationalUnit.asMutable().addCalendarRuleAssignment(this);
        this.calendarRule.asMutable().addCalendarRuleAssignment(this);
        if (this.role != null) {
            this.role.addCalendarRuleAssignment(this);
        }
    }

    @Override
    public void removeRelation() {
        this.organizationalUnit.asMutable().removeCalendarRuleAssignment();
        this.calendarRule.asMutable().removeCalendarRuleAssignment(this);
        if (this.role != null) {
            this.role.removeCalendarRuleAssignment(this);
        }
    }

    @Override
    public Collection<ProjectObject> getRelation() {
        ArrayList<ProjectObject> result = new ArrayList<ProjectObject>();
        result.add(this.organizationalUnit);
        result.add(this.calendarRule);
        result.add(this.role);
        return result;
    }

    @Override
    public void setCalendarRule(String calendarRuleId) {
        this.calendarRuleId = calendarRuleId;
    }

    @Override
    public String getCalendarRuleId() {
        return this.calendarRule != null ? this.calendarRule.getId() : this.calendarRuleId;
    }

    @Override
    public void setOrganizationalUnit(String ouId) {
        this.organizationalUnitId = ouId;
    }

    @Override
    public void setRole(String roleId) {
        this.roleId = roleId;
    }

    @Override
    public String getOrganizationalUnitId() {
        return this.organizationalUnit != null ? this.organizationalUnit.getId() : this.organizationalUnitId;
    }

    @Override
    public String getRoleId() {
        return this.role != null ? this.role.getId() : this.roleId;
    }

    @Override
    public boolean hasOuAssociated(String ouPath) {
        return this.organizationalUnit != null && this.organizationalUnit.getInternalPath().equals(ouPath) || this.organizationalUnitId != null && this.organizationalUnitId.equals(ouPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarRuleAssignmentImpl that = (CalendarRuleAssignmentImpl)o;
        if (this.calendarRuleId != null ? !this.calendarRuleId.equals(that.calendarRuleId) : that.calendarRuleId != null) {
            return false;
        }
        if (this.organizationalUnitId != null ? !this.organizationalUnitId.equals(that.organizationalUnitId) : that.organizationalUnitId != null) {
            return false;
        }
        return !(this.roleId != null ? !this.roleId.equals(that.roleId) : that.roleId != null);
    }

    public int hashCode() {
        int result = this.calendarRuleId != null ? this.calendarRuleId.hashCode() : 0;
        result = 31 * result + (this.organizationalUnitId != null ? this.organizationalUnitId.hashCode() : 0);
        result = 31 * result + (this.roleId != null ? this.roleId.hashCode() : 0);
        return result;
    }

    private Organization getOrganization() {
        if (this.calendarRule != null) {
            return this.calendarRule.getOrganization();
        }
        if (this.role != null) {
            return this.role.getOrganization();
        }
        if (this.organizationalUnit != null) {
            return this.organizationalUnit.getOrganization();
        }
        return null;
    }
}

