/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.LocalFileSystem;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.resources.Resource;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.FileUtils;

@CompilerExtensionMetadata
public class RuntimeResourcesCompiler
extends AbstractCompilerExtension<Resource> {
    public RuntimeResourcesCompiler() {
        super(Resource.class, Arrays.asList(ProjectObjectType.PROJECT_RESOURCE));
    }

    @Override
    public boolean supports(Resource resource) {
        return true;
    }

    @Override
    public void compile(Resource resource, CompilationSession session) throws ProjectException {
        Project project = resource.getProject();
        ProjectWriter projectWriter = project.getWriter();
        ProjectFileSystem projectFileSystem = projectWriter.getProjectFileSystem();
        LocalFileSystem localFileSystem = projectFileSystem.getLocalFileSystem();
        File buildDir = localFileSystem.getBuildCatalogFolder();
        File resourceFile = new File(resource.getSourceDir());
        try {
            String pathname = FileUtils.makePathRelativeTo((String)resource.getSourceDir(), (String)localFileSystem.getRootFolder().getPath());
            File targetFile = new File(buildDir, pathname);
            FileUtils.createFoldersIfNotExists((File[])new File[]{targetFile.getParentFile()});
            FileUtils.copyFileOrDirectory((File)resourceFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new ProjectException(resource, Msg.QUOTE((String)e.getMessage()), e);
        }
    }
}

