/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compiler;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.TypeError;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.compile.exceptions.CatalogObjectCompilerException;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

@CompilerExtensionMetadata
public class CorruptedResourceCompiler
extends AbstractCompilerExtension<CatalogObject> {
    public CorruptedResourceCompiler() {
        super(CatalogObject.class, Arrays.asList(ProjectObjectType.BPM_OBJECT, ProjectObjectType.UNKNOWN));
    }

    @Override
    public boolean supports(@NotNull CatalogObject object) {
        return ComponentType.CORRUPTED_RESOURCE.getText().equals(object.getDelegate().getComponentType());
    }

    @Override
    public void compile(@NotNull CatalogObject object, @NotNull CompilationSession session) throws ProjectException {
        TypeDescription typeDescription = object.getDelegate();
        List errors = typeDescription.getErrors();
        if (!errors.isEmpty()) {
            TypeError typeError = (TypeError)errors.get(0);
            CatalogObjectImpl.CorruptedResourceImpl corruptedResource = (CatalogObjectImpl.CorruptedResourceImpl)object;
            throw CatalogObjectCompilerException.wrap((CatalogObject)corruptedResource, (TypeError)typeError);
        }
    }
}

