/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.builder;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.project.builder.ExprBuilder;
import oracle.bpm.project.builder.FuegoMethodBuilder;
import oracle.bpm.project.builder.JavaMethodBuilder;
import oracle.bpm.project.builder.MethodBuilder;
import oracle.bpm.project.builder.Tokens;
import oracle.bpm.project.builder.VisualBasicMethodBuilder;
import oracle.bpm.type.SourceCode;
import org.jetbrains.annotations.NonNls;

public abstract class Builder
implements Tokens {
    private Tokens tokens;
    private static Map<String, Class> methodBuilderMap;
    private static Map<String, Class> exprBuilderMap;
    public static final Tokens FUEGO_TOKENS;
    public static final Tokens JAVA_TOKENS;
    public static final Tokens VISUALBASIC_TOKENS;

    protected Builder(Tokens tokens) {
        this.tokens = tokens;
    }

    public abstract String getLanguage();

    public static ExprBuilder createExprBuilder(String language) {
        if (language == null) {
            throw new IllegalArgumentException("Invalid null language");
        }
        if (!exprBuilderMap.containsKey(language)) {
            throw new IllegalArgumentException("No expr builder has been registered with language '" + language + "'");
        }
        Class builderClass = exprBuilderMap.get(language);
        assert (builderClass != null) : "No class for language '" + language + "'";
        try {
            return (ExprBuilder)builderClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MethodBuilder createMethodBuilder(String language) {
        if (language == null) {
            throw new IllegalArgumentException("Invalid null language");
        }
        if (!methodBuilderMap.containsKey(language)) {
            throw new IllegalArgumentException("No method builder has been registered with language '" + language + "'");
        }
        Class builderClass = methodBuilderMap.get(language);
        try {
            return (MethodBuilder)builderClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static SourceCode generateMethodCode(MethodBuilder builder) {
        String codeLang = builder.getLanguage();
        StringWriter writer = new StringWriter();
        IndentedPrintWriter iwriter = new IndentedPrintWriter((Writer)writer);
        builder.generate(iwriter);
        iwriter.close();
        return SourceCode.create((String)writer.toString(), (String)codeLang);
    }

    public static String generateMethodCodeAsString(MethodBuilder builder) {
        StringWriter writer = new StringWriter();
        IndentedPrintWriter iwriter = new IndentedPrintWriter((Writer)writer);
        builder.generate(iwriter);
        iwriter.close();
        return writer.toString();
    }

    public static String join(String[] arr, char delim, boolean quote) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                ret.append(delim);
                ret.append(' ');
            }
            if (quote) {
                ret.append('\"');
            }
            ret.append(Builder.escape(arr[i], delim));
            if (!quote) continue;
            ret.append('\"');
        }
        return ret.toString();
    }

    public static String quote(String text) {
        return "\"" + text + "\"";
    }

    public String concat(String lval, String rval) {
        return lval + this.getConcat() + rval;
    }

    @Override
    public char getArrayClose() {
        return this.getTokens().getArrayClose();
    }

    @Override
    public char getArrayOpen() {
        return this.getTokens().getArrayOpen();
    }

    @Override
    public String getConcat() {
        return this.getTokens().getConcat();
    }

    @Override
    public String getDisplay() {
        return this.getTokens().getDisplay();
    }

    @Override
    public char getMapDeclarationClose() {
        return this.getTokens().getMapDeclarationClose();
    }

    @Override
    public char getMapDeclarationOpen() {
        return this.getTokens().getMapDeclarationOpen();
    }

    @Override
    public String getMapDeclarationSeparator() {
        return this.getTokens().getMapDeclarationSeparator();
    }

    @Override
    public char getMapKeyClose() {
        return this.getTokens().getMapKeyClose();
    }

    @Override
    public char getMapKeyOpen() {
        return this.getTokens().getMapKeyOpen();
    }

    @Override
    public String getNull() {
        return this.getTokens().getNull();
    }

    @Override
    public String getStatementSeparator() {
        return this.getTokens().getStatementSeparator();
    }

    @Override
    public String getThis() {
        return this.getTokens().getThis();
    }

    protected static void registerExprBuilder(@NonNls String language, Class builder) {
        if (language == null) {
            throw new IllegalArgumentException("Invalid null language");
        }
        if (builder == null || !ExprBuilder.class.isAssignableFrom(builder)) {
            throw new IllegalArgumentException("Invalid expr builder: either null or invalid class");
        }
        if (exprBuilderMap == null) {
            exprBuilderMap = new TreeMap<String, Class>();
        }
        if (exprBuilderMap.containsKey(language)) {
            throw new IllegalArgumentException("An expression builder already exists for the specified language");
        }
        exprBuilderMap.put(language, builder);
    }

    protected static void registerMethodBuilder(@NonNls String language, Class builder) {
        if (language == null) {
            throw new IllegalArgumentException("Invalid null language");
        }
        if (builder == null || !MethodBuilder.class.isAssignableFrom(builder)) {
            throw new IllegalArgumentException("Invalid method builder: either null or invalid class");
        }
        if (methodBuilderMap == null) {
            methodBuilderMap = new TreeMap<String, Class>();
        }
        if (methodBuilderMap.containsKey(language)) {
            throw new IllegalArgumentException("A method builder already exists for the specified language");
        }
        methodBuilderMap.put(language, builder);
    }

    private static String escape(String str, char delim) {
        if (str == null || str.length() == 0 || str.equals("")) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\' || c == delim) {
                result.append('\\');
            }
            result.append(c);
        }
        return result.toString();
    }

    private Tokens getTokens() {
        return this.tokens;
    }

    static {
        FUEGO_TOKENS = new FuegoTokens();
        JAVA_TOKENS = new JavaTokens();
        VISUALBASIC_TOKENS = new VisualBasicTokens();
        Builder.registerMethodBuilder("Fuego", FuegoMethodBuilder.class);
        Builder.registerMethodBuilder("Fuego1", FuegoMethodBuilder.class);
        Builder.registerMethodBuilder("Fuego2", FuegoMethodBuilder.class);
        Builder.registerMethodBuilder("Java", JavaMethodBuilder.class);
        Builder.registerMethodBuilder("Java1", JavaMethodBuilder.class);
        Builder.registerMethodBuilder("VisualBasic", VisualBasicMethodBuilder.class);
        Builder.registerMethodBuilder("VisualBasic1", VisualBasicMethodBuilder.class);
        Builder.registerExprBuilder("Fuego", ExprBuilder.Fuego.class);
        Builder.registerExprBuilder("Fuego1", ExprBuilder.Fuego.class);
        Builder.registerExprBuilder("Fuego2", ExprBuilder.Fuego.class);
        Builder.registerExprBuilder("Java", ExprBuilder.Java.class);
        Builder.registerExprBuilder("Java1", ExprBuilder.Java.class);
        Builder.registerExprBuilder("VisualBasic", ExprBuilder.VisualBasic.class);
        Builder.registerExprBuilder("VisualBasic1", ExprBuilder.VisualBasic.class);
        try {
            Class.forName("oracle.bpm.compiler.LanguageSpec");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Could not load LanguageSpec");
        }
    }

    static class FuegoTokens
    implements Tokens {
        FuegoTokens() {
        }

        @Override
        public char getArrayClose() {
            return ']';
        }

        @Override
        public char getArrayOpen() {
            return '[';
        }

        @Override
        public String getConcat() {
            return " + ";
        }

        @Override
        public String getDisplay() {
            return "display";
        }

        @Override
        public char getMapDeclarationClose() {
            return ']';
        }

        @Override
        public char getMapDeclarationOpen() {
            return '[';
        }

        @Override
        public String getMapDeclarationSeparator() {
            return ":";
        }

        @Override
        public char getMapKeyClose() {
            return ']';
        }

        @Override
        public char getMapKeyOpen() {
            return '[';
        }

        @Override
        public String getNull() {
            return "null";
        }

        @Override
        public String getStatementSeparator() {
            return "";
        }

        @Override
        public String getThis() {
            return "this";
        }
    }

    public static class VisualBasicTokens
    implements Tokens {
        @Override
        public char getArrayClose() {
            return '}';
        }

        @Override
        public char getArrayOpen() {
            return '{';
        }

        @Override
        public String getConcat() {
            return " & ";
        }

        @Override
        public String getDisplay() {
            return "Display";
        }

        @Override
        public char getMapDeclarationClose() {
            return '}';
        }

        @Override
        public char getMapDeclarationOpen() {
            return '{';
        }

        @Override
        public String getMapDeclarationSeparator() {
            return ":=";
        }

        @Override
        public char getMapKeyClose() {
            return ')';
        }

        @Override
        public char getMapKeyOpen() {
            return '(';
        }

        @Override
        public String getNull() {
            return "Nothing";
        }

        @Override
        public String getStatementSeparator() {
            return "";
        }

        @Override
        public String getThis() {
            return "Me";
        }
    }

    public static class JavaTokens
    implements Tokens {
        @Override
        public char getArrayClose() {
            return '}';
        }

        @Override
        public char getArrayOpen() {
            return '{';
        }

        @Override
        public String getConcat() {
            return " + ";
        }

        @Override
        public String getDisplay() {
            return "display";
        }

        @Override
        public char getMapDeclarationClose() {
            return '}';
        }

        @Override
        public char getMapDeclarationOpen() {
            return '{';
        }

        @Override
        public String getMapDeclarationSeparator() {
            return ":";
        }

        @Override
        public char getMapKeyClose() {
            return ']';
        }

        @Override
        public char getMapKeyOpen() {
            return '[';
        }

        @Override
        public String getNull() {
            return "null";
        }

        @Override
        public String getStatementSeparator() {
            return ";";
        }

        @Override
        public String getThis() {
            return "this";
        }
    }
}

