/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.activityguide;

import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.activityguide.TranslatableValueImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.activityguide.ActivityRef;
import oracle.bpm.project.model.activityguide.DisplayMode;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.activityguide.TranslatableValue;
import oracle.bpm.project.model.activityguide.TranslationType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import org.jetbrains.annotations.NotNull;

public class MilestoneActivityImpl
extends ProjectObjectImpl
implements MilestoneActivity,
Cloneable {
    private Activity activity;
    private ActivityRef activityRef;
    private boolean displayBlockedIcon;
    private DisplayMode displayMode = DisplayMode.DEFAULT;
    private boolean lastTaskInMilestone;
    private boolean markedAsOptional;
    private ProjectObjectContainer parent;
    private int tasksRemaining;
    private TranslatableValue translatableBlockedIconText = new TranslatableValueImpl(TranslationType.STATIC, "");

    public MilestoneActivityImpl(@NotNull ProjectObjectContainer parent, @NotNull ActivityRef activityRef) {
        super(parent.getProject());
        this.setId(activityRef.getActivityId() + "_" + activityRef.getProcessId());
        this.activityRef = activityRef;
        this.parent = parent;
    }

    @Override
    public double getTotalPercentComplete() {
        return 0.0;
    }

    @Override
    public Activity getActivity() {
        if (this.activity == null) {
            this.activity = this.activityRef.getActivity(this.getProject());
        }
        return this.activity;
    }

    @Override
    public void delete() throws ProjectException {
        super.delete();
        this.activity = null;
    }

    @Override
    public ActivityRef getActivityRef() {
        return this.activityRef;
    }

    @Override
    public void setBlockedIconText(TranslatableValue translatableIconText) {
        this.translatableBlockedIconText = translatableIconText;
        this.events().objectChanged();
    }

    @Override
    public void setBlockedIconText(String blockedIconText) {
        this.translatableBlockedIconText = new TranslatableValueImpl(TranslationType.STATIC, blockedIconText);
        this.events().objectChanged();
    }

    @Override
    public TranslatableValue getTranslatableBlockedIconText() {
        return this.translatableBlockedIconText;
    }

    @Override
    public MilestoneActivity clone(ProjectObjectContainer parentObject) throws ProjectException {
        try {
            MilestoneActivityImpl clone = (MilestoneActivityImpl)super.clone();
            clone.setId(this.id);
            clone.parent = parentObject;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw ProjectException.wrap((ProjectObject)this, e);
        }
    }

    @Override
    public ProjectObject getParentObject() {
        return this.parent;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public BpmnType getType() {
        if (this.getActivity() != null) {
            return this.getActivity().getBpmnType();
        }
        return BpmnType.USER_TASK;
    }

    @Override
    public String getDefaultLabel() {
        if (this.getActivity() != null) {
            return this.getActivity().getDefaultLabel();
        }
        return this.activityRef.getId();
    }

    @Override
    public Milestone getMilestone() {
        return (Milestone)this.getParentObject();
    }

    @Override
    public void setMilestone(Milestone milestone) {
        this.parent = milestone;
        this.events().objectChanged();
    }

    @Override
    public void setMarkedAsOptional(boolean markedAsOptional) {
        this.markedAsOptional = markedAsOptional;
        this.events().objectChanged();
    }

    @Override
    public boolean isMarkedAsOptional() {
        return this.markedAsOptional;
    }

    @Override
    public void setDisplayBlockedIcon(boolean displayBlockedIcon) {
        this.displayBlockedIcon = displayBlockedIcon;
        this.events().objectChanged();
    }

    @Override
    public boolean isDisplayBlockedIcon() {
        return this.displayBlockedIcon;
    }

    @Override
    public void setTasksRemaining(int tasksRemaining) {
        this.tasksRemaining = tasksRemaining;
        this.events().objectChanged();
    }

    @Override
    public int getTasksRemaining() {
        return this.tasksRemaining;
    }

    @Override
    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
        this.events().objectChanged();
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.MILESTONE_ACTIVITY;
    }
}

