/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.activityguide;

import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.activityguide.MilestoneImpl;
import oracle.bpm.project.activityguide.ResourceBundleImpl;
import oracle.bpm.project.activityguide.RootProcessRefImpl;
import oracle.bpm.project.activityguide.TranslatableValueImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.DisplayMode;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.ResourceBundle;
import oracle.bpm.project.model.activityguide.RootProcessRef;
import oracle.bpm.project.model.activityguide.TaskAccessMode;
import oracle.bpm.project.model.activityguide.TranslatableValue;
import oracle.bpm.project.model.activityguide.TranslationType;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;

public class ActivityGuideImpl
extends ResourceObjectImpl
implements ActivityGuide {
    private DisplayMode displayMode = DisplayMode.ALWAYS;
    private String iconLocation;
    private Project project;
    private ResourceBundle resourceBundle;
    private RootProcessRef rootProcessRef;
    private TaskAccessMode taskAccessMode = TaskAccessMode.ANY_STATES;
    private TranslatableValue translatableDescription = new TranslatableValueImpl(TranslationType.STATIC, "");
    private TranslatableValue translatableTitle = new TranslatableValueImpl(TranslationType.STATIC, "");

    public ActivityGuideImpl(Project project, String id) {
        super(project);
        this.setId(id);
        this.setDeletable(false);
        this.project = project;
        this.resourceBundle = ResourceBundleImpl.createDefault();
        this.addProjectListener();
    }

    @Override
    public Class getRawClass() {
        return ActivityGuide.class;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.project;
    }

    @Override
    public Milestone createMilestone(String id) throws ProjectException {
        return new MilestoneImpl(this, id);
    }

    @Override
    public void setTitle(String title) {
        switch (this.getTranslatableTitle().getType()) {
            case RESOURCE: {
                this.translatableTitle = new TranslatableValueImpl(TranslationType.RESOURCE, title);
                break;
            }
            case STATIC: {
                this.translatableTitle = new TranslatableValueImpl(TranslationType.STATIC, title);
                break;
            }
            default: {
                this.translatableTitle = new TranslatableValueImpl(TranslationType.STATIC, title);
            }
        }
        this.events().objectChanged();
    }

    @Override
    public void setTitle(TranslatableValue translatableTitle) {
        this.translatableTitle = translatableTitle;
        this.events().objectChanged();
    }

    @Override
    public TranslatableValue getTranslatableTitle() {
        return this.translatableTitle;
    }

    @Override
    public void setDescription(String description) {
        switch (this.getTranslatableDescription().getType()) {
            case RESOURCE: {
                this.translatableDescription = new TranslatableValueImpl(TranslationType.RESOURCE, description);
                break;
            }
            case STATIC: {
                this.translatableDescription = new TranslatableValueImpl(TranslationType.STATIC, description);
                break;
            }
            default: {
                this.translatableDescription = new TranslatableValueImpl(TranslationType.STATIC, description);
            }
        }
        this.events().objectChanged();
    }

    @Override
    public void setDescription(TranslatableValue translatableDescription) {
        this.translatableDescription = translatableDescription;
        this.events().objectChanged();
    }

    @Override
    public TranslatableValue getTranslatableDescription() {
        return this.translatableDescription;
    }

    @Override
    public void setRootProcess(Process rootProcess) {
        this.rootProcessRef = rootProcess != null ? new RootProcessRefImpl(rootProcess) : null;
        this.events().objectChanged();
    }

    @Override
    public void setRootProcessId(String rootProcessId) {
        this.rootProcessRef = new RootProcessRefImpl(this.getProject(), rootProcessId);
    }

    @Override
    public Process getRootProcess() {
        return this.rootProcessRef != null ? this.rootProcessRef.getRootProcess() : null;
    }

    @Override
    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
        this.events().objectChanged();
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public void setTaskAccessMode(TaskAccessMode taskAccessMode) {
        this.taskAccessMode = taskAccessMode;
        this.events().objectChanged();
    }

    @Override
    public TaskAccessMode getTaskAccessMode() {
        return this.taskAccessMode;
    }

    @Override
    public void setIconLocation(String iconLocation) {
        this.iconLocation = iconLocation;
        this.events().objectChanged();
    }

    @Override
    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.events().objectChanged();
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public ResourceBundle createDefaultResourceBundle() {
        return ResourceBundleImpl.createDefault();
    }

    @Override
    public String getIconLocation() {
        return this.iconLocation;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.ACTIVITY_GUIDE;
    }

    private void addProjectListener() {
        ProjectListenerAdapter<Process> processListener = new ProjectListenerAdapter<Process>(Process.class){

            @Override
            public void postObjectRemoved(Process object, ProjectObject parent) {
                Process rootProcess = ActivityGuideImpl.this.getRootProcess();
                if (rootProcess != null && object.getId().equals(rootProcess.getId())) {
                    ActivityGuideImpl.this.setRootProcess(null);
                }
            }
        };
        this.project.addListener(processListener);
    }
}

