/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.activities;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.project.model.features.ActivityPermissionFeature;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.features.BusinessRuleTaskFeature;
import oracle.bpm.project.model.features.CustomizedImageFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.InputArgumentsFeature;
import oracle.bpm.project.model.features.InputDataAssociationFeature;
import oracle.bpm.project.model.features.InstantiateFeature;
import oracle.bpm.project.model.features.IsCollapsedFeature;
import oracle.bpm.project.model.features.IsDraftFeature;
import oracle.bpm.project.model.features.IsInterruptingFeature;
import oracle.bpm.project.model.features.LoggableFeature;
import oracle.bpm.project.model.features.NotificationFeature;
import oracle.bpm.project.model.features.OutputArgumentsFeature;
import oracle.bpm.project.model.features.OutputDataAssociationFeature;
import oracle.bpm.project.model.features.ReceiveTaskFeature;
import oracle.bpm.project.model.features.RelatedProcessNameFeature;
import oracle.bpm.project.model.features.ScriptTaskFeature;
import oracle.bpm.project.model.features.SendTaskFeature;
import oracle.bpm.project.model.features.ServiceTaskFeature;
import oracle.bpm.project.model.features.UpdateFeature;
import oracle.bpm.project.model.features.UserTaskFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventBasedGatewayTypeFeature;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.ExpressionFeature;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.FlowNodeAdapter;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.ManualTask;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.activities.ActivityLevelFeature;
import oracle.bpm.project.model.processes.activities.ComplexGatewayFeature;
import oracle.bpm.project.model.processes.activities.CustomImageFeature;
import oracle.bpm.project.model.processes.activities.EventTriggerTypeFeature;
import oracle.bpm.project.model.processes.activities.FirstActivityInFlowFeature;
import oracle.bpm.project.model.processes.activities.GatewayDirectionFeature;
import oracle.bpm.project.model.processes.activities.GenerateEventsFeature;
import oracle.bpm.project.model.processes.activities.LoopCharacteristicsFeature;
import oracle.bpm.project.model.processes.activities.MergingGatewayFeature;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.project.model.processes.activities.PairedGatewayAssociationFeature;
import oracle.bpm.project.model.processes.activities.ParentScopeFeature;
import oracle.bpm.project.model.processes.notification.NotificationTask;
import oracle.bpm.project.model.processes.update.UpdateTask;
import oracle.bpm.project.model.util.ModelUtils;

public class FeaturesByBPMNType {
    public static Features get(FlowNode node, BpmnType bpmnType) {
        HashMap<Class, Feature> result = new HashMap<Class, Feature>();
        if (node.isActivity()) {
            if (node.asAnyNode(Activity.class).isSubprocess()) {
                FeaturesByBPMNType.addTo(result, IsCollapsedFeature.create());
            }
            FeaturesByBPMNType.addTo(result, CustomizedImageFeature.create());
        }
        ModelUtils.handleFlowNode(node, new FeaturesByNodeHandler(result));
        return Features.create(result);
    }

    private static void addTo(Map<Class, Feature> result, Feature feature) {
        result.put(feature.getClass(), feature);
    }

    private static class FeaturesByNodeHandler
    extends FlowNodeAdapter {
        private final Map<Class, Feature> result;

        public FeaturesByNodeHandler(Map<Class, Feature> result) {
            this.result = result;
        }

        @Override
        public void handleEndEvent(EndEvent node) {
            FeaturesByBPMNType.addTo(this.result, EventTriggerTypeFeature.create());
        }

        @Override
        public void handleStartEvent(StartEvent node) {
            FeaturesByBPMNType.addTo(this.result, EventTriggerTypeFeature.create());
            FeaturesByBPMNType.addTo(this.result, IsInterruptingFeature.create());
        }

        @Override
        public void handleUserTask(UserTask userTask) {
            FeaturesByBPMNType.addTo(this.result, UserTaskFeature.create(userTask));
        }

        @Override
        public void handleScriptTask(ScriptTask scriptTask) {
            FeaturesByBPMNType.addTo(this.result, ScriptTaskFeature.create(scriptTask));
        }

        @Override
        public void handleManualTask(ManualTask node) {
        }

        @Override
        public void handleServiceTask(ServiceTask serviceTask) {
            FeaturesByBPMNType.addTo(this.result, ServiceTaskFeature.create(serviceTask));
        }

        @Override
        public void handleIntermediateThrowEvent(ThrowEvent node) {
            FeaturesByBPMNType.addTo(this.result, EventTriggerTypeFeature.create());
        }

        @Override
        public void handleCatchIntermediateEvent(CatchEvent node) {
            FeaturesByBPMNType.addTo(this.result, EventTriggerTypeFeature.create());
            FeaturesByBPMNType.addTo(this.result, NodeAssociationFeature.create(node));
        }

        @Override
        public void handleSubprocess(Subprocess subprocess) {
            FeaturesByBPMNType.addTo(this.result, LoopCharacteristicsFeature.create(subprocess));
            FeaturesByBPMNType.addTo(this.result, InputDataAssociationFeature.create(subprocess));
            FeaturesByBPMNType.addTo(this.result, OutputDataAssociationFeature.create(subprocess));
            FeaturesByBPMNType.addTo(this.result, InputArgumentsFeature.create(subprocess));
            FeaturesByBPMNType.addTo(this.result, OutputArgumentsFeature.create(subprocess));
            FeaturesByBPMNType.addTo(this.result, LoggableFeature.create(subprocess));
        }

        @Override
        public void handleBusinessRuleTask(BusinessRuleTask businessRuleTask) {
            FeaturesByBPMNType.addTo(this.result, BusinessRuleTaskFeature.create(businessRuleTask));
        }

        @Override
        public void handleReceiveTask(ReceiveTask receiveTask) {
            FeaturesByBPMNType.addTo(this.result, ReceiveTaskFeature.create(receiveTask));
        }

        @Override
        public void handleSendTask(SendTask sendTask) {
            FeaturesByBPMNType.addTo(this.result, SendTaskFeature.create(sendTask));
        }

        @Override
        public void handleExclusiveGateway(ExclusiveGateway node) {
            FeaturesByBPMNType.addTo(this.result, GatewayDirectionFeature.create());
        }

        @Override
        public void handleInclusiveGateway(InclusiveGateway node) {
            FeaturesByBPMNType.addTo(this.result, PairedGatewayAssociationFeature.create(node));
            FeaturesByBPMNType.addTo(this.result, GatewayDirectionFeature.create());
        }

        @Override
        public void handleParallelGateway(ParallelGateway node) {
            FeaturesByBPMNType.addTo(this.result, PairedGatewayAssociationFeature.create(node));
            FeaturesByBPMNType.addTo(this.result, GatewayDirectionFeature.create());
        }

        @Override
        public void handleEventBasedGateway(EventBasedGateway node) {
            FeaturesByBPMNType.addTo(this.result, InstantiateFeature.create());
            FeaturesByBPMNType.addTo(this.result, GatewayDirectionFeature.create());
            FeaturesByBPMNType.addTo(this.result, EventBasedGatewayTypeFeature.create());
        }

        @Override
        public void handleComplexGateway(ComplexGateway node) {
            FeaturesByBPMNType.addTo(this.result, ComplexGatewayFeature.create());
            FeaturesByBPMNType.addTo(this.result, ExpressionFeature.create());
            FeaturesByBPMNType.addTo(this.result, GatewayDirectionFeature.create());
            FeaturesByBPMNType.addTo(this.result, PairedGatewayAssociationFeature.create(node));
        }

        @Override
        public void handleBoundaryEvent(BoundaryEvent node) {
            FeaturesByBPMNType.addTo(this.result, EventTriggerTypeFeature.create());
            FeaturesByBPMNType.addTo(this.result, NodeAssociationFeature.create(node));
            FeaturesByBPMNType.addTo(this.result, IsInterruptingFeature.create());
        }

        @Override
        public void handleCommon(FlowNode node) {
            FeaturesByBPMNType.addTo(this.result, GenerateEventsFeature.create());
            FeaturesByBPMNType.addTo(this.result, ActivityLevelFeature.create());
            FeaturesByBPMNType.addTo(this.result, FirstActivityInFlowFeature.create());
            FeaturesByBPMNType.addTo(this.result, CustomImageFeature.create());
            FeaturesByBPMNType.addTo(this.result, ParentScopeFeature.create(node));
            FeaturesByBPMNType.addTo(this.result, ActivityPermissionFeature.create());
            FeaturesByBPMNType.addTo(this.result, AnnotationsFeature.create());
            FeaturesByBPMNType.addTo(this.result, MergingGatewayFeature.create(node));
            if (node.isActivity() || node.isEvent()) {
                FeaturesByBPMNType.addTo(this.result, IsDraftFeature.create());
            }
        }

        @Override
        public void handleCallActivity(CallActivity node) {
            FeaturesByBPMNType.addTo(this.result, RelatedProcessNameFeature.create());
            FeaturesByBPMNType.addTo(this.result, InputDataAssociationFeature.create(node));
            FeaturesByBPMNType.addTo(this.result, OutputDataAssociationFeature.create(node));
            FeaturesByBPMNType.addTo(this.result, LoopCharacteristicsFeature.create(node));
            FeaturesByBPMNType.addTo(this.result, InputArgumentsFeature.create(node));
            FeaturesByBPMNType.addTo(this.result, OutputArgumentsFeature.create(node));
            FeaturesByBPMNType.addTo(this.result, LoggableFeature.create(node));
        }

        @Override
        public void handleNotificationTask(NotificationTask task) {
            FeaturesByBPMNType.addTo(this.result, NotificationFeature.create(task));
        }

        @Override
        public void handleUpdateTask(UpdateTask task) {
            FeaturesByBPMNType.addTo(this.result, UpdateFeature.create(task));
        }

        @Override
        public void handleAbstractActivity(Activity node) {
            super.handleAbstractActivity(node);
        }
    }
}

