/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Cast;
import oracle.bpm.log.Log;
import oracle.bpm.project.ActivityImpl;
import oracle.bpm.project.CorrelationKeyContainerManager;
import oracle.bpm.project.NodeContainerManager;
import oracle.bpm.project.PredefinedVariablesHelper;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.project.process.conversation.ConversationImpl;
import org.jetbrains.annotations.NotNull;

public class SubprocessImpl
extends ActivityImpl
implements Subprocess {
    private boolean measurementsChanged = false;
    private NodeContainerManager nodeContainerManager;
    private boolean triggeredByEvent;

    public SubprocessImpl(ProcessContent content, NodeContainer container, boolean triggeredByEvent) {
        this(content, container, triggeredByEvent, null);
    }

    public SubprocessImpl(ProcessContent content, NodeContainer container, boolean triggeredByEvent, String id) {
        super(content, container, BpmnType.SUBPROCESS, null, id);
        this.nodeContainerManager = new NodeContainerManager(content, this);
        this.triggeredByEvent = triggeredByEvent;
    }

    @Override
    public boolean isTriggeredByEvent() {
        return this.triggeredByEvent;
    }

    @Override
    public Subprocess getSubprocess() {
        return !this.getParentObject().equals(this.getProcess()) ? (Subprocess)this.getParentObject() : null;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Override
    public boolean isInstantiate() {
        return false;
    }

    @Override
    public boolean cancelActivity() {
        return false;
    }

    @Override
    public FlowNode copy() {
        SubprocessImpl result = new SubprocessImpl(this.getProcessContent(), this.getParentObject(), this.isTriggeredByEvent(), this.getId());
        SubprocessImpl.copy(this, result);
        return result;
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public Sequence<FlowNode> getFlowNodes() {
        return this.getNodeContainerManager().getFlowNodes();
    }

    @Override
    public <T extends FlowNode> Sequence<T> getFlowNodes(Class<T> clazz) {
        return this.getNodeContainerManager().getFlowNodes(clazz);
    }

    @Override
    public <T extends Activity> Sequence<T> getActivities(Class<T> clazz) {
        return this.getNodeContainerManager().getActivities(clazz);
    }

    @Override
    public Sequence<Activity> getActivities() {
        return this.getNodeContainerManager().getActivities();
    }

    @Override
    public <T extends Event> Sequence<T> getEvents(Class<T> clazz) {
        return this.getNodeContainerManager().getEvents(clazz);
    }

    @Override
    public <T extends Event> Sequence<T> getEvents(Class<T> clazz, EventTriggerType trigger) {
        return this.getNodeContainerManager().getEvents(clazz, trigger);
    }

    @Override
    public Sequence<Event> getEvents() {
        return this.getNodeContainerManager().getEvents();
    }

    @Override
    public <T extends Gateway> Sequence<T> getGateways(Class<T> clazz) {
        return this.getNodeContainerManager().getGateways(clazz);
    }

    @Override
    public Sequence<Gateway> getGateways() {
        return this.getNodeContainerManager().getGateways();
    }

    @Override
    public FlowNode findNode(String nodeId) {
        return this.getNodeContainerManager().findNode(nodeId);
    }

    @Override
    public FlowNode findNodeByLabel(String nodeId) {
        return this.getNodeContainerManager().findNodeByLabel(nodeId);
    }

    @Override
    public Gateway findGateway(String gatewayId) {
        return this.getNodeContainerManager().findGateway(gatewayId);
    }

    @Override
    public Event findEvent(String eventId) {
        return this.getNodeContainerManager().findEvent(eventId);
    }

    @Override
    public BoundaryEvent findBoundaryEvent(String boundaryEventId) {
        return this.getNodeContainerManager().findBoundaryEvent(boundaryEventId);
    }

    @Override
    public Activity findActivity(String activityId) {
        return this.getNodeContainerManager().findActivity(activityId);
    }

    @Override
    public TextAnnotation createTextAnnotation(String idAnnotation) {
        return this.getNodeContainerManager().createTextAnnotation(idAnnotation);
    }

    @Override
    public Sequence<Measurement> getMeasurements() {
        return this.getNodeContainerManager().getMeasurements();
    }

    @Override
    public Activity createActivity() {
        return this.getNodeContainerManager().createActivity();
    }

    @Override
    public Activity createActivity(boolean needLabel) {
        return this.getNodeContainerManager().createActivity(needLabel);
    }

    @Override
    public Subprocess createSubprocess() {
        return this.getNodeContainerManager().createSubprocess();
    }

    @Override
    public Subprocess createSubprocess(boolean isTriggeredByEvent) {
        return this.getNodeContainerManager().createSubprocess(isTriggeredByEvent);
    }

    @Override
    public ThrowEvent createIntermediateThrowEvent(EventTriggerType triggerType) {
        return this.getNodeContainerManager().createIntermediateThrowEvent(triggerType);
    }

    @Override
    public CatchEvent createIntermediateCatchEvent(EventTriggerType triggerType) {
        return this.getNodeContainerManager().createIntermediateCatchEvent(triggerType);
    }

    @Override
    public BoundaryEvent createBoundaryEvent(EventTriggerType triggerType, Activity boundaryTarget) {
        return this.getNodeContainerManager().createBoundaryEvent(triggerType, boundaryTarget);
    }

    @Override
    public StartEvent createStartEvent(EventTriggerType triggerType) {
        return this.getNodeContainerManager().createStartEvent(triggerType);
    }

    @Override
    public Measurement createMeasurement(String measurementId) {
        return this.getNodeContainerManager().createMeasurement(measurementId);
    }

    @Override
    public void addMeasurement(Measurement measurement) throws ProjectException {
        this.addChild(measurement);
    }

    @Override
    public boolean isMeasurementsChanged() {
        return this.measurementsChanged;
    }

    @Override
    public void removeMeasurement(Measurement measurement) throws ProjectException {
        this.removeChild(measurement);
    }

    @Override
    public void setMeasurementsChanged(boolean measurementsChanged) {
        this.measurementsChanged = measurementsChanged;
    }

    @Override
    public EndEvent createEndEvent(EventTriggerType triggerType) {
        return this.getNodeContainerManager().createEndEvent(triggerType);
    }

    @Override
    public SequenceFlow createSequenceFlow() {
        return this.getNodeContainerManager().createSequenceFlow();
    }

    @Override
    public SequenceFlow createSequenceFlow(FlowNode source, FlowNode target) {
        return this.getNodeContainerManager().createSequenceFlow(source, target);
    }

    @Override
    public Sequence<BoundaryEvent> getBoundaryEvents() {
        return this.getNodeContainerManager().getBoundaryEvents();
    }

    @Override
    public Sequence<SequenceFlow> getSequenceFlows() {
        return this.getNodeContainerManager().getSequenceFlows();
    }

    @Override
    public Sequence<TextAnnotation> getTextAnnotations() {
        return this.getNodeContainerManager().getTextAnnotations();
    }

    @Override
    public SequenceFlow findSequenceFlow(String sequenceFlowId) {
        return this.getNodeContainerManager().findSequenceFlow(sequenceFlowId);
    }

    @Override
    public Measurement findMeasurement(String measurementId) {
        return this.getNodeContainerManager().findMeasurement(measurementId);
    }

    @Override
    public TextAnnotation findTextAnnotation(String noteId) {
        return this.getNodeContainerManager().findTextAnnotation(noteId);
    }

    @Override
    public ParallelGateway createParallelGateway() {
        return this.getNodeContainerManager().createParallelGateway();
    }

    @Override
    public ExclusiveGateway createExclusiveGateway() {
        return this.getNodeContainerManager().createExclusiveGateway();
    }

    @Override
    public InclusiveGateway createInclusiveGateway() {
        return this.getNodeContainerManager().createInclusiveGateway();
    }

    @Override
    public EventBasedGateway createEventBasedGateway() {
        return this.getNodeContainerManager().createEventBasedGateway();
    }

    @Override
    public ComplexGateway createComplexGateway() {
        return this.getNodeContainerManager().createComplexGateway();
    }

    @Override
    public void addChild(ProjectObject child) throws ProjectException {
        this.getNodeContainerManager().validateAddChild(child);
        super.addChild(child);
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return this.getParentObject().equals(this.getProcess()) ? this.getProcess() : (Subprocess)this.getParentObject();
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        Sequence result = (Sequence)Cast.force(this.getNodeContainerManager().getDataObjects());
        return PredefinedVariablesHelper.appendPredefinedVariablesForContainer((Sequence<DataDeclaration>)result, this);
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return true;
    }

    @Override
    public DataObject createDeclaration(String name, CatalogType type) throws ProjectException {
        return this.createDeclaration(name, type, null);
    }

    @Override
    public DataObject createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        return this.getNodeContainerManager().createDataObject(name, type);
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        assert (dataDeclaration instanceof DataObject) : "DataDeclaration must be a DataObject";
        this.addChild(dataDeclaration);
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        assert (dataDeclaration instanceof DataObject) : "DataDeclaration must be a DataObject";
        this.removeChild(dataDeclaration);
    }

    @Override
    public Counter createCounter(String counterId) {
        return this.getNodeContainerManager().createCounter(counterId);
    }

    @Override
    public void addCounter(Counter counter) throws ProjectException {
        this.addChild(counter);
    }

    @Override
    public void removeCounter(Counter counter) throws ProjectException {
        this.removeChild(counter);
    }

    @Override
    public Counter findCounter(String counterId) {
        return this.getNodeContainerManager().findCounter(counterId);
    }

    @Override
    public Sequence<Counter> getCounters() {
        return this.getNodeContainerManager().getCounters();
    }

    @Override
    @NotNull
    public Sequence<CorrelationKey> getCorrelationKeys() {
        return CorrelationKeyContainerManager.getCorrelationKeys(this);
    }

    @Override
    public CorrelationKey findCorrelationKey(@NotNull String correlationKeyId) {
        return CorrelationKeyContainerManager.findCorrelationKey(this, correlationKeyId);
    }

    @Override
    @NotNull
    public CorrelationKey createCorrelationKey(@NotNull String correlationKeyId) {
        return CorrelationKeyContainerManager.createCorrelationKey(this, correlationKeyId);
    }

    @Override
    public void addCorrelationKey(@NotNull CorrelationKey correlationKey) throws ProjectException {
        CorrelationKeyContainerManager.addCorrelationKey(this, correlationKey);
    }

    @Override
    public void removeCorrelationKey(@NotNull CorrelationKey correlationKey) throws ProjectException {
        CorrelationKeyContainerManager.removeCorrelationKey((CorrelationKeyContainer)this, correlationKey);
    }

    @Override
    public void removeCorrelationKey(@NotNull String correlationKeyId) throws ProjectException {
        CorrelationKeyContainerManager.removeCorrelationKey((CorrelationKeyContainer)this, correlationKeyId);
    }

    @Override
    @NotNull
    public Sequence<CorrelationKey> getScopedCorrelationKeys() {
        return CorrelationKeyContainerManager.getScopedCorrelationKeys(this);
    }

    @Override
    public CorrelationKey findInScopedCorrelationKeys(@NotNull String correlationKeyId) {
        return CorrelationKeyContainerManager.findInScopedCorrelationKeys(this, correlationKeyId);
    }

    @Override
    public Sequence<Conversation> getLocalConversations() {
        return this.getChildrenByType(Conversation.class);
    }

    @Override
    public Sequence<Conversation> getConversations() {
        return ConversationalHelper.getScopedConversationsInContainer((ConversationContainer)this);
    }

    @Override
    public Conversation createNamedConversation(@NotNull String name, @NotNull ConversationType type) {
        return ConversationImpl.createNamedConversation(this, name, type);
    }

    @Override
    public Conversation createDefaultConversation(@NotNull ConversationType type) {
        return ConversationImpl.createDefaultConversation(this, type);
    }

    @Override
    public void addConversation(@NotNull Conversation conversation) throws ProjectException {
        this.addChild(conversation);
    }

    @Override
    public void removeConversation(@NotNull Conversation conversation) throws ProjectException {
        this.removeChild(conversation);
    }

    @Override
    public ConversationContainer getParentConversationsScope() {
        return ConversationalHelper.getParentConversationsScope((ConversationContainer)this);
    }

    protected static void copy(Subprocess source, Subprocess target) {
        ActivityImpl.copy(source, target);
        SubprocessImpl.copyDataObjects(source, target);
    }

    private static void copyDataObjects(Subprocess source, Subprocess target) {
        Sequence<DataObject> dataObjects = source.getLocalDeclarations(DataObject.class);
        for (DataObject dataObject : dataObjects) {
            try {
                target.addDeclaration(dataObject);
            }
            catch (ProjectException e) {
                Log.logSevere((Throwable)((Object)e));
                e.printStackTrace();
            }
        }
    }

    private NodeContainerManager getNodeContainerManager() {
        return this.nodeContainerManager;
    }
}

