/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.geom.Point;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionLanguage;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.BPMNTypes;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProcessObjectImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.features.CurveTransitionFeature;
import oracle.bpm.project.model.features.EnumFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.RoutingModeFeature;
import oracle.bpm.project.model.features.TransitionUserNameFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.BpmnSequenceFlowType;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.ModelObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.NormalFlow;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.project.model.processes.transitions.ConditionalTransitionFeature;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.transitions.FeaturesByTransition;
import oracle.bpm.project.transitions.TransitionOrderFeature;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class SequenceFlowImpl
extends ProcessObjectImpl
implements Cloneable,
ConditionalFlow,
NormalFlow,
ModelObject,
SequenceFlow {
    private NodeContainer container;
    private Features features;
    private FlowNode from;
    private boolean isDynamic = false;
    private FlowNode to;
    private EnumFeature<TransitionType> transitionType = new TransitionTypeFeature();
    public static String ACTIVITY_FROM_PROPERTY = "activityFrom";
    public static String ACTIVITY_TO_PROPERTY = "activityTo";

    SequenceFlowImpl(@NotNull Process process, @NotNull TransitionType type) {
        super(process.getProject(), process);
        this.setTransitionType(type);
        this.container = process;
        this.transitionType.addModificationListener(this.getModificationListener());
    }

    SequenceFlowImpl(Process c, @NotNull NodeContainer container, @NotNull TransitionType type) {
        this(c, type);
        this.container = container;
    }

    @Override
    public String getName() {
        return this.getBuiltName();
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> clazz) {
        T result = this.features.getFeature(clazz);
        if (result == null) {
            result = this.features.find(clazz);
        }
        return result;
    }

    @Override
    @NotNull
    public SequenceFlow copy() {
        SequenceFlowImpl result = new SequenceFlowImpl(this.getProcessContent(), this.getParentObject(), this.getTransitionType());
        result.setId(this.getId());
        this.copy(this, result);
        return result;
    }

    @Override
    public void applyFrom(@NotNull SequenceFlow flow) throws ProjectException {
        this.copy((SequenceFlowImpl)flow, this);
    }

    @Override
    public BpmnSequenceFlowType getSequenceFlowType() {
        return BPMNTypes.getBpmnTypeFromTransition(this.getTransitionType());
    }

    @Override
    public boolean isNormalFlow() {
        return this.getTransitionType() == TransitionType.UNCONDITIONAL;
    }

    @Override
    public boolean isConditionalFlow() {
        return this.getTransitionType() == TransitionType.CONDITIONAL;
    }

    @Override
    public ConditionalFlow asConditionalFlow() {
        if (this.isConditionalFlow()) {
            return this;
        }
        return null;
    }

    @Override
    public boolean isExceptionFlow() {
        return ModelUtils.isExceptionFlow(this);
    }

    @Override
    public <T> T getFeatureValue(Class<? extends Feature<T>> clazz) {
        return this.features.getValue(clazz);
    }

    public List<TransitionType> getAllowedTransitionTypes() {
        ArrayList<TransitionType> transitions = new ArrayList<TransitionType>();
        transitions.add(TransitionType.UNCONDITIONAL);
        transitions.add(TransitionType.CONDITIONAL);
        return transitions;
    }

    public String getBuiltName() {
        return ModelUtils.getBuiltName(this);
    }

    @Override
    public Point getControlPoint() {
        return this.getFeature(CurveTransitionFeature.class).getControlPoint();
    }

    @Override
    public RoutingMode getRoutingMode() {
        return (RoutingMode)((Object)this.getFeature(RoutingModeFeature.class).getValue());
    }

    public String getDisplayName() {
        String result = "??";
        if (this.getTarget() != null) {
            result = this.getBuiltName();
        }
        return result;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.TRANSITION;
    }

    @Override
    public Class getRawClass() {
        return SequenceFlow.class;
    }

    @Override
    public Sequence<Measurement> getMeasurements() {
        Predicate<Measurement> checkTransition = new Predicate<Measurement>(){

            public boolean check(Measurement measurement) {
                return measurement.getTransition() != null && measurement.getTransition() == SequenceFlowImpl.this;
            }
        };
        return this.getParentObject().getMeasurements().select((Predicate)checkTransition);
    }

    @Override
    public FlowNode getSource() {
        return this.from;
    }

    @Override
    public FlowNode getTarget() {
        return this.to;
    }

    public TransitionType getTransitionType() {
        return (TransitionType)((Object)this.transitionType.getValue());
    }

    public String getUserName() {
        return this.getFeature(TransitionUserNameFeature.class).getValue();
    }

    public boolean isConditional() {
        return this.getTransitionType() == TransitionType.CONDITIONAL;
    }

    @Override
    public boolean isCurve() {
        return this.getFeature(CurveTransitionFeature.class).isCurve();
    }

    public boolean isUnconditional() {
        return this.getTransitionType() == TransitionType.UNCONDITIONAL;
    }

    public boolean isValid() {
        return this.getSource() != null && this.getTarget() != null;
    }

    @Override
    public void setRoutingData(@NotNull RoutingMode mode, @NotNull Point ctrl) {
        if (SequenceFlow.NULL_CONTROL_POINT.equals((Object)ctrl)) {
            if (!RoutingMode.STRAIGHT.equals((Object)mode)) {
                mode = RoutingMode.STRAIGHT;
            }
        } else if (RoutingMode.STRAIGHT.equals((Object)mode)) {
            mode = RoutingMode.ORTHOGONAL;
        }
        this.getFeature(CurveTransitionFeature.class).setControlPoint(ctrl);
        this.getFeature(RoutingModeFeature.class).setValue(mode);
    }

    @Override
    public NodeContainer getParentObject() {
        return this.container;
    }

    @Override
    public void afterAdd(ProjectObjectContainer projectObjectContainer) throws ProjectException {
        this.container = (NodeContainer)projectObjectContainer;
    }

    @Override
    public void afterRemove(ProjectObjectContainer projectObjectContainer) throws ProjectException {
    }

    @Override
    public void setSource(FlowNode from) {
        FlowNode previous = this.getSource();
        if (previous != from) {
            this.from = from;
            this.events().objectChanged(ACTIVITY_FROM_PROPERTY, previous, from);
        }
    }

    @Override
    public void setTarget(FlowNode target) {
        FlowNode previous = this.getTarget();
        if (previous != target) {
            this.to = target;
            this.events().objectChanged(ACTIVITY_TO_PROPERTY, previous, this.to);
        }
    }

    public void setTransitionType(TransitionType type) {
        if (this.transitionType.getValue() == type) {
            return;
        }
        this.transitionType.setValue(type);
        Features oldFeatures = this.features;
        this.removeModificationListener(oldFeatures);
        this.features = this.generateFeatures();
        this.features.copyFrom(oldFeatures);
        this.addModificationListener(this.features);
    }

    public void setUserName(String userName) {
        this.getFeature(TransitionUserNameFeature.class).setValue(userName);
    }

    public String toString() {
        String result = this.getUserName();
        if (result == null) {
            result = this.getBuiltName();
        }
        return result;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public void setDefaultLabel(String text) {
        this.setUserName(text);
        super.setDefaultLabel(text);
    }

    @Override
    public String getDefaultLabel() {
        return this.getUserName();
    }

    @Override
    public Path getPath() {
        return this.getParentObject().getPath().create(this.getId());
    }

    @Override
    public ConditionalFlow toConditionalFlow() {
        this.updateTransitionType(TransitionType.CONDITIONAL);
        return this;
    }

    @Override
    public NormalFlow toNormalFlow() {
        this.updateTransitionType(TransitionType.UNCONDITIONAL);
        return this;
    }

    @Override
    public void setCondition(Expression expression) {
        this.getFeature(ConditionalTransitionFeature.class).setValue(expression);
    }

    @Override
    public void setEvaluationOrder(int order) {
        this.getFeature(TransitionOrderFeature.class).setValue(order);
    }

    @Override
    public int getEvaluationOrder() {
        return this.getFeature(TransitionOrderFeature.class).getValue();
    }

    @Deprecated
    public void setCondition(String expression) {
        this.getFeature(ConditionalTransitionFeature.class).setValue((Expression)new XPathExpression(expression));
    }

    @Override
    public String getExpressionLanguage() {
        String result = null;
        Expression condition = this.getCondition();
        if (condition != null) {
            ExpressionLanguage language = condition.getLanguage();
            result = language.toString();
        }
        return result;
    }

    @Override
    public Expression getCondition() {
        return this.getFeature(ConditionalTransitionFeature.class).getValue();
    }

    @Override
    @NotNull
    public Map<String, String> getAnnotations(boolean visible) {
        return this.getFeature(AnnotationsFeature.class).getAnnotations(visible);
    }

    @Override
    public void addAnnotation(@NotNull String key, @NotNull String value, boolean visible) {
        this.getFeature(AnnotationsFeature.class).addAnnotation(key, value, visible);
    }

    @Override
    public void removeAnnotation(@NotNull String key, boolean visible) {
        this.getFeature(AnnotationsFeature.class).removeAnnotation(key, visible);
    }

    @Override
    public String getAnnotationValue(@NotNull String key, boolean visible) {
        return this.getFeature(AnnotationsFeature.class).getAnnotationValue(key, visible);
    }

    private void copy(@NotNull SequenceFlowImpl source, @NotNull SequenceFlowImpl target) {
        target.setTransitionType(source.getTransitionType());
        target.setLabelMap(source.getLabelMap().clone());
        target.setDescription(source.getDescriptionMap().clone());
        target.setSource(source.getSource());
        target.setTarget(source.getTarget());
        target.setDefaultLabel(source.getDefaultLabel());
        target.getFeatures().copyFrom(source.getFeatures());
    }

    private Features generateFeatures() {
        Process model = this.getProcess();
        assert (model instanceof ProcessContent) : "model implementation should be process content.";
        this.features = FeaturesByTransition.get(this.getTransitionType());
        return this.features;
    }

    private void updateTransitionType(TransitionType type) {
        this.setTransitionType(type);
    }

    private static class TransitionTypeFeature
    extends EnumFeature<TransitionType> {
        protected TransitionTypeFeature() {
            super(TransitionType.class, "transitionType", ProjectModelMsg.TRANSITION, Msg.QUOTE((String)""), null);
        }
    }
}

