/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.project.catalog.bundles.ServiceReferenceManager;
import oracle.bpm.project.catalog.composite.CatalogInterfaceType;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.catalog.composite.ScaBindingInfo;
import oracle.bpm.project.catalog.composite.ScaBindingInfoWs;
import oracle.bpm.project.catalog.composite.ScaController;
import oracle.bpm.project.catalog.composite.ScaWsdlInfo;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceManager;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.data.PortTypeDescription;
import oracle.bpm.project.model.data.ServiceData;
import oracle.bpm.project.model.data.TransactionParticipationEnum;
import oracle.bpm.project.model.data.TransactionVersionEnum;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.soa.humantask.HumanTaskBpm;
import oracle.bpm.soa.humantask.HumanTaskException;
import oracle.bpm.soa.humantask.PatternType;
import oracle.bpm.soa.io.IOFactory;
import oracle.bpm.soa.rules.DecisionServiceUtil;
import oracle.bpm.soa.rules.DecisionServiceUtilFactory;
import oracle.bpm.soa.rules.DictionaryBuilder;
import oracle.bpm.soa.rules.common.Constants;
import oracle.bpm.soa.rules.data.DFFact;
import oracle.bpm.soa.rules.exception.BpmBusinessRuleException;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.utils.XmlUtils;
import oracle.bpm.util.Identifier;
import oracle.rules.sdk2.datamodel.DecisionFunction;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceManagerImpl
implements ResourceManager {
    @NotNull
    private final Project project;
    public static final String APPLICATION_CONTEXT = "OracleBPMProcessRolesApp";
    private static final String WS_AT_FLOWOPTION_PROPERTY_NAME = "weblogic.wsee.wsat.transaction.flowOption";
    private static final String WS_AT_VERSION_PROPERTY_NAME = "weblogic.wsee.wsat.transaction.version";

    public ResourceManagerImpl(@NotNull Project project) {
        this.project = project;
    }

    @Override
    public CatalogObject addService(@NotNull ServiceData service) throws ProjectException {
        CatalogObject result;
        Object inputStream = null;
        try {
            boolean isService;
            TransactionVersionEnum transactionVersion;
            String serviceName = service.getServiceName();
            if (this.checkServiceExists(serviceName)) {
                throw new ProjectException(this.project, ProjectMsg.SERVICE_NAME_IS_NOT_UNIQUE(serviceName));
            }
            String location = service.getLocation();
            PortTypeDescription portData = service.getPort();
            PortTypeDescription callbackPortData = service.getCallbackPort();
            QName callbackPort = callbackPortData != null ? callbackPortData.getPort() : null;
            QName port = portData.getPort();
            ScaWsdlInfo wslInfo = new ScaWsdlInfo(location, port, callbackPort);
            String binding = portData.getBinding();
            ScaController scaController = CompositeAccessorFactory.createScaController((Project)this.project);
            ScaBindingInfoWs bindingInfo = new ScaBindingInfoWs(port.getLocalPart(), location, binding, portData.getDefaultServiceName(), portData.getDefaultServicePort());
            TransactionParticipationEnum transactionParticipation = service.getTransactionFlowOption();
            if (transactionParticipation != null) {
                bindingInfo.addProperty(WS_AT_FLOWOPTION_PROPERTY_NAME, transactionParticipation.getId());
            }
            if ((transactionVersion = service.getTransactionVersion()) != null) {
                bindingInfo.addProperty(WS_AT_VERSION_PROPERTY_NAME, transactionVersion.getId());
            }
            if (isService = service.isService()) {
                scaController.addServiceEntrypoint(serviceName, wslInfo, (ScaBindingInfo)bindingInfo);
            } else {
                scaController.addExternalReference(serviceName, wslInfo, (ScaBindingInfo)bindingInfo);
            }
            scaController.commitChanges();
            String catalogObjectName = this.getCatalogObjectName(serviceName, isService);
            result = this.project.findCatalogObject(catalogObjectName);
        }
        catch (AmbiguousTypeNameException e) {
            try {
                throw new ProjectException(this.project, ProjectMsg.CANNOT_ADD_NEW_SERVICE, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{inputStream});
        return result;
    }

    @Override
    public void uploadFile(@NotNull String location, @NotNull InputStream stream) throws ProjectException {
        ProjectLoader loader = this.project.getLoader();
        if (loader != null) {
            try {
                ProjectFileSystem projectFileSystem = loader.getProjectFileSystem();
                VFileSystem fileSystem = projectFileSystem.getDataFileSystem();
                VFile file = fileSystem.createFile(location);
                this.copyInputStream(stream, file.openOuputStream());
            }
            catch (IOException e) {
                throw new ProjectException(this.project, (Msg)ProjectMsg.CANNOT_COPY_RESOURCE(location), e);
            }
        } else {
            throw new ProjectException(this.project, (Msg)ProjectMsg.CANNOT_COPY_RESOURCE(location));
        }
    }

    @Override
    public void uploadZipFile(@NotNull ZipFile zipFile) throws ProjectException {
        block5: {
            List entries = CollectionUtils.sort((Sequence)CollectionUtils.asSequence((Iterable)CollectionUtils.each(zipFile.entries())), (Comparator)new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry o1, ZipEntry o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            try {
                ProjectLoader loader = this.project.getLoader();
                if (loader != null) {
                    ProjectFileSystem projectFileSystem = loader.getProjectFileSystem();
                    VFileSystem system = projectFileSystem.getDataFileSystem();
                    for (ZipEntry zipEntry : entries) {
                        VFile file = system.createFile("/" + zipEntry.getName());
                        if (zipEntry.isDirectory()) {
                            file.mkdirs();
                            continue;
                        }
                        file.getParentFile().mkdirs();
                        this.copyInputStream(zipFile.getInputStream(zipEntry), file.openOuputStream());
                    }
                    break block5;
                }
                throw new ProjectException(this.project, (Msg)ProjectMsg.CANNOT_COPY_RESOURCE(zipFile.getName()));
            }
            catch (IOException e) {
                throw new ProjectException(this.project, (Msg)ProjectMsg.CANNOT_COPY_RESOURCE(zipFile.getName()), e);
            }
        }
    }

    @Override
    public boolean checkServiceExists(@Nullable String name) {
        boolean result = false;
        if (name != null) {
            ScaController scaController = CompositeAccessorFactory.createScaController((Project)this.project);
            Sequence externalReferences = scaController.getExternalReferences();
            Sequence entrypoints = scaController.getServiceEntrypoints();
            result = entrypoints.contains((Object)name) || externalReferences.contains((Object)name);
        }
        return result;
    }

    @Override
    public boolean checkIfHumanTaskExists(@Nullable String htName) {
        return !this.isUniqueName(htName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HumanTask addHumanTask(@NotNull String humanTaskName, @NotNull PatternType patternType, @Nullable String applicationName) throws ProjectException {
        HumanTask result;
        Object inputStream = null;
        try {
            if (!this.isUniqueName(humanTaskName)) {
                throw new ProjectException(this.project, ProjectMsg.HUMAN_TASK_NAME_IS_NOT_UNIQUE(humanTaskName));
            }
            VFileSystem fs = this.project.getWriter().getProjectFileSystem().getDataFileSystem();
            VFile root = fs.getRoot();
            oracle.bpm.soa.humantask.HumanTask humanTask = HumanTaskBpm.createHumanTaskForBpm((String)this.project.getName(), (String)humanTaskName, (PatternType)patternType, (String)applicationName);
            IOFactory.createTaskVFileIO().saveTask((Object)root, humanTask);
            ScaController scaController = CompositeAccessorFactory.createScaController((Project)this.project);
            String wsdlLocation = "oramds:/soa/shared/workflow/TaskServiceInterface.wsdl";
            QName request = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "TaskService");
            QName response = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "TaskServiceCallback");
            ScaWsdlInfo wslInfo = new ScaWsdlInfo(wsdlLocation, request, response);
            scaController.createComponent(humanTaskName, "workflow", humanTaskName + ".task", "TaskService", wslInfo);
            scaController.commitChanges();
            String normalizedName = Identifier.classname((String)humanTaskName);
            String humanTaskCatalogId = "HumanTasks." + normalizedName;
            result = (HumanTask)this.project.findCatalogObject(humanTaskCatalogId);
        }
        catch (HumanTaskException e) {
            try {
                throw ProjectException.wrap((ProjectObject)this.project, e);
                catch (AmbiguousTypeNameException e2) {
                    throw new ProjectException(this.project, ProjectMsg.CANNOT_ADD_NEW_SERVICE, e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{inputStream});
        return result;
    }

    @Override
    public HumanTask addHumanTask(@NotNull String humanTaskName) throws ProjectException {
        return this.addHumanTask(humanTaskName, PatternType.SIMPLE, null);
    }

    @Override
    public void deleteHumanTask(@NotNull String humanTaskName) throws ProjectException {
        Object inputStream = null;
        try {
            ProjectCase caseProject = this.project.getCase();
            if (caseProject != null) {
                Collection<ProjectCaseActivity> caseActivities = caseProject.getCaseActivitiesForHumantask(humanTaskName);
                for (ProjectCaseActivity caseActivity : caseActivities) {
                    caseActivity.delete();
                }
            }
            VFileSystem fs = this.project.getWriter().getProjectFileSystem().getDataFileSystem();
            VFile root = fs.getRoot();
            oracle.bpm.soa.humantask.HumanTask humanTask = HumanTaskBpm.createHumanTaskForBpm((String)this.project.getName(), (String)humanTaskName);
            IOFactory.createTaskVFileIO().deleteTask((Object)root, humanTask);
            ScaController scaController = CompositeAccessorFactory.createScaController((Project)this.project);
            scaController.deleteComponent(humanTaskName);
            scaController.commitChanges();
        }
        catch (HumanTaskException e) {
            try {
                throw ProjectException.wrap((ProjectObject)this.project, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{inputStream});
    }

    @Override
    public BusinessRule addDecisionService(@NotNull DecisionFunction decisionFunction, @NotNull String decisionServiceName) throws ProjectException {
        RuleDictionary dictionary = decisionFunction.getDictionary();
        try {
            DecisionServiceUtil dsUtil = DecisionServiceUtilFactory.createVFileDecisionServiceUtil((VFile)this.getProjectRoot(), (String)this.project.getName());
            dsUtil.addDecisionService(decisionFunction, decisionServiceName);
            String wsdlLocation = decisionServiceName + ".wsdl";
            String decisionServiceNamespace = "http://xmlns.oracle.com/" + dictionary.getName() + "/" + decisionServiceName;
            QName request = new QName(decisionServiceNamespace, "IDecisionService");
            ScaWsdlInfo wsdlInfo = new ScaWsdlInfo(wsdlLocation, request, null);
            ScaController scaController = CompositeAccessorFactory.createScaController((Project)this.project);
            scaController.addService(dictionary.getName(), decisionServiceName, wsdlInfo);
            scaController.commitChanges();
            return this.getBusinessRuleFromCatalog(dictionary.getName(), dictionary.getPackage());
        }
        catch (Exception e) {
            throw new ProjectException(this.project, ProjectMsg.CANNOT_ADD_DECISION_SERVICE(dictionary.getName(), decisionServiceName), e);
        }
    }

    @Override
    public BusinessRule removeDecisionService(@NotNull DecisionFunction decisionFunction, @NotNull String decisionServiceName) throws ProjectException {
        RuleDictionary dictionary = decisionFunction.getDictionary();
        try {
            DecisionServiceUtil dsUtil = DecisionServiceUtilFactory.createVFileDecisionServiceUtil((VFile)this.getProjectRoot(), (String)this.project.getName());
            dsUtil.removeDecisionService(dictionary.getName(), decisionServiceName);
            ScaController scaController = CompositeAccessorFactory.createScaController((Project)this.project);
            scaController.deleteService(dictionary.getName(), decisionServiceName);
            scaController.deleteServiceEntrypoint(decisionServiceName);
            scaController.cleanWsdlImports(Arrays.asList(decisionServiceName + ".wsdl"));
            scaController.commitChanges();
            return this.getBusinessRuleFromCatalog(dictionary.getName(), dictionary.getPackage());
        }
        catch (Exception e) {
            throw new ProjectException(this.project, ProjectMsg.CANNOT_REMOVE_DECISION_SERVICE(dictionary.getName(), decisionServiceName), e);
        }
    }

    @Override
    public BusinessRule updateDecisionService(@NotNull DecisionFunction decisionFunction, @NotNull String decisionServiceName) throws ProjectException {
        RuleDictionary dictionary = decisionFunction.getDictionary();
        try {
            DecisionServiceUtil dsUtil = DecisionServiceUtilFactory.createVFileDecisionServiceUtil((VFile)this.getProjectRoot(), (String)this.project.getName());
            dsUtil.updateDecisionService(decisionFunction, decisionServiceName);
            return this.getBusinessRuleFromCatalog(dictionary.getName(), dictionary.getPackage());
        }
        catch (Exception e) {
            throw new ProjectException(this.project, ProjectMsg.CANNOT_UPDATE_DECISION_SERVICE(dictionary.getName(), decisionServiceName), e);
        }
    }

    @Override
    public String getDecisionServiceName(@NotNull DecisionFunction decisionFunction) throws ProjectException {
        String decisionServiceName;
        try {
            DecisionServiceUtil dsUtil = DecisionServiceUtilFactory.createVFileDecisionServiceUtil((VFile)this.getProjectRoot(), (String)this.project.getName());
            decisionServiceName = dsUtil.getDecisionServiceName(decisionFunction);
        }
        catch (Exception e) {
            throw ProjectException.wrap((ProjectObject)this.project, e);
        }
        return decisionServiceName.equals("") ? null : decisionServiceName;
    }

    @Override
    public BusinessRule refreshBusinessRule(@NotNull BusinessRule businessRule, @NotNull String jaxbGenDir) throws ProjectException {
        RuleDictionary dictionary = businessRule.getDictionary();
        try {
            Sequence<BpmObject> businessObjects = this.getFilteredBusinessObjects();
            long timestamp = System.nanoTime();
            List<URI> schemaURIs = this.getSchemaURIs(businessObjects, timestamp);
            DictionaryBuilder.newInstance().getFactTypeImporter().importFacts(dictionary, jaxbGenDir, schemaURIs, new File(Constants.TMP_RULES_DIR + timestamp).toURI());
            IOFactory.createRulesVFileIO().saveDictionary((Object)this.getProjectRoot(), dictionary);
            return this.getBusinessRuleFromCatalog(dictionary.getName(), dictionary.getPackage());
        }
        catch (Exception exc) {
            throw new ProjectException(this.project, ProjectMsg.CANNOT_REFRESH_BUSINESS_RULE(dictionary.getName()), exc);
        }
    }

    @Override
    public void deleteBusinessRule(@NotNull BusinessRule businessRule) throws ProjectException {
        RuleDictionary dictionary = businessRule.getDictionary();
        try {
            IOFactory.createRulesVFileIO().deleteDictionary((Object)this.getProjectRoot(), dictionary);
            DecisionServiceUtil dsUtil = DecisionServiceUtilFactory.createVFileDecisionServiceUtil((VFile)this.getProjectRoot(), (String)this.project.getName());
            List decisionServices = dsUtil.deleteDecisionComponent(dictionary.getName());
            ScaController scaController = CompositeAccessorFactory.createScaController((Project)this.project);
            for (String decisionService : decisionServices) {
                scaController.deleteServiceEntrypoint(decisionService);
            }
            scaController.deleteComponent(dictionary.getName());
            ArrayList<String> decisionServiceWSDLLocations = new ArrayList<String>(decisionServices.size());
            for (String decisionService : decisionServices) {
                decisionServiceWSDLLocations.add(decisionService + ".wsdl");
            }
            scaController.cleanWsdlImports(decisionServiceWSDLLocations);
            scaController.commitChanges();
        }
        catch (Exception e) {
            throw new ProjectException(this.project, ProjectMsg.CANNOT_DELETE_BUSINESS_RULE(dictionary.getName()), e);
        }
    }

    @Override
    public BusinessRule addBusinessRule(@NotNull String dictionaryName, @NotNull String packageName, boolean isCompositeService, @NotNull List<DFFact> inputs, @NotNull List<DFFact> outputs, @NotNull String jaxbGenDir) throws ProjectException {
        BusinessRule result;
        RuleDictionary dictionary;
        List<URI> schemaURIs;
        VFile projectRoot = this.getProjectRoot();
        if (!this.isUniqueName(dictionaryName)) {
            throw new ProjectException(this.project, ProjectMsg.BUSINESS_RULE_NAME_IS_NOT_UNIQUE(dictionaryName));
        }
        DictionaryBuilder ruleBuilder = DictionaryBuilder.newInstance();
        ruleBuilder.setDictionaryName(dictionaryName).setPackageName(packageName).setJaxbGenDir(jaxbGenDir);
        ruleBuilder.addDFInputs(inputs);
        ruleBuilder.addDFOutputs(outputs);
        Sequence<BpmObject> businessObjects = this.getFilteredBusinessObjects();
        long timestamp = System.nanoTime();
        try {
            schemaURIs = this.getSchemaURIs(businessObjects, timestamp);
        }
        catch (URISyntaxException exc) {
            throw new ProjectException(this.project, ProjectMsg.CANNOT_ADD_BUSINESS_RULE(dictionaryName), exc);
        }
        catch (IOException exc) {
            throw new ProjectException(this.project, ProjectMsg.CANNOT_ADD_BUSINESS_RULE(dictionaryName), exc);
        }
        for (URI schemaURI : schemaURIs) {
            ruleBuilder.addFactSource(schemaURI);
        }
        ruleBuilder.setSchemaPathRoot(new File(Constants.TMP_RULES_DIR + timestamp).toURI());
        try {
            dictionary = ruleBuilder.build();
            IOFactory.createRulesVFileIO().saveDictionary((Object)projectRoot, dictionary);
        }
        catch (BpmBusinessRuleException exc) {
            throw new ProjectException(this.project, ProjectMsg.CANNOT_ADD_BUSINESS_RULE(dictionaryName), exc);
        }
        String decsFileName = dictionaryName + ".decs";
        String serviceName = dictionaryName + "_DecisionService";
        String wsdlLocation = serviceName + ".wsdl";
        DecisionFunction decisionFunction = (DecisionFunction)dictionary.getDataModel().getDecisionFunctionTable().getByAlias("DecisionFunction1");
        DecisionServiceUtil dsUtil = DecisionServiceUtilFactory.createVFileDecisionServiceUtil((VFile)projectRoot, (String)this.project.getName());
        try {
            dsUtil.createDecisionComponent(decisionFunction, serviceName);
        }
        catch (Exception exc) {
            throw new ProjectException(this.project, ProjectMsg.CANNOT_ADD_BUSINESS_RULE(dictionaryName), exc);
        }
        String componentType = "decision";
        String decisionServiceNamespace = "http://xmlns.oracle.com/" + dictionaryName + "/" + serviceName;
        QName request = new QName(decisionServiceNamespace, "IDecisionService");
        ScaWsdlInfo wsdlInfo = new ScaWsdlInfo(wsdlLocation, request, null);
        ScaController scaController = CompositeAccessorFactory.createScaController((Project)this.project);
        if (isCompositeService) {
            ScaBindingInfoWs bindingInfo = new ScaBindingInfoWs(null, wsdlLocation, null, null, null);
            scaController.addServiceEntrypoint(serviceName, wsdlInfo, (ScaBindingInfo)bindingInfo);
        }
        scaController.createComponent(dictionaryName, "decision", decsFileName, serviceName, wsdlInfo);
        if (isCompositeService) {
            scaController.addWire(serviceName, null, dictionaryName, serviceName);
        }
        scaController.commitChanges();
        try {
            result = this.getBusinessRuleFromCatalog(dictionaryName, packageName);
        }
        catch (AmbiguousTypeNameException exc) {
            throw new ProjectException(this.project, ProjectMsg.CANNOT_ADD_BUSINESS_RULE(dictionaryName), exc);
        }
        return result;
    }

    private VFile getProjectRoot() {
        return this.project.getWriter().getProjectFileSystem().getDataFileSystem().getRoot();
    }

    private Sequence<BpmObject> getFilteredBusinessObjects() {
        Sequence<BpmObject> allBusinessObjects = this.project.getCatalogRoot().getDescendants(BpmObject.class);
        return allBusinessObjects.select((Predicate)new Predicate<BpmObject>(){

            public boolean check(@Nullable BpmObject value) {
                return value != null && !value.isFaultObject() && !value.isHidden() && !value.isFromWsdl();
            }
        });
    }

    private List<VFile> getAllSchemaFiles(VFile root) {
        VFile[] children = root.listFiles(new VFileFilter(){

            public boolean accept(@NotNull VFile pathName) {
                return pathName.isDirectory() || pathName.getName().endsWith("xsd");
            }
        });
        ArrayList<VFile> schemaFiles = new ArrayList<VFile>();
        for (VFile child : children) {
            if (child.isDirectory()) {
                schemaFiles.addAll(this.getAllSchemaFiles(child));
                continue;
            }
            schemaFiles.add(child);
        }
        return schemaFiles;
    }

    private List<URI> getSchemaURIs(Sequence<BpmObject> businessObjects, long timestamp) throws URISyntaxException, IOException {
        ArrayList<URI> schemaURIs = new ArrayList<URI>();
        File tempRulesDir = new File(Constants.TMP_RULES_DIR + timestamp);
        if (tempRulesDir.exists()) {
            IOFactory.createFileIO().deleteDirectory(tempRulesDir);
        }
        boolean result = tempRulesDir.mkdirs();
        assert (result);
        VFile projectRoot = this.getProjectRoot();
        List<VFile> allSchemaFiles = this.getAllSchemaFiles(projectRoot);
        HashMap<VFile, URI> schemaFileURIs = new HashMap<VFile, URI>();
        for (VFile schemaFile : allSchemaFiles) {
            String schemaLocation = projectRoot.toURL().toURI().relativize(schemaFile.toURL().toURI()).toString();
            if (schemaLocation.startsWith("/")) {
                schemaLocation = schemaLocation.substring(1);
            }
            String schemaRelativePath = schemaLocation.substring(0, schemaLocation.lastIndexOf("/"));
            String schemaName = schemaLocation.substring(schemaLocation.lastIndexOf("/") + 1);
            schemaRelativePath = schemaRelativePath.replace('/', File.separatorChar);
            File schemaDir = new File(tempRulesDir, schemaRelativePath);
            schemaDir.mkdirs();
            JavaFileSystem javaFileSystem = new JavaFileSystem(schemaDir);
            VFile destination = javaFileSystem.createFile(schemaName);
            VFileUtils.fileCopy((VFile)schemaFile, (VFile)destination);
            schemaFileURIs.put(schemaFile, new File(schemaDir, schemaName).toURI());
        }
        for (BpmObject businessObject : businessObjects) {
            SchemaObject schemaObject = businessObject.getDelegate().asSchemaObject();
            String schemaLocation = schemaObject.getLocation();
            assert (schemaLocation != null);
            if (schemaLocation.startsWith("http:") || schemaLocation.startsWith("https:") || schemaLocation.startsWith("oramds:")) {
                schemaURIs.add(new URI(schemaLocation));
                continue;
            }
            schemaURIs.add((URI)schemaFileURIs.get(schemaObject.getResourceLocation()));
        }
        return schemaURIs;
    }

    private BusinessRule getBusinessRuleFromCatalog(String dictionaryName, String packageName) throws AmbiguousTypeNameException {
        if (CompositeAccessorFactory.isFusionPlatform()) {
            this.project.getComponentCatalog().sync();
        }
        String normalizedDictionaryName = Identifier.classname((String)dictionaryName);
        String dictionaryModule = XmlUtils.buildValidQualifiedModuleName((String)packageName);
        String qualifiedDictionaryPath = !Str.isEmpty((String)dictionaryModule) ? dictionaryModule + "." + normalizedDictionaryName : normalizedDictionaryName;
        String ruleCatalogId = "Rules." + qualifiedDictionaryPath;
        return (BusinessRule)this.project.findCatalogObject(ruleCatalogId);
    }

    private boolean isUniqueName(@Nullable String name) {
        boolean result;
        if (name != null) {
            ScaController scaController = CompositeAccessorFactory.createScaController((Project)this.project);
            result = scaController.isNameUniqueWithinComposite(name);
        } else {
            result = false;
        }
        return result;
    }

    private String getCatalogObjectName(@NotNull String serviceName, boolean isService) {
        String name = Identifier.classname((String)serviceName);
        String result = !isService ? ServiceReferenceManager.buildExternalSynthesizedModule((CatalogInterfaceType)CatalogInterfaceType.SERVICE) + "." + name : ServiceReferenceManager.buildExternalSynthesizedModule((CatalogInterfaceType)CatalogInterfaceType.REFERENCE) + "." + name;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyInputStream(InputStream inputStream, OutputStream output) throws IOException {
        try {
            StreamUtils.copy((InputStream)inputStream, (OutputStream)output);
        }
        catch (Throwable throwable) {
            StreamUtils.close((Closeable[])new Closeable[]{inputStream, output});
            throw throwable;
        }
        StreamUtils.close((Closeable[])new Closeable[]{inputStream, output});
    }
}

